/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.usermodel;

import ai2.org.apache.poi.ddf.AbstractEscherOptRecord;
import ai2.org.apache.poi.ddf.EscherArrayProperty;
import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherOptRecord;
import ai2.org.apache.poi.ddf.EscherProperty;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.ddf.EscherSimpleProperty;
import ai2.org.apache.poi.ddf.EscherTextboxRecord;
import ai2.org.apache.poi.hslf.usermodel.HSLFAutoShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFGroupShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFLine;
import ai2.org.apache.poi.hslf.usermodel.HSLFShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFShapeContainer;
import ai2.org.apache.poi.hslf.usermodel.HSLFSheet;
import ai2.org.apache.poi.hslf.usermodel.HSLFTableCell;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextShape;
import ai2.org.apache.poi.sl.usermodel.ShapeContainer;
import ai2.org.apache.poi.sl.usermodel.TableShape;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.Units;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HSLFTable
extends HSLFGroupShape
implements HSLFShapeContainer,
TableShape<HSLFShape, HSLFTextParagraph> {
    protected static final int BORDER_TOP = 1;
    protected static final int BORDER_RIGHT = 2;
    protected static final int BORDER_BOTTOM = 3;
    protected static final int BORDER_LEFT = 4;
    protected static final int BORDERS_ALL = 5;
    protected static final int BORDERS_OUTSIDE = 6;
    protected static final int BORDERS_INSIDE = 7;
    protected static final int BORDERS_NONE = 8;
    protected HSLFTableCell[][] cells;

    public HSLFTable(int n, int n2) {
        this(n, n2, null);
    }

    public HSLFTable(int n, int n2, ShapeContainer<HSLFShape, HSLFTextParagraph> shapeContainer) {
        super(shapeContainer);
        Object object;
        if (n < 1) {
            throw new IllegalArgumentException("The number of rows must be greater than 1");
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("The number of columns must be greater than 1");
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        this.cells = new HSLFTableCell[n][n2];
        for (int i = 0; i < this.cells.length; ++i) {
            n3 = 0;
            for (int j = 0; j < this.cells[i].length; ++j) {
                this.cells[i][j] = new HSLFTableCell(this);
                object = new Rectangle(n3, n4, 100, 40);
                this.cells[i][j].setAnchor((Rectangle)object);
                n3 += 100;
            }
            n4 += 40;
        }
        n5 = n3;
        n6 = n4;
        this.setAnchor(new Rectangle(0, 0, n5, n6));
        EscherContainerRecord escherContainerRecord = (EscherContainerRecord)this.getSpContainer().getChild(0);
        EscherOptRecord escherOptRecord = new EscherOptRecord();
        escherOptRecord.setRecordId((short)-3806);
        escherOptRecord.addEscherProperty(new EscherSimpleProperty(927, 1));
        object = new EscherArrayProperty(17312, false, null);
        ((EscherArrayProperty)object).setSizeOfElements(4);
        ((EscherArrayProperty)object).setNumberOfElementsInArray(n);
        ((EscherArrayProperty)object).setNumberOfElementsInMemory(n);
        escherOptRecord.addEscherProperty((EscherProperty)object);
        escherContainerRecord.addChildBefore(escherOptRecord, 61456);
    }

    public HSLFTable(EscherContainerRecord escherContainerRecord, ShapeContainer<HSLFShape, HSLFTextParagraph> shapeContainer) {
        super(escherContainerRecord, shapeContainer);
    }

    public HSLFTableCell getCell(int n, int n2) {
        return this.cells[n][n2];
    }

    public int getNumberOfColumns() {
        return this.cells[0].length;
    }

    public int getNumberOfRows() {
        return this.cells.length;
    }

    @Override
    protected void afterInsert(HSLFSheet hSLFSheet) {
        super.afterInsert(hSLFSheet);
        EscherContainerRecord escherContainerRecord = (EscherContainerRecord)this.getSpContainer().getChild(0);
        List<EscherRecord> list = escherContainerRecord.getChildRecords();
        AbstractEscherOptRecord abstractEscherOptRecord = (AbstractEscherOptRecord)list.get(list.size() - 2);
        EscherArrayProperty escherArrayProperty = (EscherArrayProperty)abstractEscherOptRecord.lookup(928);
        for (int i = 0; i < this.cells.length; ++i) {
            HSLFTableCell hSLFTableCell = this.cells[i][0];
            int n = Units.pointsToMaster(hSLFTableCell.getAnchor().height);
            byte[] byArray = new byte[4];
            LittleEndian.putInt(byArray, 0, n);
            escherArrayProperty.setElement(i, byArray);
            for (int j = 0; j < this.cells[i].length; ++j) {
                HSLFLine hSLFLine;
                HSLFLine hSLFLine2;
                HSLFLine hSLFLine3;
                HSLFTableCell hSLFTableCell2 = this.cells[i][j];
                this.addShape(hSLFTableCell2);
                HSLFLine hSLFLine4 = hSLFTableCell2.getBorderTop();
                if (hSLFLine4 != null) {
                    this.addShape(hSLFLine4);
                }
                if ((hSLFLine3 = hSLFTableCell2.getBorderRight()) != null) {
                    this.addShape(hSLFLine3);
                }
                if ((hSLFLine2 = hSLFTableCell2.getBorderBottom()) != null) {
                    this.addShape(hSLFLine2);
                }
                if ((hSLFLine = hSLFTableCell2.getBorderLeft()) == null) continue;
                this.addShape(hSLFLine);
            }
        }
    }

    protected void initTable() {
        Object object;
        Object object2;
        List<HSLFShape> list = this.getShapes();
        Iterator<HSLFShape> iterator = list.iterator();
        while (iterator.hasNext()) {
            HSLFAutoShape hSLFAutoShape;
            HSLFShape hSLFShape = iterator.next();
            if (hSLFShape instanceof HSLFAutoShape && (object2 = (EscherTextboxRecord)(hSLFAutoShape = (HSLFAutoShape)hSLFShape).getEscherChild(-4083)) != null) continue;
            iterator.remove();
        }
        Collections.sort(list, new Comparator<HSLFShape>(){

            @Override
            public int compare(HSLFShape hSLFShape, HSLFShape hSLFShape2) {
                Rectangle rectangle = hSLFShape.getAnchor();
                Rectangle rectangle2 = hSLFShape2.getAnchor();
                int n = rectangle.y - rectangle2.y;
                if (n == 0) {
                    n = rectangle.x - rectangle2.x;
                }
                if (n == 0) {
                    n = rectangle2.width * rectangle2.height - rectangle.width * rectangle.height;
                }
                return n;
            }
        });
        int n = list.isEmpty() ? -1 : list.get((int)0).getAnchor().y - 1;
        int n2 = 0;
        object2 = new ArrayList();
        ArrayList<HSLFShape> arrayList = null;
        for (HSLFShape hSLFShape : list) {
            if (!(hSLFShape instanceof HSLFTextShape)) continue;
            object = hSLFShape.getAnchor();
            if (((Rectangle)object).y != n) {
                n = ((Rectangle)object).y;
                arrayList = new ArrayList<HSLFShape>();
                object2.add(arrayList);
            }
            arrayList.add(hSLFShape);
            n2 = Math.max(n2, arrayList.size());
        }
        this.cells = new HSLFTableCell[object2.size()][n2];
        for (int i = 0; i < object2.size(); ++i) {
            arrayList = (List)object2.get(i);
            for (int j = 0; j < arrayList.size(); ++j) {
                object = (HSLFTextShape)arrayList.get(j);
                this.cells[i][j] = new HSLFTableCell(((HSLFShape)object).getSpContainer(), this.getParent());
                this.cells[i][j].setSheet(((HSLFShape)object).getSheet());
            }
        }
    }

    @Override
    public void setSheet(HSLFSheet hSLFSheet) {
        super.setSheet(hSLFSheet);
        if (this.cells == null) {
            this.initTable();
        }
    }

    public void setRowHeight(int n, int n2) {
        int n3 = this.cells[n][0].getAnchor().height;
        int n4 = n2 - n3;
        for (int i = n; i < this.cells.length; ++i) {
            for (int j = 0; j < this.cells[i].length; ++j) {
                Rectangle rectangle = this.cells[i][j].getAnchor();
                if (i == n) {
                    rectangle.height = n2;
                } else {
                    rectangle.y += n4;
                }
                this.cells[i][j].setAnchor(rectangle);
            }
        }
        Rectangle rectangle = this.getAnchor();
        rectangle.height += n4;
        this.setAnchor(rectangle);
    }

    public void setColumnWidth(int n, int n2) {
        int n3 = this.cells[0][n].getAnchor().width;
        int n4 = n2 - n3;
        for (int i = 0; i < this.cells.length; ++i) {
            Rectangle rectangle = this.cells[i][n].getAnchor();
            rectangle.width = n2;
            this.cells[i][n].setAnchor(rectangle);
            if (n >= this.cells[i].length - 1) continue;
            for (int j = n + 1; j < this.cells[i].length; ++j) {
                rectangle = this.cells[i][j].getAnchor();
                rectangle.x += n4;
                this.cells[i][j].setAnchor(rectangle);
            }
        }
        Rectangle rectangle = this.getAnchor();
        rectangle.width += n4;
        this.setAnchor(rectangle);
    }

    public void setAllBorders(HSLFLine hSLFLine) {
        for (int i = 0; i < this.cells.length; ++i) {
            for (int j = 0; j < this.cells[i].length; ++j) {
                HSLFTableCell hSLFTableCell = this.cells[i][j];
                hSLFTableCell.setBorderTop(this.cloneBorder(hSLFLine));
                hSLFTableCell.setBorderLeft(this.cloneBorder(hSLFLine));
                if (j == this.cells[i].length - 1) {
                    hSLFTableCell.setBorderRight(this.cloneBorder(hSLFLine));
                }
                if (i != this.cells.length - 1) continue;
                hSLFTableCell.setBorderBottom(this.cloneBorder(hSLFLine));
            }
        }
    }

    public void setOutsideBorders(HSLFLine hSLFLine) {
        for (int i = 0; i < this.cells.length; ++i) {
            for (int j = 0; j < this.cells[i].length; ++j) {
                HSLFTableCell hSLFTableCell = this.cells[i][j];
                if (j == 0) {
                    hSLFTableCell.setBorderLeft(this.cloneBorder(hSLFLine));
                }
                if (j == this.cells[i].length - 1) {
                    hSLFTableCell.setBorderRight(this.cloneBorder(hSLFLine));
                } else {
                    hSLFTableCell.setBorderLeft(null);
                    hSLFTableCell.setBorderLeft(null);
                }
                if (i == 0) {
                    hSLFTableCell.setBorderTop(this.cloneBorder(hSLFLine));
                    continue;
                }
                if (i == this.cells.length - 1) {
                    hSLFTableCell.setBorderBottom(this.cloneBorder(hSLFLine));
                    continue;
                }
                hSLFTableCell.setBorderTop(null);
                hSLFTableCell.setBorderBottom(null);
            }
        }
    }

    public void setInsideBorders(HSLFLine hSLFLine) {
        for (int i = 0; i < this.cells.length; ++i) {
            for (int j = 0; j < this.cells[i].length; ++j) {
                HSLFTableCell hSLFTableCell = this.cells[i][j];
                if (j != this.cells[i].length - 1) {
                    hSLFTableCell.setBorderRight(this.cloneBorder(hSLFLine));
                } else {
                    hSLFTableCell.setBorderLeft(null);
                    hSLFTableCell.setBorderLeft(null);
                }
                if (i != this.cells.length - 1) {
                    hSLFTableCell.setBorderBottom(this.cloneBorder(hSLFLine));
                    continue;
                }
                hSLFTableCell.setBorderTop(null);
                hSLFTableCell.setBorderBottom(null);
            }
        }
    }

    private HSLFLine cloneBorder(HSLFLine hSLFLine) {
        HSLFLine hSLFLine2 = this.createBorder();
        hSLFLine2.setLineWidth(hSLFLine.getLineWidth());
        hSLFLine2.setLineDashing(hSLFLine.getLineDashing());
        hSLFLine2.setLineColor(hSLFLine.getLineColor());
        hSLFLine2.setLineCompound(hSLFLine.getLineCompound());
        return hSLFLine2;
    }

    public HSLFLine createBorder() {
        HSLFLine hSLFLine = new HSLFLine(this);
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        HSLFTable.setEscherProperty(abstractEscherOptRecord, (short)324, -1);
        HSLFTable.setEscherProperty(abstractEscherOptRecord, (short)383, -1);
        HSLFTable.setEscherProperty(abstractEscherOptRecord, (short)575, 131072);
        HSLFTable.setEscherProperty(abstractEscherOptRecord, (short)703, 524288);
        return hSLFLine;
    }
}

