/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.usermodel;

import ai2.org.apache.poi.hslf.exceptions.CorruptPowerPointFileException;
import ai2.org.apache.poi.hslf.exceptions.EncryptedPowerPointFileException;
import ai2.org.apache.poi.hslf.record.DocumentEncryptionAtom;
import ai2.org.apache.poi.hslf.record.PersistPtrHolder;
import ai2.org.apache.poi.hslf.record.PositionDependentRecord;
import ai2.org.apache.poi.hslf.record.PositionDependentRecordAtom;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.UserEditAtom;
import ai2.org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import ai2.org.apache.poi.poifs.crypt.EncryptionInfo;
import ai2.org.apache.poi.poifs.crypt.Encryptor;
import ai2.org.apache.poi.poifs.crypt.cryptoapi.CryptoAPIDecryptor;
import ai2.org.apache.poi.poifs.crypt.cryptoapi.CryptoAPIEncryptor;
import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.Internal;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Internal
public class HSLFSlideShowEncrypted {
    DocumentEncryptionAtom dea;
    CryptoAPIEncryptor enc = null;
    CryptoAPIDecryptor dec = null;
    Cipher cipher = null;
    CipherOutputStream cyos = null;
    private static final BitField fieldRecInst = new BitField(65520);

    protected HSLFSlideShowEncrypted(DocumentEncryptionAtom documentEncryptionAtom) {
        this.dea = documentEncryptionAtom;
    }

    protected HSLFSlideShowEncrypted(byte[] byArray, NavigableMap<Integer, Record> navigableMap) {
        String string;
        Object object;
        Object object2;
        Map.Entry entry2;
        UserEditAtom userEditAtom = null;
        for (Map.Entry entry2 : navigableMap.descendingMap().entrySet()) {
            object2 = (Record)entry2.getValue();
            if (!(object2 instanceof UserEditAtom) || ((UserEditAtom)(object = (UserEditAtom)object2)).getEncryptSessionPersistIdRef() == -1) continue;
            userEditAtom = object;
            break;
        }
        if (userEditAtom == null) {
            this.dea = null;
            return;
        }
        Object object3 = (Record)navigableMap.get(userEditAtom.getPersistPointersOffset());
        assert (object3 instanceof PersistPtrHolder);
        entry2 = (PersistPtrHolder)object3;
        object2 = ((PersistPtrHolder)((Object)entry2)).getSlideLocationsLookup().get(userEditAtom.getEncryptSessionPersistIdRef());
        assert (object2 != null);
        object3 = (Record)navigableMap.get(object2);
        if (object3 == null) {
            object3 = Record.buildRecordAtOffset(byArray, (Integer)object2);
            navigableMap.put((Integer)object2, (Record)object3);
        }
        assert (object3 instanceof DocumentEncryptionAtom);
        this.dea = (DocumentEncryptionAtom)object3;
        object = (CryptoAPIDecryptor)this.dea.getEncryptionInfo().getDecryptor();
        if (!((CryptoAPIDecryptor)object).verifyPassword((string = Biff8EncryptionKey.getCurrentUserPassword()) != null ? string : "VelvetSweatshop")) {
            throw new EncryptedPowerPointFileException("PowerPoint file is encrypted. The correct password needs to be set via Biff8EncryptionKey.setCurrentUserPassword()");
        }
    }

    public DocumentEncryptionAtom getDocumentEncryptionAtom() {
        return this.dea;
    }

    protected void setPersistId(int n) {
        if (this.enc != null && this.dec != null) {
            throw new EncryptedPowerPointFileException("Use instance either for en- or decryption");
        }
        try {
            if (this.enc != null) {
                this.cipher = this.enc.initCipherForBlock(this.cipher, n);
            }
            if (this.dec != null) {
                this.cipher = this.dec.initCipherForBlock(this.cipher, n);
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new EncryptedPowerPointFileException(generalSecurityException);
        }
    }

    protected void decryptInit() {
        if (this.dec != null) {
            return;
        }
        EncryptionInfo encryptionInfo = this.dea.getEncryptionInfo();
        this.dec = (CryptoAPIDecryptor)encryptionInfo.getDecryptor();
    }

    protected void encryptInit() {
        if (this.enc != null) {
            return;
        }
        EncryptionInfo encryptionInfo = this.dea.getEncryptionInfo();
        this.enc = (CryptoAPIEncryptor)encryptionInfo.getEncryptor();
    }

    protected OutputStream encryptRecord(OutputStream outputStream, int n, Record record) {
        boolean bl;
        boolean bl2 = bl = this.dea == null || record instanceof UserEditAtom || record instanceof PersistPtrHolder || record instanceof DocumentEncryptionAtom;
        if (bl) {
            return outputStream;
        }
        this.encryptInit();
        this.setPersistId(n);
        if (this.cyos == null) {
            this.cyos = new CipherOutputStream(outputStream, this.cipher);
        }
        return this.cyos;
    }

    protected void decryptRecord(byte[] byArray, int n, int n2) {
        if (this.dea == null) {
            return;
        }
        this.decryptInit();
        this.setPersistId(n);
        try {
            this.cipher.update(byArray, n2, 8, byArray, n2);
            int n3 = (int)LittleEndian.getUInt(byArray, n2 + 4);
            this.cipher.update(byArray, n2 + 8, n3, byArray, n2 + 8);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CorruptPowerPointFileException(generalSecurityException);
        }
    }

    protected void decryptPicture(byte[] byArray, int n) {
        if (this.dea == null) {
            return;
        }
        this.decryptInit();
        this.setPersistId(0);
        try {
            int n2;
            int n3;
            this.cipher.doFinal(byArray, n, 8, byArray, n);
            int n4 = fieldRecInst.getValue(LittleEndian.getUShort(byArray, n));
            int n5 = LittleEndian.getUShort(byArray, n + 2);
            int n6 = (int)LittleEndian.getUInt(byArray, n + 4);
            int n7 = (n += 8) + n6;
            if (n5 == 61447) {
                this.cipher.doFinal(byArray, n, 1, byArray, n);
                this.cipher.doFinal(byArray, ++n, 1, byArray, n);
                this.cipher.doFinal(byArray, ++n, 16, byArray, n);
                this.cipher.doFinal(byArray, n += 16, 2, byArray, n);
                this.cipher.doFinal(byArray, n += 2, 4, byArray, n);
                this.cipher.doFinal(byArray, n += 4, 4, byArray, n);
                this.cipher.doFinal(byArray, n += 4, 4, byArray, n);
                this.cipher.doFinal(byArray, (n += 4) + 0, 1, byArray, n + 0);
                this.cipher.doFinal(byArray, n + 1, 1, byArray, n + 1);
                this.cipher.doFinal(byArray, n + 2, 1, byArray, n + 2);
                this.cipher.doFinal(byArray, n + 3, 1, byArray, n + 3);
                n3 = LittleEndian.getUShort(byArray, n + 1);
                n += 4;
                if (n3 > 0) {
                    this.cipher.doFinal(byArray, n, n3, byArray, n);
                    n += n3;
                }
                if (n == n7) {
                    return;
                }
                this.cipher.doFinal(byArray, n, 8, byArray, n);
                n4 = fieldRecInst.getValue(LittleEndian.getUShort(byArray, n));
                n5 = LittleEndian.getUShort(byArray, n + 2);
                n += 8;
            }
            n3 = n4 == 535 || n4 == 981 || n4 == 1131 || n4 == 1347 || n4 == 1761 || n4 == 1763 || n4 == 1765 || n4 == 1961 ? 2 : 1;
            for (n2 = 0; n2 < n3; ++n2) {
                this.cipher.doFinal(byArray, n, 16, byArray, n);
                n += 16;
            }
            if (n5 == 61466 || n5 == 61467 || n5 == 61468) {
                this.cipher.doFinal(byArray, n, 34, byArray, n);
                n += 34;
            } else {
                this.cipher.doFinal(byArray, n, 1, byArray, n);
                ++n;
            }
            n2 = n7 - n;
            this.cipher.doFinal(byArray, n, n2, byArray, n);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CorruptPowerPointFileException(generalSecurityException);
        }
    }

    protected void encryptPicture(byte[] byArray, int n) {
        if (this.dea == null) {
            return;
        }
        this.encryptInit();
        this.setPersistId(0);
        try {
            int n2;
            int n3;
            int n4 = fieldRecInst.getValue(LittleEndian.getUShort(byArray, n));
            int n5 = LittleEndian.getUShort(byArray, n + 2);
            int n6 = (int)LittleEndian.getUInt(byArray, n + 4);
            this.cipher.doFinal(byArray, n, 8, byArray, n);
            int n7 = (n += 8) + n6;
            if (n5 == 61447) {
                this.cipher.doFinal(byArray, n, 1, byArray, n);
                this.cipher.doFinal(byArray, ++n, 1, byArray, n);
                this.cipher.doFinal(byArray, ++n, 16, byArray, n);
                this.cipher.doFinal(byArray, n += 16, 2, byArray, n);
                this.cipher.doFinal(byArray, n += 2, 4, byArray, n);
                this.cipher.doFinal(byArray, n += 4, 4, byArray, n);
                this.cipher.doFinal(byArray, n += 4, 4, byArray, n);
                n3 = LittleEndian.getUShort(byArray, (n += 4) + 1);
                this.cipher.doFinal(byArray, n + 0, 1, byArray, n + 0);
                this.cipher.doFinal(byArray, n + 1, 1, byArray, n + 1);
                this.cipher.doFinal(byArray, n + 2, 1, byArray, n + 2);
                this.cipher.doFinal(byArray, n + 3, 1, byArray, n + 3);
                n += 4;
                if (n3 > 0) {
                    this.cipher.doFinal(byArray, n, n3, byArray, n);
                    n += n3;
                }
                if (n == n7) {
                    return;
                }
                n4 = fieldRecInst.getValue(LittleEndian.getUShort(byArray, n));
                n5 = LittleEndian.getUShort(byArray, n + 2);
                this.cipher.doFinal(byArray, n, 8, byArray, n);
                n += 8;
            }
            n3 = n4 == 535 || n4 == 981 || n4 == 1131 || n4 == 1347 || n4 == 1761 || n4 == 1763 || n4 == 1765 || n4 == 1961 ? 2 : 1;
            for (n2 = 0; n2 < n3; ++n2) {
                this.cipher.doFinal(byArray, n, 16, byArray, n);
                n += 16;
            }
            if (n5 == 61466 || n5 == 61467 || n5 == 61468) {
                this.cipher.doFinal(byArray, n, 34, byArray, n);
                n += 34;
            } else {
                this.cipher.doFinal(byArray, n, 1, byArray, n);
                ++n;
            }
            n2 = n7 - n;
            this.cipher.doFinal(byArray, n, n2, byArray, n);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CorruptPowerPointFileException(generalSecurityException);
        }
    }

    protected Record[] updateEncryptionRecord(Record[] recordArray) {
        String string = Biff8EncryptionKey.getCurrentUserPassword();
        if (string == null) {
            if (this.dea == null) {
                return recordArray;
            }
            this.dea = null;
            return HSLFSlideShowEncrypted.removeEncryptionRecord(recordArray);
        }
        if (this.dea == null) {
            this.dea = new DocumentEncryptionAtom();
        }
        EncryptionInfo encryptionInfo = this.dea.getEncryptionInfo();
        byte[] byArray = encryptionInfo.getVerifier().getSalt();
        Encryptor encryptor = encryptionInfo.getEncryptor();
        if (byArray == null) {
            encryptor.confirmPassword(string);
        } else {
            byte[] byArray2 = encryptionInfo.getDecryptor().getVerifier();
            encryptor.confirmPassword(string, null, null, byArray2, byArray, null);
        }
        recordArray = HSLFSlideShowEncrypted.normalizeRecords(recordArray);
        return HSLFSlideShowEncrypted.addEncryptionRecord(recordArray, this.dea);
    }

    protected static Record[] normalizeRecords(Record[] recordArray) {
        PositionDependentRecordAtom positionDependentRecordAtom = null;
        PositionDependentRecordAtom positionDependentRecordAtom2 = null;
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        TreeMap<Integer, Record> treeMap2 = new TreeMap<Integer, Record>();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        for (Record record : recordArray) {
            assert (record instanceof PositionDependentRecord);
            PositionDependentRecord positionDependentRecord = (PositionDependentRecord)((Object)record);
            if (positionDependentRecord instanceof UserEditAtom) {
                positionDependentRecordAtom = (UserEditAtom)positionDependentRecord;
                continue;
            }
            if (positionDependentRecord instanceof PersistPtrHolder) {
                if (positionDependentRecordAtom2 != null) {
                    ++n;
                }
                positionDependentRecordAtom2 = (PersistPtrHolder)positionDependentRecord;
                for (Map.Entry<Integer, Integer> entry : ((PersistPtrHolder)positionDependentRecordAtom2).getSlideLocationsLookup().entrySet()) {
                    Integer n2 = treeMap.put(entry.getKey(), entry.getValue());
                    if (n2 == null) continue;
                    arrayList.add(n2);
                }
                continue;
            }
            treeMap2.put(positionDependentRecord.getLastOnDiskOffset(), record);
        }
        treeMap2.put(positionDependentRecordAtom2.getLastOnDiskOffset(), positionDependentRecordAtom2);
        treeMap2.put(positionDependentRecordAtom.getLastOnDiskOffset(), positionDependentRecordAtom);
        assert (positionDependentRecordAtom != null && positionDependentRecordAtom2 != null && ((UserEditAtom)positionDependentRecordAtom).getPersistPointersOffset() == positionDependentRecordAtom2.getLastOnDiskOffset());
        if (n == 0 && arrayList.isEmpty()) {
            return recordArray;
        }
        ((UserEditAtom)positionDependentRecordAtom).setLastUserEditAtomOffset(0);
        ((PersistPtrHolder)positionDependentRecordAtom2).clear();
        for (Map.Entry entry : treeMap.entrySet()) {
            ((PersistPtrHolder)positionDependentRecordAtom2).addSlideLookup((Integer)entry.getKey(), (Integer)entry.getValue());
        }
        for (Integer n3 : arrayList) {
            treeMap2.remove(n3);
        }
        return treeMap2.values().toArray(new Record[treeMap2.size()]);
    }

    protected static Record[] removeEncryptionRecord(Record[] recordArray) {
        int n = -1;
        int n2 = -1;
        PersistPtrHolder persistPtrHolder = null;
        UserEditAtom userEditAtom = null;
        ArrayList<Record> arrayList = new ArrayList<Record>();
        for (Record entry : recordArray) {
            if (entry instanceof DocumentEncryptionAtom) {
                n2 = ((DocumentEncryptionAtom)entry).getLastOnDiskOffset();
                continue;
            }
            if (entry instanceof UserEditAtom) {
                userEditAtom = (UserEditAtom)entry;
                n = userEditAtom.getEncryptSessionPersistIdRef();
                userEditAtom.setEncryptSessionPersistIdRef(-1);
            } else if (entry instanceof PersistPtrHolder) {
                persistPtrHolder = (PersistPtrHolder)entry;
            }
            arrayList.add(entry);
        }
        assert (persistPtrHolder != null);
        if (n == -1 && n2 == -1) {
            return recordArray;
        }
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>(persistPtrHolder.getSlideLocationsLookup());
        persistPtrHolder.clear();
        int n3 = -1;
        for (Map.Entry entry : treeMap.entrySet()) {
            if ((Integer)entry.getKey() == n || (Integer)entry.getValue() == n2) continue;
            persistPtrHolder.addSlideLookup((Integer)entry.getKey(), (Integer)entry.getValue());
            n3 = Math.max((Integer)entry.getKey(), n3);
        }
        userEditAtom.setMaxPersistWritten(n3);
        recordArray = arrayList.toArray(new Record[arrayList.size()]);
        return recordArray;
    }

    protected static Record[] addEncryptionRecord(Record[] recordArray, DocumentEncryptionAtom documentEncryptionAtom) {
        Object object;
        assert (documentEncryptionAtom != null);
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        for (Record recordArray22 : recordArray) {
            ++n4;
            if (recordArray22 instanceof UserEditAtom) {
                n = n4;
                continue;
            }
            if (recordArray22 instanceof PersistPtrHolder) {
                n2 = n4;
                continue;
            }
            if (!(recordArray22 instanceof DocumentEncryptionAtom)) continue;
            n3 = n4;
        }
        assert (n != -1 && n2 != -1 && n2 < n);
        if (n3 != -1) {
            object = (DocumentEncryptionAtom)recordArray[n3];
            documentEncryptionAtom.setLastOnDiskOffset(((PositionDependentRecordAtom)object).getLastOnDiskOffset());
            recordArray[n3] = documentEncryptionAtom;
            return recordArray;
        }
        object = (PersistPtrHolder)recordArray[n2];
        UserEditAtom userEditAtom = (UserEditAtom)recordArray[n];
        documentEncryptionAtom.setLastOnDiskOffset(((PositionDependentRecordAtom)object).getLastOnDiskOffset() - 1);
        int n5 = userEditAtom.getMaxPersistWritten() + 1;
        ((PersistPtrHolder)object).addSlideLookup(n5, ((PositionDependentRecordAtom)object).getLastOnDiskOffset() - 1);
        userEditAtom.setEncryptSessionPersistIdRef(n5);
        userEditAtom.setMaxPersistWritten(n5);
        Record[] recordArray2 = new Record[recordArray.length + 1];
        if (n2 > 0) {
            System.arraycopy(recordArray, 0, recordArray2, 0, n2);
        }
        if (n2 < recordArray.length - 1) {
            System.arraycopy(recordArray, n2, recordArray2, n2 + 1, recordArray.length - n2);
        }
        recordArray2[n2] = documentEncryptionAtom;
        return recordArray2;
    }
}

