/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.usermodel;

import ai2.org.apache.poi.ddf.EscherBSERecord;
import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.hpsf.ClassID;
import ai2.org.apache.poi.hslf.exceptions.CorruptPowerPointFileException;
import ai2.org.apache.poi.hslf.exceptions.HSLFException;
import ai2.org.apache.poi.hslf.model.HeadersFooters;
import ai2.org.apache.poi.hslf.model.PPFont;
import ai2.org.apache.poi.hslf.record.Document;
import ai2.org.apache.poi.hslf.record.DocumentAtom;
import ai2.org.apache.poi.hslf.record.ExAviMovie;
import ai2.org.apache.poi.hslf.record.ExControl;
import ai2.org.apache.poi.hslf.record.ExEmbed;
import ai2.org.apache.poi.hslf.record.ExEmbedAtom;
import ai2.org.apache.poi.hslf.record.ExHyperlink;
import ai2.org.apache.poi.hslf.record.ExHyperlinkAtom;
import ai2.org.apache.poi.hslf.record.ExMCIMovie;
import ai2.org.apache.poi.hslf.record.ExObjList;
import ai2.org.apache.poi.hslf.record.ExObjListAtom;
import ai2.org.apache.poi.hslf.record.ExOleObjAtom;
import ai2.org.apache.poi.hslf.record.ExOleObjStg;
import ai2.org.apache.poi.hslf.record.ExVideoContainer;
import ai2.org.apache.poi.hslf.record.FontCollection;
import ai2.org.apache.poi.hslf.record.FontEntityAtom;
import ai2.org.apache.poi.hslf.record.HeadersFootersContainer;
import ai2.org.apache.poi.hslf.record.MainMaster;
import ai2.org.apache.poi.hslf.record.Notes;
import ai2.org.apache.poi.hslf.record.PersistPtrHolder;
import ai2.org.apache.poi.hslf.record.PositionDependentRecord;
import ai2.org.apache.poi.hslf.record.PositionDependentRecordContainer;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordContainer;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.hslf.record.Slide;
import ai2.org.apache.poi.hslf.record.SlideListWithText;
import ai2.org.apache.poi.hslf.record.SlidePersistAtom;
import ai2.org.apache.poi.hslf.record.UserEditAtom;
import ai2.org.apache.poi.hslf.usermodel.HSLFHyperlink;
import ai2.org.apache.poi.hslf.usermodel.HSLFMasterSheet;
import ai2.org.apache.poi.hslf.usermodel.HSLFNotes;
import ai2.org.apache.poi.hslf.usermodel.HSLFObjectData;
import ai2.org.apache.poi.hslf.usermodel.HSLFPictureData;
import ai2.org.apache.poi.hslf.usermodel.HSLFShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFSheet;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlide;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlideMaster;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlideShowImpl;
import ai2.org.apache.poi.hslf.usermodel.HSLFSoundData;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFTitleMaster;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import ai2.org.apache.poi.sl.usermodel.MasterSheet;
import ai2.org.apache.poi.sl.usermodel.PictureData;
import ai2.org.apache.poi.sl.usermodel.Resources;
import ai2.org.apache.poi.sl.usermodel.SlideShow;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.util.Units;
import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HSLFSlideShow
implements SlideShow<HSLFShape, HSLFTextParagraph> {
    private HSLFSlideShowImpl _hslfSlideShow;
    private Record[] _mostRecentCoreRecords;
    private Map<Integer, Integer> _sheetIdToCoreRecordsLookup;
    private Document _documentRecord;
    private final List<HSLFSlideMaster> _masters = new ArrayList<HSLFSlideMaster>();
    private final List<HSLFTitleMaster> _titleMasters = new ArrayList<HSLFTitleMaster>();
    private final List<HSLFSlide> _slides = new ArrayList<HSLFSlide>();
    private final List<HSLFNotes> _notes = new ArrayList<HSLFNotes>();
    private FontCollection _fonts;
    private POILogger logger = POILogFactory.getLogger(this.getClass());

    public HSLFSlideShow(HSLFSlideShowImpl hSLFSlideShowImpl) {
        this._hslfSlideShow = hSLFSlideShowImpl;
        for (Record record : this._hslfSlideShow.getRecords()) {
            if (!(record instanceof RecordContainer)) continue;
            RecordContainer.handleParentAwareRecords((RecordContainer)record);
        }
        this.findMostRecentCoreRecords();
        this.buildSlidesAndNotes();
    }

    public HSLFSlideShow() {
        this(HSLFSlideShowImpl.create());
    }

    public HSLFSlideShow(InputStream inputStream) throws IOException {
        this(new HSLFSlideShowImpl(inputStream));
    }

    public HSLFSlideShow(NPOIFSFileSystem nPOIFSFileSystem) throws IOException {
        this(new HSLFSlideShowImpl(nPOIFSFileSystem));
    }

    public HSLFSlideShow(DirectoryNode directoryNode) throws IOException {
        this(new HSLFSlideShowImpl(directoryNode));
    }

    private void findMostRecentCoreRecords() {
        int n;
        Object object;
        int n22;
        Object object2;
        HashMap hashMap = new HashMap();
        for (Record object3 : this._hslfSlideShow.getRecords()) {
            if (!(object3 instanceof PersistPtrHolder)) continue;
            PersistPtrHolder persistPtrHolder = (PersistPtrHolder)object3;
            for (int n22 : object2 = persistPtrHolder.getKnownSlideIDs()) {
                if (!hashMap.containsKey(n22)) continue;
                hashMap.remove(n22);
            }
            object = persistPtrHolder.getSlideLocationsLookup();
            int[] nArray = object2;
            int n3 = nArray.length;
            for (n22 = 0; n22 < n3; ++n22) {
                int n4 = nArray[n22];
                hashMap.put(n4, object.get(n4));
            }
        }
        this._mostRecentCoreRecords = new Record[hashMap.size()];
        this._sheetIdToCoreRecordsLookup = new HashMap<Integer, Integer>();
        Object[] objectArray = hashMap.keySet().toArray(new Integer[hashMap.size()]);
        Arrays.sort(objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            this._sheetIdToCoreRecordsLookup.put((Integer)objectArray[i], i);
        }
        HashMap hashMap2 = new HashMap(hashMap.size());
        for (Map.Entry entry : hashMap.entrySet()) {
            hashMap2.put(entry.getValue(), entry.getKey());
        }
        Record[] recordArray = this._hslfSlideShow.getRecords();
        int n5 = recordArray.length;
        for (n = 0; n < n5; ++n) {
            int n6;
            Integer n7;
            object2 = recordArray[n];
            if (!(object2 instanceof PositionDependentRecord) || (n7 = (Integer)hashMap2.get(n6 = (object = (PositionDependentRecord)object2).getLastOnDiskOffset())) == null) continue;
            n22 = this._sheetIdToCoreRecordsLookup.get(n7);
            if (object instanceof PositionDependentRecordContainer) {
                PositionDependentRecordContainer positionDependentRecordContainer = (PositionDependentRecordContainer)object2;
                positionDependentRecordContainer.setSheetId(n7);
            }
            this._mostRecentCoreRecords[n22] = object2;
        }
        recordArray = this._mostRecentCoreRecords;
        int n8 = recordArray.length;
        for (n = 0; n < n8; ++n) {
            object2 = recordArray[n];
            if (object2 == null || ((Record)object2).getRecordType() != (long)RecordTypes.Document.typeID) continue;
            this._documentRecord = (Document)object2;
            this._fonts = this._documentRecord.getEnvironment().getFontCollection();
        }
    }

    private Record getCoreRecordForSAS(SlideListWithText.SlideAtomsSet slideAtomsSet) {
        SlidePersistAtom slidePersistAtom = slideAtomsSet.getSlidePersistAtom();
        int n = slidePersistAtom.getRefID();
        return this.getCoreRecordForRefID(n);
    }

    private Record getCoreRecordForRefID(int n) {
        Integer n2 = this._sheetIdToCoreRecordsLookup.get(n);
        if (n2 != null) {
            Record record = this._mostRecentCoreRecords[n2];
            return record;
        }
        this.logger.log(7, new Object[]{"We tried to look up a reference to a core record, but there was no core ID for reference ID " + n});
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void buildSlidesAndNotes() {
        void var8_20;
        Slide[] slideArray;
        Object object;
        Object object2;
        Object[] objectArray;
        if (this._documentRecord == null) {
            throw new CorruptPowerPointFileException("The PowerPoint file didn't contain a Document Record in its PersistPtr blocks. It is probably corrupt.");
        }
        SlideListWithText slideListWithText = this._documentRecord.getMasterSlideListWithText();
        SlideListWithText slideListWithText2 = this._documentRecord.getSlideSlideListWithText();
        SlideListWithText slideListWithText3 = this._documentRecord.getNotesSlideListWithText();
        if (slideListWithText != null) {
            for (SlideListWithText.SlideAtomsSet slideAtomsSet : slideListWithText.getSlideAtomsSets()) {
                HSLFMasterSheet hSLFMasterSheet;
                Record object3 = this.getCoreRecordForSAS(slideAtomsSet);
                int n = slideAtomsSet.getSlidePersistAtom().getSlideIdentifier();
                if (object3 instanceof Slide) {
                    hSLFMasterSheet = new HSLFTitleMaster((Slide)object3, n);
                    hSLFMasterSheet.setSlideShow(this);
                    this._titleMasters.add((HSLFTitleMaster)hSLFMasterSheet);
                    continue;
                }
                if (!(object3 instanceof MainMaster)) continue;
                hSLFMasterSheet = new HSLFSlideMaster((MainMaster)object3, n);
                ((HSLFSlideMaster)hSLFMasterSheet).setSlideShow(this);
                this._masters.add((HSLFSlideMaster)hSLFMasterSheet);
            }
        }
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        if (slideListWithText3 == null) {
            objectArray = new Notes[]{};
        } else {
            ArrayList<Notes> arrayList = new ArrayList<Notes>();
            int n = -1;
            for (SlideListWithText.SlideAtomsSet slideAtomsSet : slideListWithText3.getSlideAtomsSets()) {
                object2 = this.getCoreRecordForSAS(slideAtomsSet);
                object = slideAtomsSet.getSlidePersistAtom();
                String string = "A Notes SlideAtomSet at " + ++n + " said its record was at refID " + ((SlidePersistAtom)object).getRefID();
                if (object2 == null || object2 instanceof Notes) {
                    if (object2 == null) {
                        this.logger.log(5, new Object[]{string + ", but that record didn't exist - record ignored."});
                    }
                    Notes notes = (Notes)object2;
                    arrayList.add(notes);
                    int n2 = ((SlidePersistAtom)object).getSlideIdentifier();
                    hashMap.put(n2, n);
                    continue;
                }
                this.logger.log(7, new Object[]{string + ", but that was actually a " + object2});
            }
            objectArray = new Notes[arrayList.size()];
            objectArray = (Notes[])arrayList.toArray(objectArray);
        }
        SlideListWithText.SlideAtomsSet[] slideAtomsSetArray = new SlideListWithText.SlideAtomsSet[]{};
        if (slideListWithText2 == null) {
            slideArray = new Slide[]{};
        } else {
            void var8_17;
            slideAtomsSetArray = slideListWithText2.getSlideAtomsSets();
            slideArray = new Slide[slideAtomsSetArray.length];
            boolean i = false;
            while (var8_17 < slideAtomsSetArray.length) {
                Record record = this.getCoreRecordForSAS(slideAtomsSetArray[var8_17]);
                if (record instanceof Slide) {
                    slideArray[var8_17] = (Slide)record;
                } else {
                    this.logger.log(7, new Object[]{"A Slide SlideAtomSet at " + (int)var8_17 + " said its record was at refID " + slideAtomsSetArray[var8_17].getSlidePersistAtom().getRefID() + ", but that was actually a " + record});
                }
                ++var8_17;
            }
        }
        for (Object object3 : objectArray) {
            object2 = null;
            if (object3 != null) {
                object2 = new HSLFNotes((Notes)object3);
                ((HSLFSheet)object2).setSlideShow(this);
            }
            this._notes.add((HSLFNotes)object2);
        }
        boolean bl = false;
        while (var8_20 < slideArray.length) {
            void var11_35;
            SlideListWithText.SlideAtomsSet slideAtomsSet = slideAtomsSetArray[var8_20];
            int n = slideAtomsSet.getSlidePersistAtom().getSlideIdentifier();
            Object var11_33 = null;
            int n3 = slideArray[var8_20].getSlideAtom().getNotesID();
            if (n3 != 0) {
                object = (Integer)hashMap.get(n3);
                if (object != null) {
                    HSLFNotes hSLFNotes = this._notes.get((Integer)object);
                } else {
                    this.logger.log(7, new Object[]{"Notes not found for noteId=" + n3});
                }
            }
            object = new HSLFSlide(slideArray[var8_20], (HSLFNotes)var11_35, slideAtomsSet, n, (int)(var8_20 + true));
            ((HSLFSheet)object).setSlideShow(this);
            this._slides.add((HSLFSlide)object);
            ++var8_20;
        }
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        for (HSLFSlide hSLFSlide : this.getSlides()) {
            for (HSLFShape hSLFShape : hSLFSlide.getShapes()) {
                if (!(hSLFShape instanceof HSLFTextShape)) continue;
                HSLFTextShape hSLFTextShape = (HSLFTextShape)hSLFShape;
                boolean bl = false;
                for (HSLFTextParagraph hSLFTextParagraph : hSLFTextShape.getTextParagraphs()) {
                    bl |= hSLFTextParagraph.isDirty();
                }
                if (!bl) continue;
                hSLFTextShape.storeText();
            }
        }
        this._hslfSlideShow.write(outputStream);
    }

    public Record[] getMostRecentCoreRecords() {
        return this._mostRecentCoreRecords;
    }

    @Override
    public List<HSLFSlide> getSlides() {
        return this._slides;
    }

    public List<HSLFNotes> getNotes() {
        return this._notes;
    }

    @Override
    public List<HSLFSlideMaster> getSlideMasters() {
        return this._masters;
    }

    public List<HSLFTitleMaster> getTitleMasters() {
        return this._titleMasters;
    }

    @Override
    public List<HSLFPictureData> getPictureData() {
        return this._hslfSlideShow.getPictureData();
    }

    public HSLFObjectData[] getEmbeddedObjects() {
        return this._hslfSlideShow.getEmbeddedObjects();
    }

    public HSLFSoundData[] getSoundData() {
        return HSLFSoundData.find(this._documentRecord);
    }

    @Override
    public Dimension getPageSize() {
        DocumentAtom documentAtom = this._documentRecord.getDocumentAtom();
        int n = (int)Units.masterToPoints((int)documentAtom.getSlideSizeX());
        int n2 = (int)Units.masterToPoints((int)documentAtom.getSlideSizeY());
        return new Dimension(n, n2);
    }

    public void setPageSize(Dimension dimension) {
        DocumentAtom documentAtom = this._documentRecord.getDocumentAtom();
        documentAtom.setSlideSizeX(Units.pointsToMaster(dimension.width));
        documentAtom.setSlideSizeY(Units.pointsToMaster(dimension.height));
    }

    protected FontCollection getFontCollection() {
        return this._fonts;
    }

    public Document getDocumentRecord() {
        return this._documentRecord;
    }

    public void reorderSlide(int n, int n2) {
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException("Old and new slide numbers must be greater than 0");
        }
        if (n > this._slides.size() || n2 > this._slides.size()) {
            throw new IllegalArgumentException("Old and new slide numbers must not exceed the number of slides (" + this._slides.size() + ")");
        }
        SlideListWithText slideListWithText = this._documentRecord.getSlideSlideListWithText();
        SlideListWithText.SlideAtomsSet[] slideAtomsSetArray = slideListWithText.getSlideAtomsSets();
        SlideListWithText.SlideAtomsSet slideAtomsSet = slideAtomsSetArray[n - 1];
        slideAtomsSetArray[n - 1] = slideAtomsSetArray[n2 - 1];
        slideAtomsSetArray[n2 - 1] = slideAtomsSet;
        Collections.swap(this._slides, n - 1, n2 - 1);
        this._slides.get(n2 - 1).setSlideNumber(n2);
        this._slides.get(n - 1).setSlideNumber(n);
        ArrayList<Record> arrayList = new ArrayList<Record>();
        for (SlideListWithText.SlideAtomsSet slideAtomsSet2 : slideAtomsSetArray) {
            arrayList.add(slideAtomsSet2.getSlidePersistAtom());
            arrayList.addAll(Arrays.asList(slideAtomsSet2.getSlideRecords()));
        }
        Object[] objectArray = arrayList.toArray(new Record[arrayList.size()]);
        slideListWithText.setChildRecord((Record[])objectArray);
    }

    public HSLFSlide removeSlide(int n) {
        int n2;
        int n3 = this._slides.size() - 1;
        if (n < 0 || n > n3) {
            throw new IllegalArgumentException("Slide index (" + n + ") is out of range (0.." + n3 + ")");
        }
        SlideListWithText slideListWithText = this._documentRecord.getSlideSlideListWithText();
        SlideListWithText.SlideAtomsSet[] slideAtomsSetArray = slideListWithText.getSlideAtomsSets();
        ArrayList<Record> arrayList = new ArrayList<Record>();
        ArrayList<SlideListWithText.SlideAtomsSet> arrayList2 = new ArrayList<SlideListWithText.SlideAtomsSet>(Arrays.asList(slideAtomsSetArray));
        HSLFSlide hSLFSlide = this._slides.remove(n);
        this._notes.remove(hSLFSlide.getNotes());
        arrayList2.remove(n);
        int n4 = 0;
        for (HSLFSlide object : this._slides) {
            object.setSlideNumber(n4++);
        }
        for (SlideListWithText.SlideAtomsSet slideAtomsSet : arrayList2) {
            arrayList.add(slideAtomsSet.getSlidePersistAtom());
            arrayList.addAll(Arrays.asList(slideAtomsSet.getSlideRecords()));
        }
        if (arrayList2.isEmpty()) {
            this._documentRecord.removeSlideListWithText(slideListWithText);
        } else {
            slideListWithText.setSlideAtomsSets(arrayList2.toArray(new SlideListWithText.SlideAtomsSet[arrayList2.size()]));
            slideListWithText.setChildRecord(arrayList.toArray(new Record[arrayList.size()]));
        }
        int n5 = n2 = hSLFSlide != null ? hSLFSlide.getSlideRecord().getSlideAtom().getNotesID() : 0;
        if (n2 != 0) {
            SlideListWithText slideListWithText2 = this._documentRecord.getNotesSlideListWithText();
            arrayList = new ArrayList();
            ArrayList<SlideListWithText.SlideAtomsSet> arrayList3 = new ArrayList<SlideListWithText.SlideAtomsSet>();
            for (SlideListWithText.SlideAtomsSet slideAtomsSet : slideListWithText2.getSlideAtomsSets()) {
                if (slideAtomsSet.getSlidePersistAtom().getSlideIdentifier() == n2) continue;
                arrayList3.add(slideAtomsSet);
                arrayList.add(slideAtomsSet.getSlidePersistAtom());
                if (slideAtomsSet.getSlideRecords() == null) continue;
                arrayList.addAll(Arrays.asList(slideAtomsSet.getSlideRecords()));
            }
            if (arrayList3.isEmpty()) {
                this._documentRecord.removeSlideListWithText(slideListWithText2);
            } else {
                slideListWithText2.setSlideAtomsSets(arrayList3.toArray(new SlideListWithText.SlideAtomsSet[arrayList3.size()]));
                slideListWithText2.setChildRecord(arrayList.toArray(new Record[arrayList.size()]));
            }
        }
        return hSLFSlide;
    }

    public HSLFSlide createSlide() {
        SlideListWithText slideListWithText = null;
        slideListWithText = this._documentRecord.getSlideSlideListWithText();
        if (slideListWithText == null) {
            slideListWithText = new SlideListWithText();
            slideListWithText.setInstance(0);
            this._documentRecord.addSlideListWithText(slideListWithText);
        }
        SlidePersistAtom slidePersistAtom = null;
        for (SlideListWithText.SlideAtomsSet slideAtomsSet : slideListWithText.getSlideAtomsSets()) {
            SlidePersistAtom slidePersistAtom2 = slideAtomsSet.getSlidePersistAtom();
            if (slidePersistAtom2.getSlideIdentifier() < 0) continue;
            if (slidePersistAtom == null) {
                slidePersistAtom = slidePersistAtom2;
            }
            if (slidePersistAtom.getSlideIdentifier() >= slidePersistAtom2.getSlideIdentifier()) continue;
            slidePersistAtom = slidePersistAtom2;
        }
        SlidePersistAtom slidePersistAtom3 = new SlidePersistAtom();
        slidePersistAtom3.setSlideIdentifier(slidePersistAtom == null ? 256 : slidePersistAtom.getSlideIdentifier() + 1);
        slideListWithText.addSlidePersistAtom(slidePersistAtom3);
        HSLFSlide hSLFSlide = new HSLFSlide(slidePersistAtom3.getSlideIdentifier(), slidePersistAtom3.getRefID(), this._slides.size() + 1);
        hSLFSlide.setSlideShow(this);
        hSLFSlide.onCreate();
        this._slides.add(hSLFSlide);
        this.logger.log(3, new Object[]{"Added slide " + this._slides.size() + " with ref " + slidePersistAtom3.getRefID() + " and identifier " + slidePersistAtom3.getSlideIdentifier()});
        Slide slide = hSLFSlide.getSlideRecord();
        int n = this.addPersistentObject(slide);
        slidePersistAtom3.setRefID(n);
        slide.setSheetId(n);
        hSLFSlide.setMasterSheet(this._masters.get(0));
        return hSLFSlide;
    }

    @Override
    public HSLFPictureData addPicture(byte[] byArray, PictureData.PictureType pictureType) throws IOException {
        if (pictureType == null || pictureType.nativeId == -1) {
            throw new IllegalArgumentException("Unsupported picture format: " + (Object)((Object)pictureType));
        }
        byte[] byArray2 = HSLFPictureData.getChecksum(byArray);
        for (HSLFPictureData object2 : this.getPictureData()) {
            if (!Arrays.equals(object2.getUID(), byArray2)) continue;
            return object2;
        }
        EscherContainerRecord escherContainerRecord = this._documentRecord.getPPDrawingGroup().getDggContainer();
        Object object3 = (EscherContainerRecord)HSLFShape.getEscherChild(escherContainerRecord, -4095);
        if (object3 == null) {
            object3 = new EscherContainerRecord();
            ((EscherRecord)object3).setRecordId((short)-4095);
            escherContainerRecord.addChildBefore((EscherRecord)object3, -4085);
        }
        HSLFPictureData hSLFPictureData = HSLFPictureData.create(pictureType);
        hSLFPictureData.setData(byArray);
        int n = this._hslfSlideShow.addPicture(hSLFPictureData);
        EscherBSERecord escherBSERecord = new EscherBSERecord();
        escherBSERecord.setRecordId((short)-4089);
        escherBSERecord.setOptions((short)(2 | pictureType.nativeId << 4));
        escherBSERecord.setSize(hSLFPictureData.getRawData().length + 8);
        escherBSERecord.setUid(byArray2);
        escherBSERecord.setBlipTypeMacOS((byte)pictureType.nativeId);
        escherBSERecord.setBlipTypeWin32((byte)pictureType.nativeId);
        if (pictureType == PictureData.PictureType.EMF) {
            escherBSERecord.setBlipTypeMacOS((byte)PictureData.PictureType.PICT.nativeId);
        } else if (pictureType == PictureData.PictureType.WMF) {
            escherBSERecord.setBlipTypeMacOS((byte)PictureData.PictureType.PICT.nativeId);
        } else if (pictureType == PictureData.PictureType.PICT) {
            escherBSERecord.setBlipTypeWin32((byte)PictureData.PictureType.WMF.nativeId);
        }
        escherBSERecord.setRef(0);
        escherBSERecord.setOffset(n);
        escherBSERecord.setRemainingData(new byte[0]);
        ((EscherContainerRecord)object3).addChildRecord(escherBSERecord);
        int n2 = ((EscherContainerRecord)object3).getChildRecords().size();
        ((EscherRecord)object3).setOptions((short)(n2 << 4 | 0xF));
        return hSLFPictureData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HSLFPictureData addPicture(File file, PictureData.PictureType pictureType) throws IOException {
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileInputStream.read(byArray);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        return this.addPicture(byArray, pictureType);
    }

    public int addFont(PPFont pPFont) {
        FontCollection fontCollection = this.getDocumentRecord().getEnvironment().getFontCollection();
        int n = fontCollection.getFontIndex(pPFont.getFontName());
        if (n == -1) {
            n = fontCollection.addFont(pPFont.getFontName(), pPFont.getCharSet(), pPFont.getFontFlags(), pPFont.getFontType(), pPFont.getPitchAndFamily());
        }
        return n;
    }

    public PPFont getFont(int n) {
        FontCollection fontCollection = this.getDocumentRecord().getEnvironment().getFontCollection();
        for (Record record : fontCollection.getChildRecords()) {
            FontEntityAtom fontEntityAtom;
            if (!(record instanceof FontEntityAtom) || (fontEntityAtom = (FontEntityAtom)record).getFontIndex() != n) continue;
            return new PPFont(fontEntityAtom);
        }
        return null;
    }

    public int getNumberOfFonts() {
        return this.getDocumentRecord().getEnvironment().getFontCollection().getNumberOfFonts();
    }

    public HeadersFooters getSlideHeadersFooters() {
        String string = this.getSlideMasters().get(0).getProgrammableTag();
        boolean bl = "___PPT12".equals(string);
        HeadersFootersContainer headersFootersContainer = null;
        for (Record record : this._documentRecord.getChildRecords()) {
            if (!(record instanceof HeadersFootersContainer) || ((HeadersFootersContainer)record).getOptions() != 63) continue;
            headersFootersContainer = (HeadersFootersContainer)record;
            break;
        }
        boolean bl2 = false;
        if (headersFootersContainer == null) {
            headersFootersContainer = new HeadersFootersContainer(63);
            bl2 = true;
        }
        return new HeadersFooters(headersFootersContainer, this, bl2, bl);
    }

    public HeadersFooters getNotesHeadersFooters() {
        String string = this.getSlideMasters().get(0).getProgrammableTag();
        boolean bl = "___PPT12".equals(string);
        HeadersFootersContainer headersFootersContainer = null;
        for (Record record : this._documentRecord.getChildRecords()) {
            if (!(record instanceof HeadersFootersContainer) || ((HeadersFootersContainer)record).getOptions() != 79) continue;
            headersFootersContainer = (HeadersFootersContainer)record;
            break;
        }
        boolean bl2 = false;
        if (headersFootersContainer == null) {
            headersFootersContainer = new HeadersFootersContainer(79);
            bl2 = true;
        }
        if (bl && !this._notes.isEmpty()) {
            return new HeadersFooters(headersFootersContainer, this._notes.get(0), bl2, bl);
        }
        return new HeadersFooters(headersFootersContainer, this, bl2, bl);
    }

    public int addMovie(String string, int n) {
        ExMCIMovie exMCIMovie;
        switch (n) {
            case 1: {
                exMCIMovie = new ExMCIMovie();
                break;
            }
            case 2: {
                exMCIMovie = new ExAviMovie();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Movie: " + n);
            }
        }
        ExVideoContainer exVideoContainer = exMCIMovie.getExVideo();
        exVideoContainer.getExMediaAtom().setMask(0xE80000);
        exVideoContainer.getPathAtom().setText(string);
        int n2 = this.addToObjListAtom(exMCIMovie);
        exVideoContainer.getExMediaAtom().setObjectId(n2);
        return n2;
    }

    public int addControl(String string, String string2) {
        ExControl exControl = new ExControl();
        exControl.setProgId(string2);
        exControl.setMenuName(string);
        exControl.setClipboardName(string);
        ExOleObjAtom exOleObjAtom = exControl.getExOleObjAtom();
        exOleObjAtom.setDrawAspect(1);
        exOleObjAtom.setType(2);
        exOleObjAtom.setSubType(0);
        int n = this.addToObjListAtom(exControl);
        exOleObjAtom.setObjID(n);
        return n;
    }

    public int addHyperlink(HSLFHyperlink hSLFHyperlink) {
        ExHyperlink exHyperlink = new ExHyperlink();
        ExHyperlinkAtom exHyperlinkAtom = exHyperlink.getExHyperlinkAtom();
        if (hSLFHyperlink.getType() == 7) {
            exHyperlink.setLinkURL(hSLFHyperlink.getAddress(), 48);
        } else {
            exHyperlink.setLinkURL(hSLFHyperlink.getAddress());
        }
        exHyperlink.setLinkTitle(hSLFHyperlink.getTitle());
        int n = this.addToObjListAtom(exHyperlink);
        hSLFHyperlink.setId(n);
        exHyperlinkAtom.setNumber(n);
        return n;
    }

    public int addEmbed(POIFSFileSystem pOIFSFileSystem) {
        Map.Entry entry2;
        Object object;
        Object object2;
        DirectoryNode directoryNode = pOIFSFileSystem.getRoot();
        if (new ClassID().equals(directoryNode.getStorageClsid())) {
            object2 = HSLFSlideShow.getOleMap();
            object = null;
            for (Map.Entry entry2 : object2.entrySet()) {
                if (!directoryNode.hasEntry((String)entry2.getKey())) continue;
                object = (ClassID)entry2.getValue();
                break;
            }
            if (object == null) {
                throw new IllegalArgumentException("Unsupported embedded document");
            }
            directoryNode.setStorageClsid((ClassID)object);
        }
        object2 = new ExEmbed();
        object = ((RecordContainer)object2).getChildRecords();
        ((RecordContainer)object2).removeChild(object[2]);
        ((RecordContainer)object2).removeChild(object[3]);
        ((RecordContainer)object2).removeChild(object[4]);
        ExEmbedAtom exEmbedAtom = ((ExEmbed)object2).getExEmbedAtom();
        exEmbedAtom.setCantLockServerB(true);
        entry2 = ((ExEmbed)object2).getExOleObjAtom();
        ((ExOleObjAtom)((Object)entry2)).setDrawAspect(1);
        ((ExOleObjAtom)((Object)entry2)).setType(0);
        ((ExOleObjAtom)((Object)entry2)).setOptions(1226240);
        ExOleObjStg exOleObjStg = new ExOleObjStg();
        try {
            Object object3;
            if (!directoryNode.hasEntry("\u0001Ole")) {
                object3 = new byte[]{1, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                pOIFSFileSystem.createDocument(new ByteArrayInputStream((byte[])object3), "\u0001Ole");
            }
            object3 = new ByteArrayOutputStream();
            pOIFSFileSystem.writeFilesystem((OutputStream)object3);
            exOleObjStg.setData(((ByteArrayOutputStream)object3).toByteArray());
        }
        catch (IOException iOException) {
            throw new HSLFException(iOException);
        }
        int n = this.addPersistentObject(exOleObjStg);
        exOleObjStg.setPersistId(n);
        ((ExOleObjAtom)((Object)entry2)).setObjStgDataRef(n);
        int n2 = this.addToObjListAtom((RecordContainer)object2);
        ((ExOleObjAtom)((Object)entry2)).setObjID(n2);
        return n2;
    }

    protected int addToObjListAtom(RecordContainer recordContainer) {
        ExObjList exObjList = (ExObjList)this._documentRecord.findFirstOfType(RecordTypes.ExObjList.typeID);
        if (exObjList == null) {
            exObjList = new ExObjList();
            this._documentRecord.addChildAfter(exObjList, this._documentRecord.getDocumentAtom());
        }
        ExObjListAtom exObjListAtom = exObjList.getExObjListAtom();
        int n = (int)exObjListAtom.getObjectIDSeed() + 1;
        exObjListAtom.setObjectIDSeed(n);
        exObjList.addChildAfter(recordContainer, exObjListAtom);
        return n;
    }

    protected static Map<String, ClassID> getOleMap() {
        HashMap<String, ClassID> hashMap = new HashMap<String, ClassID>();
        hashMap.put("PowerPoint Document", ClassID.PPT_SHOW);
        hashMap.put("Workbook", ClassID.EXCEL97);
        hashMap.put("WORKBOOK", ClassID.EXCEL97);
        hashMap.put("BOOK", ClassID.EXCEL97);
        return hashMap;
    }

    protected int addPersistentObject(PositionDependentRecord positionDependentRecord) {
        positionDependentRecord.setLastOnDiskOffset(-1);
        this._hslfSlideShow.appendRootLevelRecord((Record)((Object)positionDependentRecord));
        HashMap<RecordTypes.Type, PositionDependentRecord> hashMap = new HashMap<RecordTypes.Type, PositionDependentRecord>();
        try {
            this._hslfSlideShow.updateAndWriteDependantRecords(null, hashMap);
        }
        catch (IOException iOException) {
            throw new HSLFException(iOException);
        }
        PersistPtrHolder persistPtrHolder = (PersistPtrHolder)hashMap.get(RecordTypes.PersistPtrIncrementalBlock);
        UserEditAtom userEditAtom = (UserEditAtom)hashMap.get(RecordTypes.UserEditAtom);
        int n = userEditAtom.getMaxPersistWritten() + 1;
        userEditAtom.setLastViewType((short)1);
        userEditAtom.setMaxPersistWritten(n);
        int n2 = positionDependentRecord.getLastOnDiskOffset();
        positionDependentRecord.setLastOnDiskOffset(n2);
        persistPtrHolder.addSlideLookup(n, n2);
        this.logger.log(3, new Object[]{"New slide/object ended up at " + n2});
        return n;
    }

    @Override
    public MasterSheet<HSLFShape, HSLFTextParagraph> createMasterSheet() throws IOException {
        return null;
    }

    @Override
    public Resources getResources() {
        return null;
    }
}

