/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.usermodel;

import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherDgRecord;
import ai2.org.apache.poi.ddf.EscherDggRecord;
import ai2.org.apache.poi.ddf.EscherSpRecord;
import ai2.org.apache.poi.hslf.model.Comment;
import ai2.org.apache.poi.hslf.model.HeadersFooters;
import ai2.org.apache.poi.hslf.model.Placeholder;
import ai2.org.apache.poi.hslf.record.ColorSchemeAtom;
import ai2.org.apache.poi.hslf.record.Comment2000;
import ai2.org.apache.poi.hslf.record.EscherTextboxWrapper;
import ai2.org.apache.poi.hslf.record.HeadersFootersContainer;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordContainer;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.hslf.record.SSSlideInfoAtom;
import ai2.org.apache.poi.hslf.record.SlideAtom;
import ai2.org.apache.poi.hslf.record.SlideListWithText;
import ai2.org.apache.poi.hslf.record.StyleTextProp9Atom;
import ai2.org.apache.poi.hslf.usermodel.HSLFBackground;
import ai2.org.apache.poi.hslf.usermodel.HSLFMasterSheet;
import ai2.org.apache.poi.hslf.usermodel.HSLFNotes;
import ai2.org.apache.poi.hslf.usermodel.HSLFShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFSheet;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlideMaster;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextBox;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFTitleMaster;
import ai2.org.apache.poi.sl.draw.DrawFactory;
import ai2.org.apache.poi.sl.draw.DrawSlide;
import ai2.org.apache.poi.sl.usermodel.Notes;
import ai2.org.apache.poi.sl.usermodel.ShapeType;
import ai2.org.apache.poi.sl.usermodel.Slide;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HSLFSlide
extends HSLFSheet
implements Slide<HSLFShape, HSLFTextParagraph> {
    private int _slideNo;
    private SlideListWithText.SlideAtomsSet _atomSet;
    private final List<List<HSLFTextParagraph>> _paragraphs = new ArrayList<List<HSLFTextParagraph>>();
    private HSLFNotes _notes;

    public HSLFSlide(ai2.org.apache.poi.hslf.record.Slide slide, HSLFNotes hSLFNotes, SlideListWithText.SlideAtomsSet slideAtomsSet, int n, int n2) {
        super(slide, n);
        this._notes = hSLFNotes;
        this._atomSet = slideAtomsSet;
        this._slideNo = n2;
        if (this._atomSet != null && this._atomSet.getSlideRecords().length > 0) {
            this._paragraphs.addAll(HSLFTextParagraph.findTextParagraphs(this._atomSet.getSlideRecords()));
            if (this._paragraphs.isEmpty()) {
                throw new RuntimeException("No text records found for slide");
            }
        }
        for (List<HSLFTextParagraph> list : HSLFTextParagraph.findTextParagraphs(this.getPPDrawing(), (HSLFSheet)this)) {
            if (this._paragraphs.contains(list)) continue;
            this._paragraphs.add(list);
        }
        for (List<HSLFTextParagraph> list : this._paragraphs) {
            for (HSLFTextParagraph hSLFTextParagraph : list) {
                hSLFTextParagraph.supplySheet(this);
            }
        }
    }

    public HSLFSlide(int n, int n2, int n3) {
        super(new ai2.org.apache.poi.hslf.record.Slide(), n);
        this._slideNo = n3;
        this.getSheetContainer().setSheetId(n2);
    }

    public HSLFNotes getNotes() {
        return this._notes;
    }

    @Override
    public void setNotes(Notes<HSLFShape, HSLFTextParagraph> notes) {
        if (notes != null && !(notes instanceof HSLFNotes)) {
            throw new IllegalArgumentException("notes needs to be of type HSLFNotes");
        }
        this._notes = (HSLFNotes)notes;
        SlideAtom slideAtom = this.getSlideRecord().getSlideAtom();
        if (this._notes == null) {
            slideAtom.setNotesID(0);
        } else {
            slideAtom.setNotesID(this._notes._getSheetNumber());
        }
    }

    public void setSlideNumber(int n) {
        this._slideNo = n;
    }

    @Override
    public void onCreate() {
        EscherDggRecord escherDggRecord = this.getSlideShow().getDocumentRecord().getPPDrawingGroup().getEscherDggRecord();
        EscherContainerRecord escherContainerRecord = (EscherContainerRecord)this.getSheetContainer().getPPDrawing().getEscherRecords()[0];
        EscherDgRecord escherDgRecord = (EscherDgRecord)HSLFShape.getEscherChild(escherContainerRecord, -4088);
        int n = escherDggRecord.getMaxDrawingGroupId() + 1;
        escherDgRecord.setOptions((short)(n << 4));
        escherDggRecord.setDrawingsSaved(escherDggRecord.getDrawingsSaved() + 1);
        escherDggRecord.setMaxDrawingGroupId(n);
        for (EscherContainerRecord escherContainerRecord2 : escherContainerRecord.getChildContainers()) {
            EscherSpRecord escherSpRecord = null;
            switch (escherContainerRecord2.getRecordId()) {
                case -4093: {
                    EscherContainerRecord escherContainerRecord3 = (EscherContainerRecord)escherContainerRecord2.getChild(0);
                    escherSpRecord = (EscherSpRecord)escherContainerRecord3.getChildById((short)-4086);
                    break;
                }
                case -4092: {
                    escherSpRecord = (EscherSpRecord)escherContainerRecord2.getChildById((short)-4086);
                }
            }
            if (escherSpRecord == null) continue;
            escherSpRecord.setShapeId(this.allocateShapeId());
        }
        escherDgRecord.setNumShapes(1);
    }

    public HSLFTextBox addTitle() {
        Placeholder placeholder = new Placeholder();
        placeholder.setShapeType(ShapeType.RECT);
        placeholder.setRunType(0);
        placeholder.setText("Click to edit title");
        placeholder.setAnchor(new Rectangle(54, 48, 612, 90));
        this.addShape(placeholder);
        return placeholder;
    }

    @Override
    public String getTitle() {
        for (List<HSLFTextParagraph> list : this.getTextParagraphs()) {
            if (list.isEmpty()) continue;
            int n = list.get(0).getRunType();
            switch (n) {
                case 0: 
                case 6: {
                    String string = HSLFTextParagraph.getRawText(list);
                    return HSLFTextParagraph.toExternalString(string, n);
                }
            }
        }
        return null;
    }

    @Override
    public List<List<HSLFTextParagraph>> getTextParagraphs() {
        return this._paragraphs;
    }

    @Override
    public int getSlideNumber() {
        return this._slideNo;
    }

    public ai2.org.apache.poi.hslf.record.Slide getSlideRecord() {
        return (ai2.org.apache.poi.hslf.record.Slide)this.getSheetContainer();
    }

    protected SlideListWithText.SlideAtomsSet getSlideAtomsSet() {
        return this._atomSet;
    }

    @Override
    public HSLFMasterSheet getMasterSheet() {
        int n = this.getSlideRecord().getSlideAtom().getMasterID();
        for (HSLFSlideMaster hSLFMasterSheet : this.getSlideShow().getSlideMasters()) {
            if (n != hSLFMasterSheet._getSheetNumber()) continue;
            return hSLFMasterSheet;
        }
        for (HSLFTitleMaster hSLFTitleMaster : this.getSlideShow().getTitleMasters()) {
            if (n != hSLFTitleMaster._getSheetNumber()) continue;
            return hSLFTitleMaster;
        }
        return null;
    }

    public void setMasterSheet(HSLFMasterSheet hSLFMasterSheet) {
        SlideAtom slideAtom = this.getSlideRecord().getSlideAtom();
        int n = hSLFMasterSheet._getSheetNumber();
        slideAtom.setMasterID(n);
    }

    @Override
    public void setFollowMasterBackground(boolean bl) {
        SlideAtom slideAtom = this.getSlideRecord().getSlideAtom();
        slideAtom.setFollowMasterBackground(bl);
    }

    @Override
    public boolean getFollowMasterBackground() {
        SlideAtom slideAtom = this.getSlideRecord().getSlideAtom();
        return slideAtom.getFollowMasterBackground();
    }

    @Override
    public void setFollowMasterObjects(boolean bl) {
        SlideAtom slideAtom = this.getSlideRecord().getSlideAtom();
        slideAtom.setFollowMasterObjects(bl);
    }

    public boolean getFollowMasterScheme() {
        SlideAtom slideAtom = this.getSlideRecord().getSlideAtom();
        return slideAtom.getFollowMasterScheme();
    }

    public void setFollowMasterScheme(boolean bl) {
        SlideAtom slideAtom = this.getSlideRecord().getSlideAtom();
        slideAtom.setFollowMasterScheme(bl);
    }

    @Override
    public boolean getFollowMasterObjects() {
        SlideAtom slideAtom = this.getSlideRecord().getSlideAtom();
        return slideAtom.getFollowMasterObjects();
    }

    @Override
    public HSLFBackground getBackground() {
        if (this.getFollowMasterBackground()) {
            return this.getMasterSheet().getBackground();
        }
        return super.getBackground();
    }

    @Override
    public ColorSchemeAtom getColorScheme() {
        if (this.getFollowMasterScheme()) {
            return this.getMasterSheet().getColorScheme();
        }
        return super.getColorScheme();
    }

    public Comment[] getComments() {
        RecordContainer recordContainer;
        RecordContainer recordContainer2;
        RecordContainer recordContainer3 = (RecordContainer)this.getSheetContainer().findFirstOfType(RecordTypes.ProgTags.typeID);
        if (recordContainer3 != null && (recordContainer2 = (RecordContainer)recordContainer3.findFirstOfType(RecordTypes.ProgBinaryTag.typeID)) != null && (recordContainer = (RecordContainer)recordContainer2.findFirstOfType(RecordTypes.BinaryTagData.typeID)) != null) {
            int n = 0;
            for (int i = 0; i < recordContainer.getChildRecords().length; ++i) {
                if (!(recordContainer.getChildRecords()[i] instanceof Comment2000)) continue;
                ++n;
            }
            Comment[] commentArray = new Comment[n];
            n = 0;
            for (int i = 0; i < recordContainer.getChildRecords().length; ++i) {
                if (!(recordContainer.getChildRecords()[i] instanceof Comment2000)) continue;
                commentArray[i] = new Comment((Comment2000)recordContainer.getChildRecords()[i]);
                ++n;
            }
            return commentArray;
        }
        return new Comment[0];
    }

    public HeadersFooters getHeadersFooters() {
        boolean bl;
        HeadersFootersContainer headersFootersContainer = null;
        Record[] recordArray = this.getSheetContainer().getChildRecords();
        boolean bl2 = false;
        for (bl = false; bl < recordArray.length; bl += 1) {
            if (recordArray[bl] instanceof HeadersFootersContainer) {
                headersFootersContainer = (HeadersFootersContainer)recordArray[bl];
                continue;
            }
            if (recordArray[bl].getRecordType() != (long)RecordTypes.RoundTripContentMasterId.typeID) continue;
            bl2 = true;
        }
        bl = false;
        if (headersFootersContainer == null && !bl2) {
            return this.getSlideShow().getSlideHeadersFooters();
        }
        if (headersFootersContainer == null) {
            headersFootersContainer = new HeadersFootersContainer(63);
            bl = true;
        }
        return new HeadersFooters(headersFootersContainer, this, bl, bl2);
    }

    @Override
    protected void onAddTextShape(HSLFTextShape hSLFTextShape) {
        List<HSLFTextParagraph> list = hSLFTextShape.getTextParagraphs();
        this._paragraphs.add(list);
    }

    public StyleTextProp9Atom[] getNumberedListInfo() {
        return this.getPPDrawing().getNumberedListInfo();
    }

    public EscherTextboxWrapper[] getTextboxWrappers() {
        return this.getPPDrawing().getTextboxWrappers();
    }

    public void setHidden(boolean bl) {
        ai2.org.apache.poi.hslf.record.Slide slide = this.getSlideRecord();
        SSSlideInfoAtom sSSlideInfoAtom = (SSSlideInfoAtom)slide.findFirstOfType(RecordTypes.SSSlideInfoAtom.typeID);
        if (sSSlideInfoAtom == null) {
            sSSlideInfoAtom = new SSSlideInfoAtom();
            slide.addChildAfter(sSSlideInfoAtom, slide.findFirstOfType(RecordTypes.SlideAtom.typeID));
        }
        sSSlideInfoAtom.setEffectTransitionFlagByBit(4, bl);
    }

    public boolean getHidden() {
        SSSlideInfoAtom sSSlideInfoAtom = (SSSlideInfoAtom)this.getSlideRecord().findFirstOfType(RecordTypes.SSSlideInfoAtom.typeID);
        return sSSlideInfoAtom == null ? false : sSSlideInfoAtom.getEffectTransitionFlagByBit(4);
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        DrawFactory drawFactory = DrawFactory.getInstance(graphics2D);
        DrawSlide drawSlide = drawFactory.getDrawable(this);
        drawSlide.draw(graphics2D);
    }

    @Override
    public boolean getFollowMasterColourScheme() {
        return false;
    }

    @Override
    public void setFollowMasterColourScheme(boolean bl) {
    }
}

