/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.usermodel;

import ai2.org.apache.poi.ddf.AbstractEscherOptRecord;
import ai2.org.apache.poi.ddf.EscherChildAnchorRecord;
import ai2.org.apache.poi.ddf.EscherClientAnchorRecord;
import ai2.org.apache.poi.ddf.EscherClientDataRecord;
import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherOptRecord;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.ddf.EscherSimpleProperty;
import ai2.org.apache.poi.ddf.EscherSpRecord;
import ai2.org.apache.poi.hslf.exceptions.HSLFException;
import ai2.org.apache.poi.hslf.record.HSLFEscherRecordFactory;
import ai2.org.apache.poi.hslf.record.InteractiveInfo;
import ai2.org.apache.poi.hslf.record.InteractiveInfoAtom;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.usermodel.HSLFHyperlink;
import ai2.org.apache.poi.hslf.usermodel.HSLFShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import ai2.org.apache.poi.sl.draw.DrawPaint;
import ai2.org.apache.poi.sl.draw.geom.CustomGeometry;
import ai2.org.apache.poi.sl.draw.geom.Guide;
import ai2.org.apache.poi.sl.draw.geom.PresetGeometries;
import ai2.org.apache.poi.sl.usermodel.LineDecoration;
import ai2.org.apache.poi.sl.usermodel.PaintStyle;
import ai2.org.apache.poi.sl.usermodel.Shadow;
import ai2.org.apache.poi.sl.usermodel.ShapeContainer;
import ai2.org.apache.poi.sl.usermodel.ShapeType;
import ai2.org.apache.poi.sl.usermodel.SimpleShape;
import ai2.org.apache.poi.sl.usermodel.StrokeStyle;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.Units;
import java.awt.Color;
import java.io.ByteArrayOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HSLFSimpleShape
extends HSLFShape
implements SimpleShape<HSLFShape, HSLFTextParagraph> {
    public static final double DEFAULT_LINE_WIDTH = 0.75;
    protected Record[] _clientRecords;
    protected EscherClientDataRecord _clientData;

    protected HSLFSimpleShape(EscherContainerRecord escherContainerRecord, ShapeContainer<HSLFShape, HSLFTextParagraph> shapeContainer) {
        super(escherContainerRecord, shapeContainer);
    }

    @Override
    protected EscherContainerRecord createSpContainer(boolean bl) {
        EscherRecord escherRecord;
        this._escherContainer = new EscherContainerRecord();
        this._escherContainer.setRecordId((short)-4092);
        this._escherContainer.setOptions((short)15);
        EscherSpRecord escherSpRecord = new EscherSpRecord();
        int n = 2560;
        if (bl) {
            n |= 2;
        }
        escherSpRecord.setFlags(n);
        this._escherContainer.addChildRecord(escherSpRecord);
        EscherOptRecord escherOptRecord = new EscherOptRecord();
        escherOptRecord.setRecordId((short)-4085);
        this._escherContainer.addChildRecord(escherOptRecord);
        if (bl) {
            escherRecord = new EscherChildAnchorRecord();
        } else {
            escherRecord = new EscherClientAnchorRecord();
            byte[] byArray = new byte[16];
            LittleEndian.putUShort(byArray, 0, 0);
            LittleEndian.putUShort(byArray, 2, 0);
            LittleEndian.putInt(byArray, 4, 8);
            escherRecord.fillFields(byArray, 0, null);
        }
        this._escherContainer.addChildRecord(escherRecord);
        return this._escherContainer;
    }

    public double getLineWidth() {
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(abstractEscherOptRecord, 459);
        double d = escherSimpleProperty == null ? 0.75 : Units.toPoints(escherSimpleProperty.getPropertyValue());
        return d;
    }

    public void setLineWidth(double d) {
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        HSLFSimpleShape.setEscherProperty(abstractEscherOptRecord, (short)459, Units.toEMU(d));
    }

    public void setLineColor(Color color) {
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        if (color == null) {
            HSLFSimpleShape.setEscherProperty(abstractEscherOptRecord, (short)511, 524288);
        } else {
            int n = new Color(color.getBlue(), color.getGreen(), color.getRed(), 0).getRGB();
            HSLFSimpleShape.setEscherProperty(abstractEscherOptRecord, (short)448, n);
            HSLFSimpleShape.setEscherProperty(abstractEscherOptRecord, (short)511, color == null ? 0x180010 : 0x180018);
        }
    }

    public Color getLineColor() {
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(abstractEscherOptRecord, 511);
        if (escherSimpleProperty != null && (escherSimpleProperty.getPropertyValue() & 8) == 0) {
            return null;
        }
        Color color = this.getColor((short)448, (short)449, -1);
        return color == null ? Color.black : color;
    }

    public StrokeStyle.LineDash getLineDashing() {
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(abstractEscherOptRecord, 462);
        return escherSimpleProperty == null ? StrokeStyle.LineDash.SOLID : StrokeStyle.LineDash.fromNativeId(escherSimpleProperty.getPropertyValue());
    }

    public void setLineDashing(StrokeStyle.LineDash lineDash) {
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        HSLFSimpleShape.setEscherProperty(abstractEscherOptRecord, (short)462, lineDash == StrokeStyle.LineDash.SOLID ? -1 : lineDash.nativeId);
    }

    public StrokeStyle.LineCompound getLineCompound() {
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(abstractEscherOptRecord, 461);
        return escherSimpleProperty == null ? StrokeStyle.LineCompound.SINGLE : StrokeStyle.LineCompound.fromNativeId(escherSimpleProperty.getPropertyValue());
    }

    public void setLineCompound(StrokeStyle.LineCompound lineCompound) {
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        HSLFSimpleShape.setEscherProperty(abstractEscherOptRecord, (short)461, lineCompound == StrokeStyle.LineCompound.SINGLE ? -1 : lineCompound.nativeId);
    }

    @Override
    public StrokeStyle getStrokeStyle() {
        return new StrokeStyle(){

            public PaintStyle getPaint() {
                return DrawPaint.createSolidPaint(HSLFSimpleShape.this.getLineColor());
            }

            public StrokeStyle.LineCap getLineCap() {
                return null;
            }

            public StrokeStyle.LineDash getLineDash() {
                return HSLFSimpleShape.this.getLineDashing();
            }

            public StrokeStyle.LineCompound getLineCompound() {
                return HSLFSimpleShape.this.getLineCompound();
            }

            public double getLineWidth() {
                return HSLFSimpleShape.this.getLineWidth();
            }
        };
    }

    public Color getFillColor() {
        return this.getFill().getForegroundColor();
    }

    public void setFillColor(Color color) {
        this.getFill().setForegroundColor(color);
    }

    protected <T extends Record> T getClientDataRecord(int n) {
        Record[] recordArray = this.getClientRecords();
        if (recordArray != null) {
            for (int i = 0; i < recordArray.length; ++i) {
                if (recordArray[i].getRecordType() != (long)n) continue;
                return (T)recordArray[i];
            }
        }
        return null;
    }

    protected Record[] getClientRecords() {
        Object object;
        if (this._clientData == null) {
            object = this.getEscherChild(-4079);
            if (object != null && !(object instanceof EscherClientDataRecord)) {
                byte[] byArray = ((EscherRecord)object).serialize();
                object = new EscherClientDataRecord();
                ((EscherRecord)object).fillFields(byArray, 0, new HSLFEscherRecordFactory());
            }
            this._clientData = (EscherClientDataRecord)object;
        }
        if (this._clientData != null && this._clientRecords == null) {
            object = this._clientData.getRemainingData();
            this._clientRecords = Record.findChildRecords(object, 0, ((T)object).length);
        }
        return this._clientRecords;
    }

    protected void updateClientData() {
        if (this._clientData != null && this._clientRecords != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                for (int i = 0; i < this._clientRecords.length; ++i) {
                    this._clientRecords[i].writeOut(byteArrayOutputStream);
                }
            }
            catch (Exception exception) {
                throw new HSLFException(exception);
            }
            this._clientData.setRemainingData(byteArrayOutputStream.toByteArray());
        }
    }

    public void setHyperlink(HSLFHyperlink hSLFHyperlink) {
        if (hSLFHyperlink.getId() == -1) {
            throw new HSLFException("You must call SlideShow.addHyperlink(Hyperlink link) first");
        }
        EscherClientDataRecord escherClientDataRecord = new EscherClientDataRecord();
        escherClientDataRecord.setOptions((short)15);
        this.getSpContainer().addChildRecord(escherClientDataRecord);
        InteractiveInfo interactiveInfo = new InteractiveInfo();
        InteractiveInfoAtom interactiveInfoAtom = interactiveInfo.getInteractiveInfoAtom();
        switch (hSLFHyperlink.getType()) {
            case 2: {
                interactiveInfoAtom.setAction((byte)3);
                interactiveInfoAtom.setJump((byte)3);
                interactiveInfoAtom.setHyperlinkType((byte)2);
                break;
            }
            case 3: {
                interactiveInfoAtom.setAction((byte)3);
                interactiveInfoAtom.setJump((byte)4);
                interactiveInfoAtom.setHyperlinkType((byte)3);
                break;
            }
            case 0: {
                interactiveInfoAtom.setAction((byte)3);
                interactiveInfoAtom.setJump((byte)1);
                interactiveInfoAtom.setHyperlinkType((byte)0);
                break;
            }
            case 1: {
                interactiveInfoAtom.setAction((byte)3);
                interactiveInfoAtom.setJump((byte)2);
                interactiveInfoAtom.setHyperlinkType((byte)1);
                break;
            }
            case 8: {
                interactiveInfoAtom.setAction((byte)4);
                interactiveInfoAtom.setJump((byte)0);
                interactiveInfoAtom.setHyperlinkType((byte)8);
                break;
            }
            case 7: {
                interactiveInfoAtom.setAction((byte)4);
                interactiveInfoAtom.setJump((byte)0);
                interactiveInfoAtom.setHyperlinkType((byte)7);
            }
        }
        interactiveInfoAtom.setHyperlinkID(hSLFHyperlink.getId());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            interactiveInfo.writeOut(byteArrayOutputStream);
        }
        catch (Exception exception) {
            throw new HSLFException(exception);
        }
        escherClientDataRecord.setRemainingData(byteArrayOutputStream.toByteArray());
    }

    @Override
    public Guide getAdjustValue(String string) {
        short s;
        if (string == null || !string.matches("adj([1-9]|10)?")) {
            throw new IllegalArgumentException("Adjust value '" + string + "' not supported.");
        }
        if ("".equals(string = string.replace("adj", ""))) {
            string = "1";
        }
        switch (Integer.parseInt(string)) {
            case 1: {
                s = 327;
                break;
            }
            case 2: {
                s = 328;
                break;
            }
            case 3: {
                s = 329;
                break;
            }
            case 4: {
                s = 330;
                break;
            }
            case 5: {
                s = 331;
                break;
            }
            case 6: {
                s = 332;
                break;
            }
            case 7: {
                s = 333;
                break;
            }
            case 8: {
                s = 334;
                break;
            }
            case 9: {
                s = 335;
                break;
            }
            case 10: {
                s = 336;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        int n = this.getEscherProperty(s, -1);
        return n == -1 ? null : new Guide(string, "val " + n);
    }

    @Override
    public CustomGeometry getGeometry() {
        ShapeType shapeType;
        String string;
        PresetGeometries presetGeometries = PresetGeometries.getInstance();
        CustomGeometry customGeometry = (CustomGeometry)presetGeometries.get(string = (shapeType = this.getShapeType()).getOoxmlName());
        if (customGeometry == null) {
            if (string == null && shapeType != null) {
                string = shapeType.toString();
            }
            this.logger.log(5, new Object[]{"No preset shape definition for shapeType: " + string});
            return null;
        }
        return customGeometry;
    }

    public double getShadowAngle() {
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(abstractEscherOptRecord, 517);
        int n = escherSimpleProperty == null ? 0 : escherSimpleProperty.getPropertyValue();
        escherSimpleProperty = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(abstractEscherOptRecord, 518);
        int n2 = escherSimpleProperty == null ? 0 : escherSimpleProperty.getPropertyValue();
        return Math.toDegrees(Math.atan2(n2, n));
    }

    public double getShadowDistance() {
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(abstractEscherOptRecord, 517);
        int n = escherSimpleProperty == null ? 0 : escherSimpleProperty.getPropertyValue();
        escherSimpleProperty = (EscherSimpleProperty)HSLFSimpleShape.getEscherProperty(abstractEscherOptRecord, 518);
        int n2 = escherSimpleProperty == null ? 0 : escherSimpleProperty.getPropertyValue();
        return Units.toPoints((long)Math.hypot(n, n2));
    }

    public Color getShadowColor() {
        Color color = this.getColor((short)513, (short)516, -1);
        return color == null ? Color.black : color;
    }

    @Override
    public Shadow<HSLFShape, HSLFTextParagraph> getShadow() {
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        Object t = abstractEscherOptRecord.lookup(512);
        if (t == null) {
            return null;
        }
        return new Shadow<HSLFShape, HSLFTextParagraph>(){

            @Override
            public SimpleShape<HSLFShape, HSLFTextParagraph> getShadowParent() {
                return HSLFSimpleShape.this;
            }

            @Override
            public double getDistance() {
                return HSLFSimpleShape.this.getShadowDistance();
            }

            @Override
            public double getAngle() {
                return HSLFSimpleShape.this.getShadowAngle();
            }

            @Override
            public double getBlur() {
                return 0.0;
            }

            @Override
            public PaintStyle.SolidPaint getFillStyle() {
                return DrawPaint.createSolidPaint(HSLFSimpleShape.this.getShadowColor());
            }
        };
    }

    @Override
    public LineDecoration getLineDecoration() {
        return new LineDecoration(){

            public LineDecoration.DecorationShape getHeadShape() {
                return LineDecoration.DecorationShape.NONE;
            }

            public LineDecoration.DecorationSize getHeadWidth() {
                return LineDecoration.DecorationSize.MEDIUM;
            }

            public LineDecoration.DecorationSize getHeadLength() {
                return LineDecoration.DecorationSize.MEDIUM;
            }

            public LineDecoration.DecorationShape getTailShape() {
                return LineDecoration.DecorationShape.NONE;
            }

            public LineDecoration.DecorationSize getTailWidth() {
                return LineDecoration.DecorationSize.MEDIUM;
            }

            public LineDecoration.DecorationSize getTailLength() {
                return LineDecoration.DecorationSize.MEDIUM;
            }
        };
    }
}

