/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.usermodel;

import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherDgRecord;
import ai2.org.apache.poi.ddf.EscherDggRecord;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.hslf.record.CString;
import ai2.org.apache.poi.hslf.record.ColorSchemeAtom;
import ai2.org.apache.poi.hslf.record.OEPlaceholderAtom;
import ai2.org.apache.poi.hslf.record.PPDrawing;
import ai2.org.apache.poi.hslf.record.RecordContainer;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.hslf.record.RoundTripHFPlaceholder12;
import ai2.org.apache.poi.hslf.record.SheetContainer;
import ai2.org.apache.poi.hslf.usermodel.HSLFAutoShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFBackground;
import ai2.org.apache.poi.hslf.usermodel.HSLFConnectorShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFFreeformShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFGroupShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFMasterSheet;
import ai2.org.apache.poi.hslf.usermodel.HSLFPictureData;
import ai2.org.apache.poi.hslf.usermodel.HSLFPictureShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFShapeContainer;
import ai2.org.apache.poi.hslf.usermodel.HSLFShapeFactory;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlideShow;
import ai2.org.apache.poi.hslf.usermodel.HSLFTable;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextBox;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextShape;
import ai2.org.apache.poi.sl.draw.DrawFactory;
import ai2.org.apache.poi.sl.draw.DrawSheet;
import ai2.org.apache.poi.sl.usermodel.PictureData;
import ai2.org.apache.poi.sl.usermodel.ShapeType;
import ai2.org.apache.poi.sl.usermodel.Sheet;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HSLFSheet
implements HSLFShapeContainer,
Sheet<HSLFShape, HSLFTextParagraph> {
    private HSLFSlideShow _slideShow;
    private HSLFBackground _background;
    private SheetContainer _container;
    private int _sheetNo;

    public HSLFSheet(SheetContainer sheetContainer, int n) {
        this._container = sheetContainer;
        this._sheetNo = n;
    }

    public abstract List<List<HSLFTextParagraph>> getTextParagraphs();

    public int _getSheetRefId() {
        return this._container.getSheetId();
    }

    public int _getSheetNumber() {
        return this._sheetNo;
    }

    public PPDrawing getPPDrawing() {
        return this._container.getPPDrawing();
    }

    public HSLFSlideShow getSlideShow() {
        return this._slideShow;
    }

    public SheetContainer getSheetContainer() {
        return this._container;
    }

    public void setSlideShow(HSLFSlideShow hSLFSlideShow) {
        this._slideShow = hSLFSlideShow;
        List<List<HSLFTextParagraph>> list = this.getTextParagraphs();
        if (list == null) {
            return;
        }
        for (List<HSLFTextParagraph> list2 : list) {
            for (HSLFTextParagraph hSLFTextParagraph : list2) {
                hSLFTextParagraph.supplySheet(this);
            }
        }
    }

    @Override
    public List<HSLFShape> getShapes() {
        Iterator<EscherRecord> iterator;
        PPDrawing pPDrawing = this.getPPDrawing();
        EscherContainerRecord escherContainerRecord = (EscherContainerRecord)pPDrawing.getEscherRecords()[0];
        EscherContainerRecord escherContainerRecord2 = null;
        Object object = escherContainerRecord.getChildIterator();
        while (object.hasNext()) {
            iterator = object.next();
            if (((EscherRecord)((Object)iterator)).getRecordId() != -4093) continue;
            escherContainerRecord2 = (EscherContainerRecord)((Object)iterator);
            break;
        }
        if (escherContainerRecord2 == null) {
            throw new IllegalStateException("spgr not found");
        }
        object = new ArrayList();
        iterator = escherContainerRecord2.getChildIterator();
        if (iterator.hasNext()) {
            iterator.next();
        }
        while (iterator.hasNext()) {
            EscherContainerRecord escherContainerRecord3 = (EscherContainerRecord)iterator.next();
            HSLFShape hSLFShape = HSLFShapeFactory.createShape(escherContainerRecord3, null);
            hSLFShape.setSheet(this);
            object.add(hSLFShape);
        }
        return object;
    }

    @Override
    public void addShape(HSLFShape hSLFShape) {
        PPDrawing pPDrawing = this.getPPDrawing();
        EscherContainerRecord escherContainerRecord = (EscherContainerRecord)pPDrawing.getEscherRecords()[0];
        EscherContainerRecord escherContainerRecord2 = (EscherContainerRecord)HSLFShape.getEscherChild(escherContainerRecord, -4093);
        escherContainerRecord2.addChildRecord(hSLFShape.getSpContainer());
        hSLFShape.setSheet(this);
        hSLFShape.setShapeId(this.allocateShapeId());
        hSLFShape.afterInsert(this);
    }

    public int allocateShapeId() {
        int n;
        EscherDggRecord escherDggRecord = this._slideShow.getDocumentRecord().getPPDrawingGroup().getEscherDggRecord();
        EscherDgRecord escherDgRecord = this._container.getPPDrawing().getEscherDgRecord();
        escherDggRecord.setNumShapesSaved(escherDggRecord.getNumShapesSaved() + 1);
        for (n = 0; n < escherDggRecord.getFileIdClusters().length; ++n) {
            EscherDggRecord.FileIdCluster fileIdCluster = escherDggRecord.getFileIdClusters()[n];
            if (fileIdCluster.getDrawingGroupId() != escherDgRecord.getDrawingGroupId() || fileIdCluster.getNumShapeIdsUsed() == 1024) continue;
            int n2 = fileIdCluster.getNumShapeIdsUsed() + 1024 * (n + 1);
            fileIdCluster.incrementShapeId();
            escherDgRecord.setNumShapes(escherDgRecord.getNumShapes() + 1);
            escherDgRecord.setLastMSOSPID(n2);
            if (n2 >= escherDggRecord.getShapeIdMax()) {
                escherDggRecord.setShapeIdMax(n2 + 1);
            }
            return n2;
        }
        escherDggRecord.addCluster(escherDgRecord.getDrawingGroupId(), 0, false);
        escherDggRecord.getFileIdClusters()[escherDggRecord.getFileIdClusters().length - 1].incrementShapeId();
        escherDgRecord.setNumShapes(escherDgRecord.getNumShapes() + 1);
        n = 1024 * escherDggRecord.getFileIdClusters().length;
        escherDgRecord.setLastMSOSPID(n);
        if (n >= escherDggRecord.getShapeIdMax()) {
            escherDggRecord.setShapeIdMax(n + 1);
        }
        return n;
    }

    @Override
    public boolean removeShape(HSLFShape hSLFShape) {
        PPDrawing pPDrawing = this.getPPDrawing();
        EscherContainerRecord escherContainerRecord = (EscherContainerRecord)pPDrawing.getEscherRecords()[0];
        EscherContainerRecord escherContainerRecord2 = null;
        Object object = escherContainerRecord.getChildIterator();
        while (object.hasNext()) {
            EscherRecord escherRecord = object.next();
            if (escherRecord.getRecordId() != -4093) continue;
            escherContainerRecord2 = (EscherContainerRecord)escherRecord;
            break;
        }
        if (escherContainerRecord2 == null) {
            return false;
        }
        object = escherContainerRecord2.getChildRecords();
        boolean bl = object.remove(hSLFShape.getSpContainer());
        escherContainerRecord2.setChildRecords((List<EscherRecord>)object);
        return bl;
    }

    public void onCreate() {
    }

    public abstract HSLFMasterSheet getMasterSheet();

    public ColorSchemeAtom getColorScheme() {
        return this._container.getColorScheme();
    }

    public HSLFBackground getBackground() {
        if (this._background == null) {
            PPDrawing pPDrawing = this.getPPDrawing();
            EscherContainerRecord escherContainerRecord = (EscherContainerRecord)pPDrawing.getEscherRecords()[0];
            EscherContainerRecord escherContainerRecord2 = (EscherContainerRecord)escherContainerRecord.getChildById((short)-4092);
            this._background = new HSLFBackground(escherContainerRecord2, null);
            this._background.setSheet(this);
        }
        return this._background;
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        DrawFactory drawFactory = DrawFactory.getInstance(graphics2D);
        DrawSheet drawSheet = drawFactory.getDrawable(this);
        drawSheet.draw(graphics2D);
    }

    protected void onAddTextShape(HSLFTextShape hSLFTextShape) {
    }

    public HSLFTextShape getPlaceholderByTextType(int n) {
        for (HSLFShape hSLFShape : this.getShapes()) {
            HSLFTextShape hSLFTextShape;
            if (!(hSLFShape instanceof HSLFTextShape) || (hSLFTextShape = (HSLFTextShape)hSLFShape) == null || hSLFTextShape.getRunType() != n) continue;
            return hSLFTextShape;
        }
        return null;
    }

    public HSLFTextShape getPlaceholder(int n) {
        for (HSLFShape hSLFShape : this.getShapes()) {
            if (!(hSLFShape instanceof HSLFTextShape)) continue;
            HSLFTextShape hSLFTextShape = (HSLFTextShape)hSLFShape;
            int n2 = 0;
            OEPlaceholderAtom oEPlaceholderAtom = hSLFTextShape.getPlaceholderAtom();
            if (oEPlaceholderAtom != null) {
                n2 = oEPlaceholderAtom.getPlaceholderId();
            } else {
                RoundTripHFPlaceholder12 roundTripHFPlaceholder12 = (RoundTripHFPlaceholder12)hSLFTextShape.getClientDataRecord(RecordTypes.RoundTripHFPlaceholder12.typeID);
                if (roundTripHFPlaceholder12 != null) {
                    n2 = roundTripHFPlaceholder12.getPlaceholderId();
                }
            }
            if (n2 != n) continue;
            return hSLFTextShape;
        }
        return null;
    }

    public String getProgrammableTag() {
        CString cString;
        RecordContainer recordContainer;
        String string = null;
        RecordContainer recordContainer2 = (RecordContainer)this.getSheetContainer().findFirstOfType(RecordTypes.ProgTags.typeID);
        if (recordContainer2 != null && (recordContainer = (RecordContainer)recordContainer2.findFirstOfType(RecordTypes.ProgBinaryTag.typeID)) != null && (cString = (CString)recordContainer.findFirstOfType(RecordTypes.CString.typeID)) != null) {
            string = cString.getText();
        }
        return string;
    }

    @Override
    public Iterator<HSLFShape> iterator() {
        return this.getShapes().iterator();
    }

    @Override
    public boolean getFollowMasterGraphics() {
        return false;
    }

    @Override
    public HSLFTextBox createTextBox() {
        HSLFTextBox hSLFTextBox = new HSLFTextBox();
        hSLFTextBox.setHorizontalCentered(true);
        hSLFTextBox.setAnchor(new Rectangle(0, 0, 100, 100));
        this.addShape(hSLFTextBox);
        return hSLFTextBox;
    }

    @Override
    public HSLFAutoShape createAutoShape() {
        HSLFAutoShape hSLFAutoShape = new HSLFAutoShape(ShapeType.RECT);
        hSLFAutoShape.setHorizontalCentered(true);
        hSLFAutoShape.setAnchor(new Rectangle(0, 0, 100, 100));
        this.addShape(hSLFAutoShape);
        return hSLFAutoShape;
    }

    @Override
    public HSLFFreeformShape createFreeform() {
        HSLFFreeformShape hSLFFreeformShape = new HSLFFreeformShape();
        hSLFFreeformShape.setHorizontalCentered(true);
        hSLFFreeformShape.setAnchor(new Rectangle(0, 0, 100, 100));
        this.addShape(hSLFFreeformShape);
        return hSLFFreeformShape;
    }

    @Override
    public HSLFConnectorShape createConnector() {
        HSLFConnectorShape hSLFConnectorShape = new HSLFConnectorShape();
        hSLFConnectorShape.setAnchor(new Rectangle(0, 0, 100, 100));
        this.addShape(hSLFConnectorShape);
        return hSLFConnectorShape;
    }

    @Override
    public HSLFGroupShape createGroup() {
        HSLFGroupShape hSLFGroupShape = new HSLFGroupShape();
        hSLFGroupShape.setAnchor(new Rectangle(0, 0, 100, 100));
        this.addShape(hSLFGroupShape);
        return hSLFGroupShape;
    }

    @Override
    public HSLFPictureShape createPicture(PictureData pictureData) {
        if (!(pictureData instanceof HSLFPictureData)) {
            throw new IllegalArgumentException("pictureData needs to be of type HSLFPictureData");
        }
        HSLFPictureShape hSLFPictureShape = new HSLFPictureShape((HSLFPictureData)pictureData);
        hSLFPictureShape.setAnchor(new Rectangle(0, 0, 100, 100));
        this.addShape(hSLFPictureShape);
        return hSLFPictureShape;
    }

    public HSLFTable createTable(int n, int n2) {
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException("numRows and numCols must be greater than 0");
        }
        HSLFTable hSLFTable = new HSLFTable(n, n2);
        hSLFTable.setAnchor(new Rectangle(0, 0, 100, 100));
        this.addShape(hSLFTable);
        return hSLFTable;
    }
}

