/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.usermodel;

import ai2.org.apache.poi.ddf.AbstractEscherOptRecord;
import ai2.org.apache.poi.ddf.EscherChildAnchorRecord;
import ai2.org.apache.poi.ddf.EscherClientAnchorRecord;
import ai2.org.apache.poi.ddf.EscherColorRef;
import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherProperty;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.ddf.EscherSimpleProperty;
import ai2.org.apache.poi.ddf.EscherSpRecord;
import ai2.org.apache.poi.hslf.record.ColorSchemeAtom;
import ai2.org.apache.poi.hslf.usermodel.HSLFFill;
import ai2.org.apache.poi.hslf.usermodel.HSLFHyperlink;
import ai2.org.apache.poi.hslf.usermodel.HSLFSheet;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import ai2.org.apache.poi.sl.usermodel.FillStyle;
import ai2.org.apache.poi.sl.usermodel.Shape;
import ai2.org.apache.poi.sl.usermodel.ShapeContainer;
import ai2.org.apache.poi.sl.usermodel.ShapeType;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.util.Units;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HSLFShape
implements Shape<HSLFShape, HSLFTextParagraph> {
    protected POILogger logger = POILogFactory.getLogger(this.getClass());
    protected EscherContainerRecord _escherContainer;
    protected ShapeContainer<HSLFShape, HSLFTextParagraph> _parent;
    protected HSLFSheet _sheet;
    protected HSLFFill _fill;

    protected HSLFShape(EscherContainerRecord escherContainerRecord, ShapeContainer<HSLFShape, HSLFTextParagraph> shapeContainer) {
        this._escherContainer = escherContainerRecord;
        this._parent = shapeContainer;
    }

    protected abstract EscherContainerRecord createSpContainer(boolean var1);

    @Override
    public ShapeContainer<HSLFShape, HSLFTextParagraph> getParent() {
        return this._parent;
    }

    public String getShapeName() {
        return this.getShapeType().nativeName;
    }

    public ShapeType getShapeType() {
        EscherSpRecord escherSpRecord = (EscherSpRecord)this.getEscherChild(-4086);
        return ShapeType.forId(escherSpRecord.getShapeType(), false);
    }

    public void setShapeType(ShapeType shapeType) {
        EscherSpRecord escherSpRecord = (EscherSpRecord)this.getEscherChild(-4086);
        escherSpRecord.setShapeType((short)shapeType.nativeId);
        escherSpRecord.setVersion((short)2);
    }

    @Override
    public Rectangle getAnchor() {
        Object object;
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl;
        EscherSpRecord escherSpRecord = (EscherSpRecord)this.getEscherChild(-4086);
        int n5 = escherSpRecord.getFlags();
        EscherChildAnchorRecord escherChildAnchorRecord = (EscherChildAnchorRecord)this.getEscherChild(-4081);
        boolean bl2 = bl = (n5 & 2) != 0;
        if (bl && escherChildAnchorRecord != null) {
            n4 = escherChildAnchorRecord.getDx1();
            n3 = escherChildAnchorRecord.getDy1();
            n2 = escherChildAnchorRecord.getDx2();
            n = escherChildAnchorRecord.getDy2();
        } else {
            if (bl) {
                this.logger.log(5, new Object[]{"EscherSpRecord.FLAG_CHILD is set but EscherChildAnchorRecord was not found"});
            }
            object = (EscherClientAnchorRecord)this.getEscherChild(-4080);
            n4 = ((EscherClientAnchorRecord)object).getCol1();
            n3 = ((EscherClientAnchorRecord)object).getFlag();
            n2 = ((EscherClientAnchorRecord)object).getDx1();
            n = ((EscherClientAnchorRecord)object).getRow1();
        }
        object = new Rectangle((int)(n4 == -1 ? -1.0 : Units.masterToPoints(n4)), (int)(n3 == -1 ? -1.0 : Units.masterToPoints(n3)), (int)(n2 == -1 ? -1.0 : Units.masterToPoints(n2 - n4)), (int)(n == -1 ? -1.0 : Units.masterToPoints(n - n3)));
        return object;
    }

    public void setAnchor(Rectangle rectangle) {
        int n = Units.pointsToMaster(rectangle.getX());
        int n2 = Units.pointsToMaster(rectangle.getY());
        int n3 = Units.pointsToMaster(rectangle.getWidth() + rectangle.getX());
        int n4 = Units.pointsToMaster(rectangle.getHeight() + rectangle.getY());
        EscherSpRecord escherSpRecord = (EscherSpRecord)this.getEscherChild(-4086);
        int n5 = escherSpRecord.getFlags();
        if ((n5 & 2) != 0) {
            EscherChildAnchorRecord escherChildAnchorRecord = (EscherChildAnchorRecord)this.getEscherChild(-4081);
            escherChildAnchorRecord.setDx1(n);
            escherChildAnchorRecord.setDy1(n2);
            escherChildAnchorRecord.setDx2(n3);
            escherChildAnchorRecord.setDy2(n4);
        } else {
            EscherClientAnchorRecord escherClientAnchorRecord = (EscherClientAnchorRecord)this.getEscherChild(-4080);
            escherClientAnchorRecord.setCol1((short)n);
            escherClientAnchorRecord.setFlag((short)n2);
            escherClientAnchorRecord.setDx1((short)n3);
            escherClientAnchorRecord.setRow1((short)n4);
        }
    }

    public void moveTo(float f, float f2) {
        Rectangle rectangle = this.getAnchor();
        rectangle.setRect(f, f2, rectangle.getWidth(), rectangle.getHeight());
        this.setAnchor(rectangle);
    }

    public static <T extends EscherRecord> T getEscherChild(EscherContainerRecord escherContainerRecord, int n) {
        return escherContainerRecord.getChildById((short)n);
    }

    public <T extends EscherRecord> T getEscherChild(int n) {
        return this._escherContainer.getChildById((short)n);
    }

    public static <T extends EscherProperty> T getEscherProperty(AbstractEscherOptRecord abstractEscherOptRecord, int n) {
        if (abstractEscherOptRecord == null) {
            return null;
        }
        return abstractEscherOptRecord.lookup(n);
    }

    public static void setEscherProperty(AbstractEscherOptRecord abstractEscherOptRecord, short s, int n) {
        List<EscherProperty> list = abstractEscherOptRecord.getEscherProperties();
        Iterator<EscherProperty> iterator = list.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getPropertyNumber() != s) continue;
            iterator.remove();
            break;
        }
        if (n != -1) {
            abstractEscherOptRecord.addEscherProperty(new EscherSimpleProperty(s, n));
            abstractEscherOptRecord.sortProperties();
        }
    }

    public void setEscherProperty(short s, int n) {
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        HSLFShape.setEscherProperty(abstractEscherOptRecord, s, n);
    }

    public int getEscherProperty(short s) {
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)HSLFShape.getEscherProperty(abstractEscherOptRecord, s);
        return escherSimpleProperty == null ? 0 : escherSimpleProperty.getPropertyValue();
    }

    public int getEscherProperty(short s, int n) {
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)HSLFShape.getEscherProperty(abstractEscherOptRecord, s);
        return escherSimpleProperty == null ? n : escherSimpleProperty.getPropertyValue();
    }

    public EscherContainerRecord getSpContainer() {
        return this._escherContainer;
    }

    protected void afterInsert(HSLFSheet hSLFSheet) {
        if (this._fill != null) {
            this._fill.afterInsert(hSLFSheet);
        }
    }

    public HSLFSheet getSheet() {
        return this._sheet;
    }

    public void setSheet(HSLFSheet hSLFSheet) {
        this._sheet = hSLFSheet;
    }

    Color getColor(short s, short s2, int n) {
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)HSLFShape.getEscherProperty(abstractEscherOptRecord, s);
        if (escherSimpleProperty == null && n == -1) {
            return null;
        }
        int n2 = escherSimpleProperty == null ? n : escherSimpleProperty.getPropertyValue();
        EscherColorRef escherColorRef = new EscherColorRef(n2);
        boolean bl = escherColorRef.hasPaletteIndexFlag();
        boolean bl2 = escherColorRef.hasPaletteRGBFlag();
        boolean bl3 = escherColorRef.hasSystemRGBFlag();
        boolean bl4 = escherColorRef.hasSchemeIndexFlag();
        boolean bl5 = escherColorRef.hasSysIndexFlag();
        int[] nArray = escherColorRef.getRGB();
        HSLFSheet hSLFSheet = this.getSheet();
        if (bl4 && hSLFSheet != null) {
            ColorSchemeAtom colorSchemeAtom = hSLFSheet.getColorScheme();
            int n3 = colorSchemeAtom.getColor(escherColorRef.getSchemeIndex());
            nArray[0] = n3 >> 0 & 0xFF;
            nArray[1] = n3 >> 8 & 0xFF;
            nArray[2] = n3 >> 16 & 0xFF;
        } else if (bl || bl2 || bl3 || bl5) {
            // empty if block
        }
        double d = this.getAlpha(s2);
        return new Color(nArray[0], nArray[1], nArray[2], (int)(d * 255.0));
    }

    double getAlpha(short s) {
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)HSLFShape.getEscherProperty(abstractEscherOptRecord, s);
        int n = 65536;
        int n2 = escherSimpleProperty == null ? n : escherSimpleProperty.getPropertyValue();
        return Units.fixedPointToDouble(n2);
    }

    Color toRGB(int n) {
        int n2 = n >> 24 & 0xFF;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n >> 0 & 0xFF;
        if (n2 != 254 && n2 != 255) {
            ColorSchemeAtom colorSchemeAtom = this.getSheet().getColorScheme();
            int n6 = colorSchemeAtom.getColor(n2);
            n5 = n6 >> 0 & 0xFF;
            n4 = n6 >> 8 & 0xFF;
            n3 = n6 >> 16 & 0xFF;
        }
        return new Color(n5, n4, n3);
    }

    public int getShapeId() {
        EscherSpRecord escherSpRecord = (EscherSpRecord)this.getEscherChild(-4086);
        return escherSpRecord == null ? 0 : escherSpRecord.getShapeId();
    }

    public void setShapeId(int n) {
        EscherSpRecord escherSpRecord = (EscherSpRecord)this.getEscherChild(-4086);
        if (escherSpRecord != null) {
            escherSpRecord.setShapeId(n);
        }
    }

    public HSLFFill getFill() {
        if (this._fill == null) {
            this._fill = new HSLFFill(this);
        }
        return this._fill;
    }

    public FillStyle getFillStyle() {
        return this.getFill().getFillStyle();
    }

    public HSLFHyperlink getHyperlink() {
        return HSLFHyperlink.find(this);
    }

    public void draw(Graphics2D graphics2D) {
        this.logger.log(3, new Object[]{"Rendering " + this.getShapeName()});
    }

    public AbstractEscherOptRecord getEscherOptRecord() {
        AbstractEscherOptRecord abstractEscherOptRecord = (AbstractEscherOptRecord)this.getEscherChild(-4085);
        if (abstractEscherOptRecord == null) {
            abstractEscherOptRecord = (AbstractEscherOptRecord)this.getEscherChild(61730);
        }
        return abstractEscherOptRecord;
    }

    public boolean getFlipHorizontal() {
        EscherSpRecord escherSpRecord = (EscherSpRecord)this.getEscherChild(-4086);
        return (escherSpRecord.getFlags() & 0x40) != 0;
    }

    public void setFlipHorizontal(boolean bl) {
        EscherSpRecord escherSpRecord = (EscherSpRecord)this.getEscherChild(-4086);
        int n = escherSpRecord.getFlags() | 0x40;
        escherSpRecord.setFlags(n);
    }

    public boolean getFlipVertical() {
        EscherSpRecord escherSpRecord = (EscherSpRecord)this.getEscherChild(-4086);
        return (escherSpRecord.getFlags() & 0x80) != 0;
    }

    public void setFlipVertical(boolean bl) {
        EscherSpRecord escherSpRecord = (EscherSpRecord)this.getEscherChild(-4086);
        int n = escherSpRecord.getFlags() | 0x80;
        escherSpRecord.setFlags(n);
    }

    public double getRotation() {
        int n = this.getEscherProperty((short)4);
        return Units.fixedPointToDouble(n);
    }

    public void setRotation(double d) {
        int n = Units.doubleToFixedPoint(d % 360.0);
        this.setEscherProperty((short)4, n);
    }

    public boolean isPlaceholder() {
        return false;
    }
}

