/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.usermodel;

import ai2.org.apache.poi.hslf.blip.DIB;
import ai2.org.apache.poi.hslf.blip.EMF;
import ai2.org.apache.poi.hslf.blip.JPEG;
import ai2.org.apache.poi.hslf.blip.PICT;
import ai2.org.apache.poi.hslf.blip.PNG;
import ai2.org.apache.poi.hslf.blip.WMF;
import ai2.org.apache.poi.poifs.crypt.CryptoFunctions;
import ai2.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai2.org.apache.poi.sl.usermodel.PictureData;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.Units;
import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import java.security.MessageDigest;

public abstract class HSLFPictureData
implements PictureData {
    protected static final int CHECKSUM_SIZE = 16;
    private byte[] rawdata;
    protected int offset;
    protected int uidInstanceCount = 1;
    protected int index = -1;

    protected abstract int getSignature();

    public abstract void setSignature(int var1);

    protected int getUIDInstanceCount() {
        return this.uidInstanceCount;
    }

    public byte[] getRawData() {
        return this.rawdata;
    }

    public void setRawData(byte[] byArray) {
        this.rawdata = byArray;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int n) {
        this.offset = n;
    }

    public byte[] getUID() {
        byte[] byArray = new byte[16];
        System.arraycopy(this.rawdata, 0, byArray, 0, byArray.length);
        return byArray;
    }

    public byte[] getChecksum() {
        return HSLFPictureData.getChecksum(this.getData());
    }

    public static byte[] getChecksum(byte[] byArray) {
        MessageDigest messageDigest = CryptoFunctions.getMessageDigest(HashAlgorithm.md5);
        messageDigest.update(byArray);
        return messageDigest.digest();
    }

    public void write(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[2];
        LittleEndian.putUShort(byArray, 0, this.getSignature());
        outputStream.write(byArray);
        byArray = new byte[2];
        PictureData.PictureType pictureType = this.getType();
        LittleEndian.putUShort(byArray, 0, pictureType.nativeId + 61464);
        outputStream.write(byArray);
        byte[] byArray2 = this.getRawData();
        byArray = new byte[4];
        LittleEndian.putInt(byArray, 0, byArray2.length);
        outputStream.write(byArray);
        outputStream.write(byArray2);
    }

    public static HSLFPictureData create(PictureData.PictureType pictureType) {
        HSLFPictureData hSLFPictureData;
        switch (pictureType) {
            case EMF: {
                hSLFPictureData = new EMF();
                break;
            }
            case WMF: {
                hSLFPictureData = new WMF();
                break;
            }
            case PICT: {
                hSLFPictureData = new PICT();
                break;
            }
            case JPEG: {
                hSLFPictureData = new JPEG();
                break;
            }
            case PNG: {
                hSLFPictureData = new PNG();
                break;
            }
            case DIB: {
                hSLFPictureData = new DIB();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported picture type: " + (Object)((Object)pictureType));
            }
        }
        return hSLFPictureData;
    }

    public byte[] getHeader() {
        byte[] byArray = new byte[24];
        LittleEndian.putInt(byArray, 0, this.getSignature());
        LittleEndian.putInt(byArray, 4, this.getRawData().length);
        System.arraycopy(this.rawdata, 0, byArray, 8, 16);
        return byArray;
    }

    public int getSize() {
        return this.getData().length;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public final String getContentType() {
        return this.getType().contentType;
    }

    public Dimension getImageDimensionInPixels() {
        Dimension dimension = this.getImageDimension();
        return new Dimension(Units.pointsToPixel(dimension.getWidth()), Units.pointsToPixel(dimension.getHeight()));
    }
}

