/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.usermodel;

import ai2.org.apache.poi.hslf.record.Notes;
import ai2.org.apache.poi.hslf.usermodel.HSLFMasterSheet;
import ai2.org.apache.poi.hslf.usermodel.HSLFShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFSheet;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HSLFNotes
extends HSLFSheet
implements ai2.org.apache.poi.sl.usermodel.Notes<HSLFShape, HSLFTextParagraph> {
    protected static final POILogger logger = POILogFactory.getLogger(HSLFNotes.class);
    private List<List<HSLFTextParagraph>> _paragraphs = new ArrayList<List<HSLFTextParagraph>>();

    public HSLFNotes(Notes notes) {
        super(notes, notes.getNotesAtom().getSlideID());
        for (List<HSLFTextParagraph> list : HSLFTextParagraph.findTextParagraphs(this.getPPDrawing(), (HSLFSheet)this)) {
            if (this._paragraphs.contains(list)) continue;
            this._paragraphs.add(list);
        }
        if (this._paragraphs.isEmpty()) {
            logger.log(5, new Object[]{"No text records found for notes sheet"});
        }
        for (List<HSLFTextParagraph> list : this._paragraphs) {
            for (HSLFTextParagraph hSLFTextParagraph : list) {
                hSLFTextParagraph.supplySheet(this);
            }
        }
    }

    @Override
    public List<List<HSLFTextParagraph>> getTextParagraphs() {
        return this._paragraphs;
    }

    @Override
    public HSLFMasterSheet getMasterSheet() {
        return null;
    }
}

