/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.usermodel;

import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.hslf.record.ExHyperlink;
import ai2.org.apache.poi.hslf.record.ExObjList;
import ai2.org.apache.poi.hslf.record.InteractiveInfo;
import ai2.org.apache.poi.hslf.record.InteractiveInfoAtom;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.TxInteractiveInfoAtom;
import ai2.org.apache.poi.hslf.usermodel.HSLFShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlide;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlideShow;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextShape;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HSLFHyperlink {
    public static final byte LINK_NEXTSLIDE = 0;
    public static final byte LINK_PREVIOUSSLIDE = 1;
    public static final byte LINK_FIRSTSLIDE = 2;
    public static final byte LINK_LASTSLIDE = 3;
    public static final byte LINK_SLIDENUMBER = 7;
    public static final byte LINK_URL = 8;
    public static final byte LINK_NULL = -1;
    private int id = -1;
    private int type;
    private String address;
    private String title;
    private int startIndex;
    private int endIndex;

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
        switch (this.type) {
            case 0: {
                this.title = "NEXT";
                this.address = "1,-1,NEXT";
                break;
            }
            case 1: {
                this.title = "PREV";
                this.address = "1,-1,PREV";
                break;
            }
            case 2: {
                this.title = "FIRST";
                this.address = "1,-1,FIRST";
                break;
            }
            case 3: {
                this.title = "LAST";
                this.address = "1,-1,LAST";
                break;
            }
            case 7: {
                break;
            }
            default: {
                this.title = "";
                this.address = "";
            }
        }
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(HSLFSlide hSLFSlide) {
        String string = hSLFSlide._getSheetNumber() + "," + hSLFSlide.getSlideNumber() + ",Slide " + hSLFSlide.getSlideNumber();
        this.setAddress(string);
        this.setTitle("Slide " + hSLFSlide.getSlideNumber());
        this.setType(7);
    }

    public void setAddress(String string) {
        this.address = string;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public static List<HSLFHyperlink> find(HSLFTextShape hSLFTextShape) {
        return HSLFHyperlink.find(hSLFTextShape.getTextParagraphs());
    }

    public static List<HSLFHyperlink> find(List<HSLFTextParagraph> list) {
        ArrayList<HSLFHyperlink> arrayList = new ArrayList<HSLFHyperlink>();
        if (list == null || list.isEmpty()) {
            return arrayList;
        }
        HSLFTextParagraph hSLFTextParagraph = list.get(0);
        HSLFSlideShow hSLFSlideShow = hSLFTextParagraph.getSheet().getSlideShow();
        ExObjList exObjList = hSLFSlideShow.getDocumentRecord().getExObjList();
        if (exObjList == null) {
            return arrayList;
        }
        Record[] recordArray = hSLFTextParagraph.getRecords();
        HSLFHyperlink.find(recordArray, exObjList, arrayList);
        return arrayList;
    }

    public static HSLFHyperlink find(HSLFShape hSLFShape) {
        ArrayList<HSLFHyperlink> arrayList = new ArrayList<HSLFHyperlink>();
        HSLFSlideShow hSLFSlideShow = hSLFShape.getSheet().getSlideShow();
        ExObjList exObjList = hSLFSlideShow.getDocumentRecord().getExObjList();
        if (exObjList == null) {
            return null;
        }
        EscherContainerRecord escherContainerRecord = hSLFShape.getSpContainer();
        Iterator<EscherRecord> iterator = escherContainerRecord.getChildIterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = iterator.next();
            if (escherRecord.getRecordId() != -4079) continue;
            byte[] byArray = escherRecord.serialize();
            Record[] recordArray = Record.findChildRecords(byArray, 8, byArray.length - 8);
            HSLFHyperlink.find(recordArray, exObjList, arrayList);
        }
        return arrayList.size() == 1 ? (HSLFHyperlink)arrayList.get(0) : null;
    }

    private static void find(Record[] recordArray, ExObjList exObjList, List<HSLFHyperlink> list) {
        if (recordArray == null) {
            return;
        }
        for (int i = 0; i < recordArray.length; ++i) {
            InteractiveInfo interactiveInfo;
            InteractiveInfoAtom interactiveInfoAtom;
            int n;
            ExHyperlink exHyperlink;
            if (!(recordArray[i] instanceof InteractiveInfo) || (exHyperlink = exObjList.get(n = (interactiveInfoAtom = (interactiveInfo = (InteractiveInfo)recordArray[i]).getInteractiveInfoAtom()).getHyperlinkID())) == null) continue;
            HSLFHyperlink hSLFHyperlink = new HSLFHyperlink();
            hSLFHyperlink.title = exHyperlink.getLinkTitle();
            hSLFHyperlink.address = exHyperlink.getLinkURL();
            hSLFHyperlink.type = interactiveInfoAtom.getAction();
            list.add(hSLFHyperlink);
            if (i + 1 >= recordArray.length || !(recordArray[i + 1] instanceof TxInteractiveInfoAtom)) continue;
            TxInteractiveInfoAtom txInteractiveInfoAtom = (TxInteractiveInfoAtom)recordArray[++i];
            hSLFHyperlink.startIndex = txInteractiveInfoAtom.getStartIndex();
            hSLFHyperlink.endIndex = txInteractiveInfoAtom.getEndIndex();
        }
    }
}

