/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.usermodel;

import ai2.org.apache.poi.ddf.AbstractEscherOptRecord;
import ai2.org.apache.poi.ddf.EscherArrayProperty;
import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherSimpleProperty;
import ai2.org.apache.poi.hslf.usermodel.HSLFAutoShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFGroupShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import ai2.org.apache.poi.sl.usermodel.FreeformShape;
import ai2.org.apache.poi.sl.usermodel.ShapeContainer;
import ai2.org.apache.poi.sl.usermodel.ShapeType;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.Units;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HSLFFreeformShape
extends HSLFAutoShape
implements FreeformShape<HSLFShape, HSLFTextParagraph> {
    public static final byte[] SEGMENTINFO_MOVETO = new byte[]{0, 64};
    public static final byte[] SEGMENTINFO_LINETO = new byte[]{0, -84};
    public static final byte[] SEGMENTINFO_ESCAPE = new byte[]{1, 0};
    public static final byte[] SEGMENTINFO_ESCAPE2 = new byte[]{1, 32};
    public static final byte[] SEGMENTINFO_CUBICTO = new byte[]{0, -83};
    public static final byte[] SEGMENTINFO_CUBICTO2 = new byte[]{0, -77};
    public static final byte[] SEGMENTINFO_CLOSE = new byte[]{1, 96};
    public static final byte[] SEGMENTINFO_END = new byte[]{0, -128};

    protected HSLFFreeformShape(EscherContainerRecord escherContainerRecord, ShapeContainer<HSLFShape, HSLFTextParagraph> shapeContainer) {
        super(escherContainerRecord, shapeContainer);
    }

    public HSLFFreeformShape(ShapeContainer<HSLFShape, HSLFTextParagraph> shapeContainer) {
        super((EscherContainerRecord)null, shapeContainer);
        this._escherContainer = this.createSpContainer(ShapeType.NOT_PRIMITIVE, shapeContainer instanceof HSLFGroupShape);
    }

    public HSLFFreeformShape() {
        this((ShapeContainer<HSLFShape, HSLFTextParagraph>)null);
    }

    @Override
    public int setPath(GeneralPath generalPath) {
        byte[] byArray;
        Object object;
        Rectangle rectangle = generalPath.getBounds();
        PathIterator pathIterator = generalPath.getPathIterator(new AffineTransform());
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        ArrayList<Point2D.Double> arrayList2 = new ArrayList<Point2D.Double>();
        boolean bl = false;
        int n = 0;
        while (!pathIterator.isDone()) {
            object = new double[6];
            int n2 = pathIterator.currentSegment((double[])object);
            switch (n2) {
                case 0: {
                    arrayList2.add(new Point2D.Double(object[0], object[1]));
                    arrayList.add(SEGMENTINFO_MOVETO);
                    ++n;
                    break;
                }
                case 1: {
                    arrayList2.add(new Point2D.Double(object[0], object[1]));
                    arrayList.add(SEGMENTINFO_LINETO);
                    arrayList.add(SEGMENTINFO_ESCAPE);
                    ++n;
                    break;
                }
                case 3: {
                    arrayList2.add(new Point2D.Double(object[0], object[1]));
                    arrayList2.add(new Point2D.Double((double)object[2], (double)object[3]));
                    arrayList2.add(new Point2D.Double((double)object[4], (double)object[5]));
                    arrayList.add(SEGMENTINFO_CUBICTO);
                    arrayList.add(SEGMENTINFO_ESCAPE2);
                    ++n;
                    break;
                }
                case 2: {
                    this.logger.log(5, new Object[]{"SEG_QUADTO is not supported"});
                    break;
                }
                case 4: {
                    arrayList2.add((Point2D.Double)arrayList2.get(0));
                    arrayList.add(SEGMENTINFO_LINETO);
                    arrayList.add(SEGMENTINFO_ESCAPE);
                    arrayList.add(SEGMENTINFO_LINETO);
                    arrayList.add(SEGMENTINFO_CLOSE);
                    bl = true;
                    ++n;
                }
            }
            pathIterator.next();
        }
        if (!bl) {
            arrayList.add(SEGMENTINFO_LINETO);
        }
        arrayList.add(new byte[]{0, -128});
        object = this.getEscherOptRecord();
        ((AbstractEscherOptRecord)object).addEscherProperty(new EscherSimpleProperty(324, 4));
        EscherArrayProperty escherArrayProperty = new EscherArrayProperty(16709, false, null);
        escherArrayProperty.setNumberOfElementsInArray(arrayList2.size());
        escherArrayProperty.setNumberOfElementsInMemory(arrayList2.size());
        escherArrayProperty.setSizeOfElements(65520);
        for (int i = 0; i < arrayList2.size(); ++i) {
            Point2D.Double double_ = (Point2D.Double)arrayList2.get(i);
            byArray = new byte[4];
            LittleEndian.putShort(byArray, 0, (short)Units.pointsToMaster(double_.getX() - rectangle.getX()));
            LittleEndian.putShort(byArray, 2, (short)Units.pointsToMaster(double_.getY() - rectangle.getY()));
            escherArrayProperty.setElement(i, byArray);
        }
        ((AbstractEscherOptRecord)object).addEscherProperty(escherArrayProperty);
        EscherArrayProperty escherArrayProperty2 = new EscherArrayProperty(16710, false, null);
        escherArrayProperty2.setNumberOfElementsInArray(arrayList.size());
        escherArrayProperty2.setNumberOfElementsInMemory(arrayList.size());
        escherArrayProperty2.setSizeOfElements(2);
        for (int i = 0; i < arrayList.size(); ++i) {
            byArray = (byte[])arrayList.get(i);
            escherArrayProperty2.setElement(i, byArray);
        }
        ((AbstractEscherOptRecord)object).addEscherProperty(escherArrayProperty2);
        ((AbstractEscherOptRecord)object).addEscherProperty(new EscherSimpleProperty(322, Units.pointsToMaster(rectangle.getWidth())));
        ((AbstractEscherOptRecord)object).addEscherProperty(new EscherSimpleProperty(323, Units.pointsToMaster(rectangle.getHeight())));
        ((AbstractEscherOptRecord)object).sortProperties();
        this.setAnchor(rectangle);
        return n;
    }

    @Override
    public GeneralPath getPath() {
        Object object;
        EscherArrayProperty escherArrayProperty;
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        abstractEscherOptRecord.addEscherProperty(new EscherSimpleProperty(324, 4));
        EscherArrayProperty escherArrayProperty2 = (EscherArrayProperty)HSLFFreeformShape.getEscherProperty(abstractEscherOptRecord, 16709);
        if (escherArrayProperty2 == null) {
            escherArrayProperty2 = (EscherArrayProperty)HSLFFreeformShape.getEscherProperty(abstractEscherOptRecord, 325);
        }
        if ((escherArrayProperty = (EscherArrayProperty)HSLFFreeformShape.getEscherProperty(abstractEscherOptRecord, 16710)) == null) {
            escherArrayProperty = (EscherArrayProperty)HSLFFreeformShape.getEscherProperty(abstractEscherOptRecord, 326);
        }
        GeneralPath generalPath = new GeneralPath();
        if (escherArrayProperty2 == null) {
            this.logger.log(5, new Object[]{"Freeform is missing GEOMETRY__VERTICES "});
            return generalPath;
        }
        if (escherArrayProperty == null) {
            this.logger.log(5, new Object[]{"Freeform is missing GEOMETRY__SEGMENTINFO "});
            return generalPath;
        }
        int n = escherArrayProperty2.getNumberOfElementsInArray();
        int n2 = escherArrayProperty.getNumberOfElementsInArray();
        int n3 = 0;
        for (int i = 0; i < n2 && n3 < n; ++i) {
            short s;
            byte[] byArray;
            object = escherArrayProperty.getElement(i);
            if (Arrays.equals(object, SEGMENTINFO_MOVETO)) {
                byArray = escherArrayProperty2.getElement(n3++);
                short s2 = LittleEndian.getShort(byArray, 0);
                s = LittleEndian.getShort(byArray, 2);
                generalPath.moveTo(Units.masterToPoints(s2), Units.masterToPoints(s));
                continue;
            }
            if (Arrays.equals(object, SEGMENTINFO_CUBICTO) || Arrays.equals(object, SEGMENTINFO_CUBICTO2)) {
                ++i;
                byArray = escherArrayProperty2.getElement(n3++);
                short s3 = LittleEndian.getShort(byArray, 0);
                s = LittleEndian.getShort(byArray, 2);
                byte[] byArray2 = escherArrayProperty2.getElement(n3++);
                short s4 = LittleEndian.getShort(byArray2, 0);
                short s5 = LittleEndian.getShort(byArray2, 2);
                byte[] byArray3 = escherArrayProperty2.getElement(n3++);
                short s6 = LittleEndian.getShort(byArray3, 0);
                short s7 = LittleEndian.getShort(byArray3, 2);
                generalPath.curveTo(Units.masterToPoints(s3), Units.masterToPoints(s), Units.masterToPoints(s4), Units.masterToPoints(s5), Units.masterToPoints(s6), Units.masterToPoints(s7));
                continue;
            }
            if (!Arrays.equals(object, SEGMENTINFO_LINETO)) continue;
            if (Arrays.equals(byArray = escherArrayProperty.getElement(++i), SEGMENTINFO_ESCAPE)) {
                if (n3 + 1 >= n) continue;
                byte[] byArray4 = escherArrayProperty2.getElement(n3++);
                s = LittleEndian.getShort(byArray4, 0);
                short s8 = LittleEndian.getShort(byArray4, 2);
                generalPath.lineTo(Units.masterToPoints(s), Units.masterToPoints(s8));
                continue;
            }
            if (!Arrays.equals(byArray, SEGMENTINFO_CLOSE)) continue;
            generalPath.closePath();
        }
        Rectangle rectangle = this.getAnchor();
        Rectangle2D rectangle2D = generalPath.getBounds2D();
        object = new AffineTransform();
        object.translate(((RectangularShape)rectangle).getX(), ((RectangularShape)rectangle).getY());
        object.scale(((RectangularShape)rectangle).getWidth() / rectangle2D.getWidth(), ((RectangularShape)rectangle).getHeight() / rectangle2D.getHeight());
        return new GeneralPath(object.createTransformedShape(generalPath));
    }
}

