/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.usermodel;

import ai2.org.apache.poi.ddf.AbstractEscherOptRecord;
import ai2.org.apache.poi.ddf.EscherBSERecord;
import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.ddf.EscherSimpleProperty;
import ai2.org.apache.poi.hslf.record.Document;
import ai2.org.apache.poi.hslf.usermodel.HSLFPictureData;
import ai2.org.apache.poi.hslf.usermodel.HSLFShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFSheet;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlideShow;
import ai2.org.apache.poi.sl.draw.DrawPaint;
import ai2.org.apache.poi.sl.usermodel.FillStyle;
import ai2.org.apache.poi.sl.usermodel.PaintStyle;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public final class HSLFFill {
    protected POILogger logger = POILogFactory.getLogger(this.getClass());
    public static final int FILL_SOLID = 0;
    public static final int FILL_PATTERN = 1;
    public static final int FILL_TEXTURE = 2;
    public static final int FILL_PICTURE = 3;
    public static final int FILL_SHADE = 4;
    public static final int FILL_SHADE_CENTER = 5;
    public static final int FILL_SHADE_SHAPE = 6;
    public static final int FILL_SHADE_SCALE = 7;
    public static final int FILL_SHADE_TITLE = 8;
    public static final int FILL_BACKGROUND = 9;
    protected HSLFShape shape;

    public HSLFFill(HSLFShape hSLFShape) {
        this.shape = hSLFShape;
    }

    public FillStyle getFillStyle() {
        return new FillStyle(){

            public PaintStyle getPaint() {
                switch (HSLFFill.this.getFillType()) {
                    case 0: {
                        return DrawPaint.createSolidPaint(HSLFFill.this.getForegroundColor());
                    }
                    case 3: {
                        final HSLFPictureData hSLFPictureData = HSLFFill.this.getPictureData();
                        if (hSLFPictureData == null) break;
                        return new PaintStyle.TexturePaint(){

                            public InputStream getImageData() {
                                return new ByteArrayInputStream(hSLFPictureData.getData());
                            }

                            public String getContentType() {
                                return hSLFPictureData.getContentType();
                            }

                            public int getAlpha() {
                                return (int)(HSLFFill.this.shape.getAlpha((short)386) * 100000.0);
                            }
                        };
                    }
                    default: {
                        HSLFFill.this.logger.log(5, new Object[]{"unsuported fill type: " + HSLFFill.this.getFillType()});
                    }
                }
                return null;
            }
        };
    }

    public int getFillType() {
        AbstractEscherOptRecord abstractEscherOptRecord = this.shape.getEscherOptRecord();
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)HSLFShape.getEscherProperty(abstractEscherOptRecord, 384);
        return escherSimpleProperty == null ? 0 : escherSimpleProperty.getPropertyValue();
    }

    protected void afterInsert(HSLFSheet hSLFSheet) {
        AbstractEscherOptRecord abstractEscherOptRecord = this.shape.getEscherOptRecord();
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)HSLFShape.getEscherProperty(abstractEscherOptRecord, 390);
        if (escherSimpleProperty != null) {
            int n = escherSimpleProperty.getPropertyValue();
            EscherBSERecord escherBSERecord = this.getEscherBSERecord(n);
            escherBSERecord.setRef(escherBSERecord.getRef() + 1);
        }
    }

    protected EscherBSERecord getEscherBSERecord(int n) {
        HSLFSheet hSLFSheet = this.shape.getSheet();
        if (hSLFSheet == null) {
            this.logger.log(1, new Object[]{"Fill has not yet been assigned to a sheet"});
            return null;
        }
        HSLFSlideShow hSLFSlideShow = hSLFSheet.getSlideShow();
        Document document = hSLFSlideShow.getDocumentRecord();
        EscherContainerRecord escherContainerRecord = document.getPPDrawingGroup().getDggContainer();
        EscherContainerRecord escherContainerRecord2 = (EscherContainerRecord)HSLFShape.getEscherChild(escherContainerRecord, -4095);
        if (escherContainerRecord2 == null) {
            this.logger.log(1, new Object[]{"EscherContainerRecord.BSTORE_CONTAINER was not found "});
            return null;
        }
        List<EscherRecord> list = escherContainerRecord2.getChildRecords();
        return (EscherBSERecord)list.get(n - 1);
    }

    public void setFillType(int n) {
        AbstractEscherOptRecord abstractEscherOptRecord = this.shape.getEscherOptRecord();
        HSLFShape.setEscherProperty(abstractEscherOptRecord, (short)384, n);
    }

    public Color getForegroundColor() {
        AbstractEscherOptRecord abstractEscherOptRecord = this.shape.getEscherOptRecord();
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)HSLFShape.getEscherProperty(abstractEscherOptRecord, 447);
        if (escherSimpleProperty != null && (escherSimpleProperty.getPropertyValue() & 0x10) == 0) {
            return null;
        }
        return this.shape.getColor((short)385, (short)386, -1);
    }

    public void setForegroundColor(Color color) {
        AbstractEscherOptRecord abstractEscherOptRecord = this.shape.getEscherOptRecord();
        if (color == null) {
            HSLFShape.setEscherProperty(abstractEscherOptRecord, (short)447, 0x150000);
        } else {
            int n = new Color(color.getBlue(), color.getGreen(), color.getRed(), 0).getRGB();
            HSLFShape.setEscherProperty(abstractEscherOptRecord, (short)385, n);
            HSLFShape.setEscherProperty(abstractEscherOptRecord, (short)447, 0x150011);
        }
    }

    public Color getBackgroundColor() {
        AbstractEscherOptRecord abstractEscherOptRecord = this.shape.getEscherOptRecord();
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)HSLFShape.getEscherProperty(abstractEscherOptRecord, 447);
        if (escherSimpleProperty != null && (escherSimpleProperty.getPropertyValue() & 0x10) == 0) {
            return null;
        }
        return this.shape.getColor((short)387, (short)386, -1);
    }

    public void setBackgroundColor(Color color) {
        AbstractEscherOptRecord abstractEscherOptRecord = this.shape.getEscherOptRecord();
        if (color == null) {
            HSLFShape.setEscherProperty(abstractEscherOptRecord, (short)387, -1);
        } else {
            int n = new Color(color.getBlue(), color.getGreen(), color.getRed(), 0).getRGB();
            HSLFShape.setEscherProperty(abstractEscherOptRecord, (short)387, n);
        }
    }

    public HSLFPictureData getPictureData() {
        AbstractEscherOptRecord abstractEscherOptRecord = this.shape.getEscherOptRecord();
        EscherSimpleProperty escherSimpleProperty = (EscherSimpleProperty)HSLFShape.getEscherProperty(abstractEscherOptRecord, 390);
        if (escherSimpleProperty == null) {
            return null;
        }
        HSLFSlideShow hSLFSlideShow = this.shape.getSheet().getSlideShow();
        List<HSLFPictureData> list = hSLFSlideShow.getPictureData();
        Document document = hSLFSlideShow.getDocumentRecord();
        EscherContainerRecord escherContainerRecord = document.getPPDrawingGroup().getDggContainer();
        EscherContainerRecord escherContainerRecord2 = (EscherContainerRecord)HSLFShape.getEscherChild(escherContainerRecord, -4095);
        List<EscherRecord> list2 = escherContainerRecord2.getChildRecords();
        int n = escherSimpleProperty.getPropertyValue();
        if (n == 0) {
            this.logger.log(5, new Object[]{"no reference to picture data found "});
        } else {
            EscherBSERecord escherBSERecord = (EscherBSERecord)list2.get(n - 1);
            for (HSLFPictureData hSLFPictureData : list) {
                if (hSLFPictureData.getOffset() != escherBSERecord.getOffset()) continue;
                return hSLFPictureData;
            }
        }
        return null;
    }

    public void setPictureData(HSLFPictureData hSLFPictureData) {
        AbstractEscherOptRecord abstractEscherOptRecord = this.shape.getEscherOptRecord();
        HSLFShape.setEscherProperty(abstractEscherOptRecord, (short)16774, hSLFPictureData == null ? 0 : hSLFPictureData.getIndex());
        if (hSLFPictureData != null && this.shape.getSheet() != null) {
            EscherBSERecord escherBSERecord = this.getEscherBSERecord(hSLFPictureData.getIndex());
            escherBSERecord.setRef(escherBSERecord.getRef() + 1);
        }
    }
}

