/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.model.textproperties.TextPropCollection;
import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TxMasterStyleAtom
extends RecordAtom {
    public static final int MAX_INDENT = 5;
    private byte[] _header = new byte[8];
    private static long _type = 4003L;
    private byte[] _data;
    private List<TextPropCollection> paragraphStyles;
    private List<TextPropCollection> charStyles;

    protected TxMasterStyleAtom(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._data = new byte[n2 - 8];
        System.arraycopy(byArray, n + 8, this._data, 0, this._data.length);
        try {
            this.init();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public long getRecordType() {
        return _type;
    }

    @Override
    public void writeOut(OutputStream outputStream) throws IOException {
        outputStream.write(this._header);
        outputStream.write(this._data);
    }

    public List<TextPropCollection> getCharacterStyles() {
        return this.charStyles;
    }

    public List<TextPropCollection> getParagraphStyles() {
        return this.paragraphStyles;
    }

    public int getTextType() {
        return LittleEndian.getShort(this._header, 0) >> 4;
    }

    protected void init() {
        int n = this.getTextType();
        int n2 = 0;
        short s = LittleEndian.getShort(this._data, 0);
        n2 += 2;
        this.paragraphStyles = new ArrayList<TextPropCollection>(s);
        this.charStyles = new ArrayList<TextPropCollection>(s);
        for (short s2 = 0; s2 < s; s2 = (short)(s2 + 1)) {
            TextPropCollection textPropCollection = new TextPropCollection(0, TextPropCollection.TextPropType.paragraph);
            if (n >= 5) {
                short s3 = LittleEndian.getShort(this._data, n2);
                textPropCollection.setIndentLevel(s3);
                n2 += 2;
            } else {
                textPropCollection.setIndentLevel((short)-1);
            }
            int n3 = LittleEndian.getInt(this._data, n2);
            n2 += 4;
            n2 += textPropCollection.buildTextPropList(n3, this._data, n2);
            this.paragraphStyles.add(textPropCollection);
            n3 = LittleEndian.getInt(this._data, n2);
            n2 += 4;
            TextPropCollection textPropCollection2 = new TextPropCollection(0, TextPropCollection.TextPropType.character);
            n2 += textPropCollection2.buildTextPropList(n3, this._data, n2);
            this.charStyles.add(textPropCollection2);
        }
    }
}

