/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public final class TxInteractiveInfoAtom
extends RecordAtom {
    private byte[] _header = new byte[8];
    private byte[] _data;

    public TxInteractiveInfoAtom() {
        this._data = new byte[8];
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        LittleEndian.putInt(this._header, 4, this._data.length);
    }

    protected TxInteractiveInfoAtom(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._data = new byte[n2 - 8];
        System.arraycopy(byArray, n + 8, this._data, 0, n2 - 8);
    }

    public int getStartIndex() {
        return LittleEndian.getInt(this._data, 0);
    }

    public void setStartIndex(int n) {
        LittleEndian.putInt(this._data, 0, n);
    }

    public int getEndIndex() {
        return LittleEndian.getInt(this._data, 4);
    }

    public void setEndIndex(int n) {
        LittleEndian.putInt(this._data, 4, n);
    }

    public long getRecordType() {
        return RecordTypes.TxInteractiveInfoAtom.typeID;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        outputStream.write(this._header);
        outputStream.write(this._data);
    }
}

