/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.util.BitField;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.LittleEndianByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TextSpecInfoRun {
    private static final BitField spellFld = new BitField(1);
    private static final BitField langFld = new BitField(2);
    private static final BitField altLangFld = new BitField(4);
    private static final BitField pp10extFld = new BitField(32);
    private static final BitField bidiFld = new BitField(64);
    private static final BitField smartTagFld = new BitField(512);
    private static final BitField pp10runidFld = new BitField(15);
    private static final BitField grammarErrorFld = new BitField(Integer.MIN_VALUE);
    protected int length;
    protected int mask;
    protected short spellInfo = (short)-1;
    protected short langId = (short)-1;
    protected short altLangId = (short)-1;
    protected short bidi = (short)-1;
    protected int pp10extMask = -1;
    protected byte[] smartTagsBytes = null;

    public TextSpecInfoRun(int n) {
        this.setLength(n);
        this.setLangId((short)0);
    }

    public TextSpecInfoRun(LittleEndianByteArrayInputStream littleEndianByteArrayInputStream) {
        this.length = littleEndianByteArrayInputStream.readInt();
        this.mask = littleEndianByteArrayInputStream.readInt();
        if (spellFld.isSet(this.mask)) {
            this.spellInfo = littleEndianByteArrayInputStream.readShort();
        }
        if (langFld.isSet(this.mask)) {
            this.langId = littleEndianByteArrayInputStream.readShort();
        }
        if (altLangFld.isSet(this.mask)) {
            this.altLangId = littleEndianByteArrayInputStream.readShort();
        }
        if (bidiFld.isSet(this.mask)) {
            this.bidi = littleEndianByteArrayInputStream.readShort();
        }
        if (pp10extFld.isSet(this.mask)) {
            this.pp10extMask = littleEndianByteArrayInputStream.readInt();
        }
        if (smartTagFld.isSet(this.mask)) {
            int n = littleEndianByteArrayInputStream.readInt();
            this.smartTagsBytes = new byte[4 + n * 4];
            LittleEndian.putInt(this.smartTagsBytes, 0, n);
            littleEndianByteArrayInputStream.readFully(this.smartTagsBytes, 4, n * 4);
        }
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[4];
        LittleEndian.putInt(byArray, 0, this.length);
        outputStream.write(byArray);
        LittleEndian.putInt(byArray, 0, this.mask);
        outputStream.write(byArray);
        Object[] objectArray = new Object[]{spellFld, this.spellInfo, "spell info", langFld, this.langId, "lang id", altLangFld, this.altLangId, "alt lang id", bidiFld, this.bidi, "bidi", pp10extFld, this.pp10extMask, "pp10 extension field", smartTagFld, this.smartTagsBytes, "smart tags"};
        for (int i = 0; i < objectArray.length; i += 3) {
            boolean bl;
            BitField bitField = (BitField)objectArray[i + 0];
            Object object = objectArray[i + 1];
            if (!bitField.isSet(this.mask)) continue;
            if (object instanceof byte[]) {
                byte[] byArray2 = (byte[])object;
                bl = byArray2.length > 0;
                outputStream.write(byArray2);
            } else if (object instanceof Integer) {
                int n = (Integer)object;
                bl = n != -1;
                LittleEndian.putInt(byArray, 0, n);
                outputStream.write(byArray);
            } else if (object instanceof Short) {
                short s = (Short)object;
                bl = s != -1;
                LittleEndian.putShort(byArray, 0, s);
                outputStream.write(byArray, 0, 2);
            } else {
                bl = false;
            }
            if (bl) continue;
            throw new IOException(objectArray[i + 2] + " is activated, but its value is invalid");
        }
    }

    public SpellInfoEnum getSpellInfo() {
        if (this.spellInfo == -1) {
            return null;
        }
        for (SpellInfoEnum spellInfoEnum : new SpellInfoEnum[]{SpellInfoEnum.clean, SpellInfoEnum.error, SpellInfoEnum.grammar}) {
            if (!spellInfoEnum.bitField.isSet(this.spellInfo)) continue;
            return spellInfoEnum;
        }
        return SpellInfoEnum.correct;
    }

    public void setSpellInfo(SpellInfoEnum spellInfoEnum) {
        this.spellInfo = (short)(spellInfoEnum == null ? -1 : (short)spellInfoEnum.bitField.set(0));
        this.mask = spellFld.setBoolean(this.mask, spellInfoEnum != null);
    }

    public short getLangId() {
        return this.langId;
    }

    public void setLangId(short s) {
        this.langId = s;
        this.mask = langFld.setBoolean(this.mask, s != -1);
    }

    public short getAltLangId() {
        return this.altLangId;
    }

    public void setAltLangId(short s) {
        this.altLangId = s;
        this.mask = altLangFld.setBoolean(this.mask, s != -1);
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public Boolean getBidi() {
        return this.bidi == -1 ? null : Boolean.valueOf(this.bidi != 0);
    }

    public void setBidi(Boolean bl) {
        this.bidi = (short)(bl == null ? -1 : (short)(bl != false ? 1 : 0));
        this.mask = bidiFld.setBoolean(this.mask, bl != null);
    }

    public byte[] getSmartTagsBytes() {
        return this.smartTagsBytes;
    }

    public void setSmartTagsBytes(byte[] byArray) {
        this.smartTagsBytes = byArray;
        this.mask = smartTagFld.setBoolean(this.mask, byArray != null);
    }

    public int getPP10RunId() {
        return this.pp10extMask == -1 || !pp10extFld.isSet(this.mask) ? -1 : pp10runidFld.getValue(this.pp10extMask);
    }

    public void setPP10RunId(int n) {
        this.pp10extMask = n == -1 ? (this.getGrammarError() == null ? -1 : pp10runidFld.clear(this.pp10extMask)) : pp10runidFld.setValue(this.pp10extMask, n);
        this.mask = pp10extFld.setBoolean(this.mask, this.pp10extMask != -1);
    }

    public Boolean getGrammarError() {
        return this.pp10extMask == -1 || !pp10extFld.isSet(this.mask) ? null : Boolean.valueOf(grammarErrorFld.isSet(this.pp10extMask));
    }

    public void getGrammarError(Boolean bl) {
        this.pp10extMask = bl == null ? (this.getPP10RunId() == -1 ? -1 : grammarErrorFld.clear(this.pp10extMask)) : grammarErrorFld.set(this.pp10extMask);
        this.mask = pp10extFld.setBoolean(this.mask, this.pp10extMask != -1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SpellInfoEnum {
        error(new BitField(1)),
        clean(new BitField(2)),
        grammar(new BitField(4)),
        correct(new BitField(0));

        final BitField bitField;

        private SpellInfoEnum(BitField bitField) {
            this.bitField = bitField;
        }
    }
}

