/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public final class SlidePersistAtom
extends RecordAtom {
    private byte[] _header;
    private static long _type = 1011L;
    private int refID;
    private boolean hasShapesOtherThanPlaceholders;
    private int numPlaceholderTexts;
    private int slideIdentifier;
    private byte[] reservedFields;

    public int getRefID() {
        return this.refID;
    }

    public int getSlideIdentifier() {
        return this.slideIdentifier;
    }

    public int getNumPlaceholderTexts() {
        return this.numPlaceholderTexts;
    }

    public boolean getHasShapesOtherThanPlaceholders() {
        return this.hasShapesOtherThanPlaceholders;
    }

    public void setRefID(int n) {
        this.refID = n;
    }

    public void setSlideIdentifier(int n) {
        this.slideIdentifier = n;
    }

    protected SlidePersistAtom(byte[] byArray, int n, int n2) {
        if (n2 < 8) {
            n2 = 8;
        }
        this._header = new byte[8];
        System.arraycopy(byArray, n, this._header, 0, 8);
        this.refID = LittleEndian.getInt(byArray, n + 8);
        int n3 = LittleEndian.getInt(byArray, n + 12);
        this.hasShapesOtherThanPlaceholders = n3 == 4;
        this.numPlaceholderTexts = LittleEndian.getInt(byArray, n + 16);
        this.slideIdentifier = LittleEndian.getInt(byArray, n + 20);
        this.reservedFields = new byte[n2 - 24];
        System.arraycopy(byArray, n + 24, this.reservedFields, 0, this.reservedFields.length);
    }

    public SlidePersistAtom() {
        this._header = new byte[8];
        LittleEndian.putUShort(this._header, 0, 0);
        LittleEndian.putUShort(this._header, 2, (int)_type);
        LittleEndian.putInt(this._header, 4, 20);
        this.hasShapesOtherThanPlaceholders = true;
        this.reservedFields = new byte[4];
    }

    public long getRecordType() {
        return _type;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        outputStream.write(this._header);
        int n = 0;
        if (this.hasShapesOtherThanPlaceholders) {
            n = 4;
        }
        SlidePersistAtom.writeLittleEndian(this.refID, outputStream);
        SlidePersistAtom.writeLittleEndian(n, outputStream);
        SlidePersistAtom.writeLittleEndian(this.numPlaceholderTexts, outputStream);
        SlidePersistAtom.writeLittleEndian(this.slideIdentifier, outputStream);
        outputStream.write(this.reservedFields);
    }
}

