/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordContainer;
import ai2.org.apache.poi.hslf.record.SlidePersistAtom;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public final class SlideListWithText
extends RecordContainer {
    public static final int SLIDES = 0;
    public static final int MASTER = 1;
    public static final int NOTES = 2;
    private byte[] _header = new byte[8];
    private static long _type = 4080L;
    private SlideAtomsSet[] slideAtomsSets;

    protected SlideListWithText(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._children = Record.findChildRecords(byArray, n + 8, n2 - 8);
        ArrayList<SlideAtomsSet> arrayList = new ArrayList<SlideAtomsSet>();
        for (int i = 0; i < this._children.length; ++i) {
            int n3;
            if (!(this._children[i] instanceof SlidePersistAtom)) continue;
            for (n3 = i + 1; n3 < this._children.length && !(this._children[n3] instanceof SlidePersistAtom); ++n3) {
            }
            int n4 = n3 - i - 1;
            Record[] recordArray = new Record[n4];
            System.arraycopy(this._children, i + 1, recordArray, 0, n4);
            SlideAtomsSet slideAtomsSet = new SlideAtomsSet((SlidePersistAtom)this._children[i], recordArray);
            arrayList.add(slideAtomsSet);
            i += n4;
        }
        this.slideAtomsSets = arrayList.toArray(new SlideAtomsSet[arrayList.size()]);
    }

    public SlideListWithText() {
        LittleEndian.putUShort(this._header, 0, 15);
        LittleEndian.putUShort(this._header, 2, (int)_type);
        LittleEndian.putInt(this._header, 4, 0);
        this._children = new Record[0];
        this.slideAtomsSets = new SlideAtomsSet[0];
    }

    public void addSlidePersistAtom(SlidePersistAtom slidePersistAtom) {
        this.appendChildRecord(slidePersistAtom);
        SlideAtomsSet slideAtomsSet = new SlideAtomsSet(slidePersistAtom, new Record[0]);
        SlideAtomsSet[] slideAtomsSetArray = new SlideAtomsSet[this.slideAtomsSets.length + 1];
        System.arraycopy(this.slideAtomsSets, 0, slideAtomsSetArray, 0, this.slideAtomsSets.length);
        slideAtomsSetArray[slideAtomsSetArray.length - 1] = slideAtomsSet;
        this.slideAtomsSets = slideAtomsSetArray;
    }

    public int getInstance() {
        return LittleEndian.getShort(this._header, 0) >> 4;
    }

    public void setInstance(int n) {
        LittleEndian.putShort(this._header, 0, (short)(n << 4 | 0xF));
    }

    public SlideAtomsSet[] getSlideAtomsSets() {
        return this.slideAtomsSets;
    }

    public void setSlideAtomsSets(SlideAtomsSet[] slideAtomsSetArray) {
        this.slideAtomsSets = slideAtomsSetArray;
    }

    public long getRecordType() {
        return _type;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        this.writeOut(this._header[0], this._header[1], _type, this._children, outputStream);
    }

    public static class SlideAtomsSet {
        private SlidePersistAtom slidePersistAtom;
        private Record[] slideRecords;

        public SlidePersistAtom getSlidePersistAtom() {
            return this.slidePersistAtom;
        }

        public Record[] getSlideRecords() {
            return this.slideRecords;
        }

        public SlideAtomsSet(SlidePersistAtom slidePersistAtom, Record[] recordArray) {
            this.slidePersistAtom = slidePersistAtom;
            this.slideRecords = recordArray;
        }
    }
}

