/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public final class SlideAtom
extends RecordAtom {
    private byte[] _header;
    private static long _type = 1007L;
    public static final int MASTER_SLIDE_ID = 0;
    public static final int USES_MASTER_SLIDE_ID = Integer.MIN_VALUE;
    private int masterID;
    private int notesID;
    private boolean followMasterObjects;
    private boolean followMasterScheme;
    private boolean followMasterBackground;
    private SSlideLayoutAtom layoutAtom;
    private byte[] reserved;

    public int getMasterID() {
        return this.masterID;
    }

    public void setMasterID(int n) {
        this.masterID = n;
    }

    public int getNotesID() {
        return this.notesID;
    }

    public SSlideLayoutAtom getSSlideLayoutAtom() {
        return this.layoutAtom;
    }

    public void setNotesID(int n) {
        this.notesID = n;
    }

    public boolean getFollowMasterObjects() {
        return this.followMasterObjects;
    }

    public boolean getFollowMasterScheme() {
        return this.followMasterScheme;
    }

    public boolean getFollowMasterBackground() {
        return this.followMasterBackground;
    }

    public void setFollowMasterObjects(boolean bl) {
        this.followMasterObjects = bl;
    }

    public void setFollowMasterScheme(boolean bl) {
        this.followMasterScheme = bl;
    }

    public void setFollowMasterBackground(boolean bl) {
        this.followMasterBackground = bl;
    }

    protected SlideAtom(byte[] byArray, int n, int n2) {
        if (n2 < 30) {
            n2 = 30;
        }
        this._header = new byte[8];
        System.arraycopy(byArray, n, this._header, 0, 8);
        byte[] byArray2 = new byte[12];
        System.arraycopy(byArray, n + 8, byArray2, 0, 12);
        this.layoutAtom = new SSlideLayoutAtom(byArray2);
        this.masterID = LittleEndian.getInt(byArray, n + 12 + 8);
        this.notesID = LittleEndian.getInt(byArray, n + 16 + 8);
        int n3 = LittleEndian.getUShort(byArray, n + 20 + 8);
        this.followMasterBackground = (n3 & 4) == 4;
        this.followMasterScheme = (n3 & 2) == 2;
        this.followMasterObjects = (n3 & 1) == 1;
        this.reserved = new byte[n2 - 30];
        System.arraycopy(byArray, n + 30, this.reserved, 0, this.reserved.length);
    }

    public SlideAtom() {
        this._header = new byte[8];
        LittleEndian.putUShort(this._header, 0, 2);
        LittleEndian.putUShort(this._header, 2, (int)_type);
        LittleEndian.putInt(this._header, 4, 24);
        byte[] byArray = new byte[12];
        this.layoutAtom = new SSlideLayoutAtom(byArray);
        this.layoutAtom.setGeometryType(16);
        this.followMasterObjects = true;
        this.followMasterScheme = true;
        this.followMasterBackground = true;
        this.masterID = Integer.MIN_VALUE;
        this.notesID = 0;
        this.reserved = new byte[2];
    }

    public long getRecordType() {
        return _type;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        outputStream.write(this._header);
        this.layoutAtom.writeOut(outputStream);
        SlideAtom.writeLittleEndian(this.masterID, outputStream);
        SlideAtom.writeLittleEndian(this.notesID, outputStream);
        short s = 0;
        if (this.followMasterObjects) {
            s = (short)(s + 1);
        }
        if (this.followMasterScheme) {
            s = (short)(s + 2);
        }
        if (this.followMasterBackground) {
            s = (short)(s + 4);
        }
        SlideAtom.writeLittleEndian(s, outputStream);
        outputStream.write(this.reserved);
    }

    public static class SSlideLayoutAtom {
        public static final int TITLE_SLIDE = 0;
        public static final int TITLE_BODY_SLIDE = 1;
        public static final int TITLE_MASTER_SLIDE = 2;
        public static final int MASTER_SLIDE = 3;
        public static final int MASTER_NOTES = 4;
        public static final int NOTES_TITLE_BODY = 5;
        public static final int HANDOUT = 6;
        public static final int TITLE_ONLY = 7;
        public static final int TITLE_2_COLUMN_BODY = 8;
        public static final int TITLE_2_ROW_BODY = 9;
        public static final int TITLE_2_COLUNM_RIGHT_2_ROW_BODY = 10;
        public static final int TITLE_2_COLUNM_LEFT_2_ROW_BODY = 11;
        public static final int TITLE_2_ROW_BOTTOM_2_COLUMN_BODY = 12;
        public static final int TITLE_2_ROW_TOP_2_COLUMN_BODY = 13;
        public static final int FOUR_OBJECTS = 14;
        public static final int BIG_OBJECT = 15;
        public static final int BLANK_SLIDE = 16;
        public static final int VERTICAL_TITLE_BODY_LEFT = 17;
        public static final int VERTICAL_TITLE_2_ROW_BODY_LEFT = 17;
        private int geometry;
        private byte[] placeholderIDs;

        public int getGeometryType() {
            return this.geometry;
        }

        public void setGeometryType(int n) {
            this.geometry = n;
        }

        public SSlideLayoutAtom(byte[] byArray) {
            if (byArray.length != 12) {
                throw new RuntimeException("SSlideLayoutAtom created with byte array not 12 bytes long - was " + byArray.length + " bytes in size");
            }
            this.geometry = LittleEndian.getInt(byArray, 0);
            this.placeholderIDs = new byte[8];
            System.arraycopy(byArray, 4, this.placeholderIDs, 0, 8);
        }

        public void writeOut(OutputStream outputStream) throws IOException {
            Record.writeLittleEndian(this.geometry, outputStream);
            outputStream.write(this.placeholderIDs);
        }
    }
}

