/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.ColorSchemeAtom;
import ai2.org.apache.poi.hslf.record.PPDrawing;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.SheetContainer;
import ai2.org.apache.poi.hslf.record.SlideAtom;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public final class Slide
extends SheetContainer {
    private byte[] _header = new byte[8];
    private static long _type = 1006L;
    private SlideAtom slideAtom;
    private PPDrawing ppDrawing;
    private ColorSchemeAtom _colorScheme;

    public SlideAtom getSlideAtom() {
        return this.slideAtom;
    }

    public PPDrawing getPPDrawing() {
        return this.ppDrawing;
    }

    protected Slide(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._children = Record.findChildRecords(byArray, n + 8, n2 - 8);
        for (int i = 0; i < this._children.length; ++i) {
            if (this._children[i] instanceof SlideAtom) {
                this.slideAtom = (SlideAtom)this._children[i];
            } else if (this._children[i] instanceof PPDrawing) {
                this.ppDrawing = (PPDrawing)this._children[i];
            }
            if (this.ppDrawing == null || !(this._children[i] instanceof ColorSchemeAtom)) continue;
            this._colorScheme = (ColorSchemeAtom)this._children[i];
        }
    }

    public Slide() {
        LittleEndian.putUShort(this._header, 0, 15);
        LittleEndian.putUShort(this._header, 2, (int)_type);
        LittleEndian.putInt(this._header, 4, 0);
        this.slideAtom = new SlideAtom();
        this.ppDrawing = new PPDrawing();
        ColorSchemeAtom colorSchemeAtom = new ColorSchemeAtom();
        this._children = new Record[]{this.slideAtom, this.ppDrawing, colorSchemeAtom};
    }

    public long getRecordType() {
        return _type;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        this.writeOut(this._header[0], this._header[1], _type, this._children, outputStream);
    }

    public ColorSchemeAtom getColorScheme() {
        return this._colorScheme;
    }
}

