/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public class SSSlideInfoAtom
extends RecordAtom {
    public static final int MANUAL_ADVANCE_BIT = 1;
    public static final int HIDDEN_BIT = 4;
    public static final int SOUND_BIT = 16;
    public static final int LOOP_SOUND_BIT = 64;
    public static final int STOP_SOUND_BIT = 256;
    public static final int AUTO_ADVANCE_BIT = 1024;
    public static final int CURSOR_VISIBLE_BIT = 4096;
    private static final long _type = RecordTypes.SSSlideInfoAtom.typeID;
    private byte[] _header;
    private int _slideTime = 0;
    private int _soundIdRef = 0;
    private short _effectDirection = 0;
    private short _effectType = 0;
    private short _effectTransitionFlags = 0;
    private short _speed = 0;
    private byte[] _unused;

    public SSSlideInfoAtom() {
        this._header = new byte[8];
        LittleEndian.putShort(this._header, 0, (short)0);
        LittleEndian.putShort(this._header, 2, (short)_type);
        LittleEndian.putShort(this._header, 4, (short)16);
        LittleEndian.putShort(this._header, 6, (short)0);
        this._unused = new byte[3];
    }

    public SSSlideInfoAtom(byte[] byArray, int n, int n2) {
        int n3 = n;
        if (n2 != 24) {
            n2 = 24;
        }
        assert (byArray.length >= n + n2);
        this._header = LittleEndian.getByteArray(byArray, n3, 8);
        n3 += this._header.length;
        assert (LittleEndian.getShort(this._header, 0) == 0);
        assert (LittleEndian.getShort(this._header, 2) == RecordTypes.SSSlideInfoAtom.typeID);
        assert (LittleEndian.getShort(this._header, 4) == 16);
        assert (LittleEndian.getShort(this._header, 6) == 0);
        this._slideTime = LittleEndian.getInt(byArray, n3);
        assert (0 <= this._slideTime && this._slideTime <= 86399000);
        this._soundIdRef = LittleEndian.getInt(byArray, n3 += 4);
        this._effectDirection = LittleEndian.getUByte(byArray, n3 += 4);
        this._effectType = LittleEndian.getUByte(byArray, ++n3);
        this._effectTransitionFlags = LittleEndian.getShort(byArray, ++n3);
        this._speed = LittleEndian.getUByte(byArray, n3 += 2);
        this._unused = LittleEndian.getByteArray(byArray, ++n3, 3);
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        outputStream.write(this._header);
        SSSlideInfoAtom.writeLittleEndian(this._slideTime, outputStream);
        SSSlideInfoAtom.writeLittleEndian(this._soundIdRef, outputStream);
        byte[] byArray = new byte[1];
        LittleEndian.putUByte(byArray, 0, this._effectDirection);
        outputStream.write(byArray);
        LittleEndian.putUByte(byArray, 0, this._effectType);
        outputStream.write(byArray);
        SSSlideInfoAtom.writeLittleEndian(this._effectTransitionFlags, outputStream);
        LittleEndian.putUByte(byArray, 0, this._speed);
        outputStream.write(byArray);
        assert (this._unused.length == 3);
        outputStream.write(this._unused);
    }

    public long getRecordType() {
        return _type;
    }

    public int getSlideTime() {
        return this._slideTime;
    }

    public void setSlideTime(int n) {
        this._slideTime = n;
    }

    public int getSoundIdRef() {
        return this._soundIdRef;
    }

    public void setSoundIdRef(int n) {
        this._soundIdRef = n;
    }

    public short getEffectDirection() {
        return this._effectDirection;
    }

    public void setEffectDirection(short s) {
        this._effectDirection = s;
    }

    public short getEffectType() {
        return this._effectType;
    }

    public void setEffectType(short s) {
        this._effectType = s;
    }

    public short getEffectTransitionFlags() {
        return this._effectTransitionFlags;
    }

    public void setEffectTransitionFlags(short s) {
        this._effectTransitionFlags = s;
    }

    public void setEffectTransitionFlagByBit(int n, boolean bl) {
        this._effectTransitionFlags = bl ? (short)(this._effectTransitionFlags | n) : (short)(this._effectTransitionFlags & (0xFFFF ^ n));
    }

    public boolean getEffectTransitionFlagByBit(int n) {
        return (this._effectTransitionFlags & n) != 0;
    }

    public short getSpeed() {
        return this._speed;
    }

    public void setSpeed(short s) {
        this._speed = s;
    }
}

