/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.exceptions.CorruptPowerPointFileException;
import ai2.org.apache.poi.hslf.record.PositionDependentRecord;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;

public abstract class Record {
    protected static final POILogger logger = POILogFactory.getLogger(Record.class);

    public abstract boolean isAnAtom();

    public abstract long getRecordType();

    public abstract Record[] getChildRecords();

    public abstract void writeOut(OutputStream var1) throws IOException;

    public static void writeLittleEndian(int n, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[4];
        LittleEndian.putInt(byArray, 0, n);
        outputStream.write(byArray);
    }

    public static void writeLittleEndian(short s, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[2];
        LittleEndian.putShort(byArray, 0, s);
        outputStream.write(byArray);
    }

    public static Record buildRecordAtOffset(byte[] byArray, int n) {
        long l = LittleEndian.getUShort(byArray, n + 2);
        long l2 = LittleEndian.getUInt(byArray, n + 4);
        int n2 = (int)l2;
        if (n2 < 0) {
            n2 = 0;
        }
        return Record.createRecordForType(l, byArray, n, 8 + n2);
    }

    public static Record[] findChildRecords(byte[] byArray, int n, int n2) {
        int n3;
        ArrayList<Record> arrayList = new ArrayList<Record>(5);
        for (int i = n; i <= n + n2 - 8; i += n3) {
            long l = LittleEndian.getUShort(byArray, i + 2);
            long l2 = LittleEndian.getUInt(byArray, i + 4);
            n3 = (int)l2;
            if (n3 < 0) {
                n3 = 0;
            }
            if (i == 0 && l == 0L && n3 == 65535) {
                throw new CorruptPowerPointFileException("Corrupt document - starts with record of type 0000 and length 0xFFFF");
            }
            Record record = Record.createRecordForType(l, byArray, i, 8 + n3);
            if (record != null) {
                arrayList.add(record);
            }
            i += 8;
        }
        Record[] recordArray = arrayList.toArray(new Record[arrayList.size()]);
        return recordArray;
    }

    public static Record createRecordForType(long l, byte[] byArray, int n, int n2) {
        Object object;
        Record record = null;
        if (n + n2 > byArray.length) {
            logger.log(5, new Object[]{"Warning: Skipping record of type " + l + " at position " + n + " which claims to be longer than the file! (" + n2 + " vs " + (byArray.length - n) + ")"});
            return null;
        }
        Class<? extends Record> clazz = null;
        try {
            clazz = RecordTypes.recordHandlingClass((int)l);
            if (clazz == null) {
                clazz = RecordTypes.recordHandlingClass(RecordTypes.Unknown.typeID);
            }
            object = clazz.getDeclaredConstructor(byte[].class, Integer.TYPE, Integer.TYPE);
            record = ((Constructor)object).newInstance(byArray, n, n2);
        }
        catch (InstantiationException instantiationException) {
            throw new RuntimeException("Couldn't instantiate the class for type with id " + l + " on class " + clazz + " : " + instantiationException, instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new RuntimeException("Couldn't instantiate the class for type with id " + l + " on class " + clazz + " : " + invocationTargetException + "\nCause was : " + invocationTargetException.getCause(), invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException("Couldn't access the constructor for type with id " + l + " on class " + clazz + " : " + illegalAccessException, illegalAccessException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("Couldn't access the constructor for type with id " + l + " on class " + clazz + " : " + noSuchMethodException, noSuchMethodException);
        }
        if (record instanceof PositionDependentRecord) {
            object = (PositionDependentRecord)((Object)record);
            object.setLastOnDiskOffset(n);
        }
        return record;
    }
}

