/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.ddf.DefaultEscherRecordFactory;
import ai2.org.apache.poi.ddf.EscherBSERecord;
import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherDggRecord;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.hslf.record.HSLFEscherRecordFactory;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;

public final class PPDrawingGroup
extends RecordAtom {
    private byte[] _header = new byte[8];
    private EscherContainerRecord dggContainer;
    private EscherDggRecord dgg;

    protected PPDrawingGroup(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this._header, 0, 8);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        HSLFEscherRecordFactory hSLFEscherRecordFactory = new HSLFEscherRecordFactory();
        EscherRecord escherRecord = ((DefaultEscherRecordFactory)hSLFEscherRecordFactory).createRecord(byArray2, 0);
        escherRecord.fillFields(byArray2, 0, hSLFEscherRecordFactory);
        this.dggContainer = (EscherContainerRecord)escherRecord.getChild(0);
    }

    public long getRecordType() {
        return RecordTypes.PPDrawingGroup.typeID;
    }

    public Record[] getChildRecords() {
        return null;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        Object object;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Iterator<EscherRecord> iterator = this.dggContainer.getChildIterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = iterator.next();
            if (escherRecord.getRecordId() == -4095) {
                object = (EscherContainerRecord)escherRecord;
                ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
                Object object2 = ((EscherContainerRecord)object).getChildIterator();
                while (object2.hasNext()) {
                    EscherBSERecord escherBSERecord = (EscherBSERecord)object2.next();
                    byte[] byArray = new byte[44];
                    escherBSERecord.serialize(0, byArray);
                    byteArrayOutputStream2.write(byArray);
                }
                object2 = new byte[8];
                LittleEndian.putShort((byte[])object2, 0, ((EscherRecord)object).getOptions());
                LittleEndian.putShort((byte[])object2, 2, ((EscherRecord)object).getRecordId());
                LittleEndian.putInt((byte[])object2, 4, byteArrayOutputStream2.size());
                byteArrayOutputStream.write((byte[])object2);
                byteArrayOutputStream.write(byteArrayOutputStream2.toByteArray());
                continue;
            }
            byteArrayOutputStream.write(escherRecord.serialize());
        }
        int n = byteArrayOutputStream.size();
        LittleEndian.putInt(this._header, 4, n + 8);
        outputStream.write(this._header);
        object = new byte[8];
        LittleEndian.putShort((byte[])object, 0, this.dggContainer.getOptions());
        LittleEndian.putShort((byte[])object, 2, this.dggContainer.getRecordId());
        LittleEndian.putInt((byte[])object, 4, n);
        outputStream.write((byte[])object);
        outputStream.write(byteArrayOutputStream.toByteArray());
    }

    public EscherContainerRecord getDggContainer() {
        return this.dggContainer;
    }

    public EscherDggRecord getEscherDggRecord() {
        if (this.dgg == null) {
            Iterator<EscherRecord> iterator = this.dggContainer.getChildIterator();
            while (iterator.hasNext()) {
                EscherRecord escherRecord = iterator.next();
                if (!(escherRecord instanceof EscherDggRecord)) continue;
                this.dgg = (EscherDggRecord)escherRecord;
                break;
            }
        }
        return this.dgg;
    }
}

