/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.ddf.DefaultEscherRecordFactory;
import ai2.org.apache.poi.ddf.EscherBoolProperty;
import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherDgRecord;
import ai2.org.apache.poi.ddf.EscherOptRecord;
import ai2.org.apache.poi.ddf.EscherRGBProperty;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.ddf.EscherSimpleProperty;
import ai2.org.apache.poi.ddf.EscherSpRecord;
import ai2.org.apache.poi.ddf.EscherSpgrRecord;
import ai2.org.apache.poi.ddf.EscherTextboxRecord;
import ai2.org.apache.poi.ddf.UnknownEscherRecord;
import ai2.org.apache.poi.hslf.record.BinaryTagDataBlob;
import ai2.org.apache.poi.hslf.record.CString;
import ai2.org.apache.poi.hslf.record.EscherTextboxWrapper;
import ai2.org.apache.poi.hslf.record.HSLFEscherRecordFactory;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.hslf.record.StyleTextProp9Atom;
import ai2.org.apache.poi.sl.usermodel.ShapeType;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PPDrawing
extends RecordAtom {
    private byte[] _header = new byte[8];
    private long _type;
    private EscherRecord[] childRecords;
    private EscherTextboxWrapper[] textboxWrappers;
    private EscherDgRecord dg;

    public EscherRecord[] getEscherRecords() {
        return this.childRecords;
    }

    public EscherTextboxWrapper[] getTextboxWrappers() {
        return this.textboxWrappers;
    }

    protected PPDrawing(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._type = LittleEndian.getUShort(this._header, 2);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        HSLFEscherRecordFactory hSLFEscherRecordFactory = new HSLFEscherRecordFactory();
        ArrayList<EscherRecord> arrayList = new ArrayList<EscherRecord>();
        this.findEscherChildren(hSLFEscherRecordFactory, byArray2, 8, n2 - 8, arrayList);
        this.childRecords = arrayList.toArray(new EscherRecord[arrayList.size()]);
        if (1 == this.childRecords.length && -4094 == this.childRecords[0].getRecordId() && this.childRecords[0] instanceof EscherContainerRecord) {
            this.textboxWrappers = this.findInDgContainer((EscherContainerRecord)this.childRecords[0]);
        } else {
            ArrayList<EscherTextboxWrapper> arrayList2 = new ArrayList<EscherTextboxWrapper>();
            this.findEscherTextboxRecord(this.childRecords, arrayList2);
            this.textboxWrappers = arrayList2.toArray(new EscherTextboxWrapper[arrayList2.size()]);
        }
    }

    private EscherTextboxWrapper[] findInDgContainer(EscherContainerRecord escherContainerRecord) {
        EscherContainerRecord[] escherContainerRecordArray;
        LinkedList<EscherTextboxWrapper> linkedList = new LinkedList<EscherTextboxWrapper>();
        EscherContainerRecord escherContainerRecord2 = this.findFirstEscherContainerRecordOfType((short)-4093, escherContainerRecord);
        for (EscherContainerRecord escherContainerRecord3 : escherContainerRecordArray = this.findAllEscherContainerRecordOfType((short)-4092, escherContainerRecord2)) {
            StyleTextProp9Atom styleTextProp9Atom = this.findInSpContainer(escherContainerRecord3);
            EscherSpRecord escherSpRecord = (EscherSpRecord)this.findFirstEscherRecordOfType((short)-4086, escherContainerRecord3);
            EscherTextboxRecord escherTextboxRecord = (EscherTextboxRecord)this.findFirstEscherRecordOfType((short)-4083, escherContainerRecord3);
            if (null == escherTextboxRecord) continue;
            EscherTextboxWrapper escherTextboxWrapper = new EscherTextboxWrapper(escherTextboxRecord);
            escherTextboxWrapper.setStyleTextProp9Atom(styleTextProp9Atom);
            if (null != escherSpRecord) {
                escherTextboxWrapper.setShapeId(escherSpRecord.getShapeId());
            }
            linkedList.add(escherTextboxWrapper);
        }
        return linkedList.toArray(new EscherTextboxWrapper[linkedList.size()]);
    }

    private StyleTextProp9Atom findInSpContainer(EscherContainerRecord escherContainerRecord) {
        EscherContainerRecord escherContainerRecord2 = this.findFirstEscherContainerRecordOfType((short)-4079, escherContainerRecord);
        if (null == escherContainerRecord2) {
            return null;
        }
        EscherContainerRecord escherContainerRecord3 = this.findFirstEscherContainerRecordOfType((short)5000, escherContainerRecord2);
        if (null == escherContainerRecord3) {
            return null;
        }
        EscherContainerRecord escherContainerRecord4 = this.findFirstEscherContainerRecordOfType((short)5002, escherContainerRecord3);
        if (null == escherContainerRecord4) {
            return null;
        }
        int n = escherContainerRecord4.getChildRecords().size();
        if (2 != n) {
            return null;
        }
        Record record = this.buildFromUnknownEscherRecord((UnknownEscherRecord)escherContainerRecord4.getChild(0));
        Record record2 = this.buildFromUnknownEscherRecord((UnknownEscherRecord)escherContainerRecord4.getChild(1));
        if (!(record instanceof CString)) {
            return null;
        }
        if (!"___PPT9".equals(((CString)record).getText())) {
            return null;
        }
        if (!(record2 instanceof BinaryTagDataBlob)) {
            return null;
        }
        BinaryTagDataBlob binaryTagDataBlob = (BinaryTagDataBlob)record2;
        if (1 != binaryTagDataBlob.getChildRecords().length) {
            return null;
        }
        return (StyleTextProp9Atom)binaryTagDataBlob.findFirstOfType(RecordTypes.StyleTextProp9Atom.typeID);
    }

    public PPDrawing() {
        LittleEndian.putUShort(this._header, 0, 15);
        LittleEndian.putUShort(this._header, 2, RecordTypes.PPDrawing.typeID);
        LittleEndian.putInt(this._header, 4, 0);
        this.textboxWrappers = new EscherTextboxWrapper[0];
        this.create();
    }

    private void findEscherChildren(DefaultEscherRecordFactory defaultEscherRecordFactory, byte[] byArray, int n, int n2, List<EscherRecord> list) {
        int n3 = LittleEndian.getInt(byArray, n + 4) + 8;
        EscherRecord escherRecord = defaultEscherRecordFactory.createRecord(byArray, n);
        escherRecord.fillFields(byArray, n, defaultEscherRecordFactory);
        list.add(escherRecord);
        int n4 = escherRecord.getRecordSize();
        if (n4 < 8) {
            logger.log(5, new Object[]{"Hit short DDF record at " + n + " - " + n4});
        }
        if (n4 != n3) {
            logger.log(5, new Object[]{"Record length=" + n3 + " but getRecordSize() returned " + escherRecord.getRecordSize() + "; record: " + escherRecord.getClass()});
            n4 = n3;
        }
        n += n4;
        if ((n2 -= n4) >= 8) {
            this.findEscherChildren(defaultEscherRecordFactory, byArray, n, n2, list);
        }
    }

    private void findEscherTextboxRecord(EscherRecord[] escherRecordArray, List<EscherTextboxWrapper> list) {
        block0: for (int i = 0; i < escherRecordArray.length; ++i) {
            EscherRecord[] escherRecordArray2;
            Object object;
            if (escherRecordArray[i] instanceof EscherTextboxRecord) {
                object = (EscherTextboxRecord)escherRecordArray[i];
                escherRecordArray2 = new EscherTextboxWrapper((EscherTextboxRecord)object);
                list.add((EscherTextboxWrapper)escherRecordArray2);
                for (int j = i; j >= 0; --j) {
                    if (!(escherRecordArray[j] instanceof EscherSpRecord)) continue;
                    EscherSpRecord escherSpRecord = (EscherSpRecord)escherRecordArray[j];
                    escherRecordArray2.setShapeId(escherSpRecord.getShapeId());
                    continue block0;
                }
                continue;
            }
            if (!escherRecordArray[i].isContainerRecord()) continue;
            object = escherRecordArray[i].getChildRecords();
            escherRecordArray2 = new EscherRecord[object.size()];
            object.toArray(escherRecordArray2);
            this.findEscherTextboxRecord(escherRecordArray2, list);
        }
    }

    @Override
    public long getRecordType() {
        return this._type;
    }

    @Override
    public Record[] getChildRecords() {
        return null;
    }

    @Override
    public void writeOut(OutputStream outputStream) throws IOException {
        for (EscherTextboxWrapper i : this.textboxWrappers) {
            i.writeOut(null);
        }
        int n = 0;
        for (EscherRecord n3 : this.childRecords) {
            n += n3.getRecordSize();
        }
        LittleEndian.putInt(this._header, 4, n);
        outputStream.write(this._header);
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (int i = 0; i < this.childRecords.length; ++i) {
            int n3 = this.childRecords[i].serialize(n2, byArray);
            n2 += n3;
        }
        outputStream.write(byArray);
    }

    private void create() {
        EscherContainerRecord escherContainerRecord = new EscherContainerRecord();
        escherContainerRecord.setRecordId((short)-4094);
        escherContainerRecord.setOptions((short)15);
        EscherDgRecord escherDgRecord = new EscherDgRecord();
        escherDgRecord.setOptions((short)16);
        escherDgRecord.setNumShapes(1);
        escherContainerRecord.addChildRecord(escherDgRecord);
        EscherContainerRecord escherContainerRecord2 = new EscherContainerRecord();
        escherContainerRecord2.setOptions((short)15);
        escherContainerRecord2.setRecordId((short)-4093);
        EscherContainerRecord escherContainerRecord3 = new EscherContainerRecord();
        escherContainerRecord3.setOptions((short)15);
        escherContainerRecord3.setRecordId((short)-4092);
        EscherSpgrRecord escherSpgrRecord = new EscherSpgrRecord();
        escherSpgrRecord.setOptions((short)1);
        escherContainerRecord3.addChildRecord(escherSpgrRecord);
        EscherSpRecord escherSpRecord = new EscherSpRecord();
        escherSpRecord.setOptions((short)((ShapeType.NOT_PRIMITIVE.nativeId << 4) + 2));
        escherSpRecord.setFlags(5);
        escherContainerRecord3.addChildRecord(escherSpRecord);
        escherContainerRecord2.addChildRecord(escherContainerRecord3);
        escherContainerRecord.addChildRecord(escherContainerRecord2);
        escherContainerRecord3 = new EscherContainerRecord();
        escherContainerRecord3.setOptions((short)15);
        escherContainerRecord3.setRecordId((short)-4092);
        escherSpRecord = new EscherSpRecord();
        escherSpRecord.setOptions((short)((ShapeType.RECT.nativeId << 4) + 2));
        escherSpRecord.setFlags(3072);
        escherContainerRecord3.addChildRecord(escherSpRecord);
        EscherOptRecord escherOptRecord = new EscherOptRecord();
        escherOptRecord.setRecordId((short)-4085);
        escherOptRecord.addEscherProperty(new EscherRGBProperty(385, 0x8000000));
        escherOptRecord.addEscherProperty(new EscherRGBProperty(387, 0x8000005));
        escherOptRecord.addEscherProperty(new EscherSimpleProperty(403, 10064750));
        escherOptRecord.addEscherProperty(new EscherSimpleProperty(404, 7778750));
        escherOptRecord.addEscherProperty(new EscherBoolProperty(447, 0x120012));
        escherOptRecord.addEscherProperty(new EscherBoolProperty(511, 524288));
        escherOptRecord.addEscherProperty(new EscherSimpleProperty(772, 9));
        escherOptRecord.addEscherProperty(new EscherSimpleProperty(831, 65537));
        escherContainerRecord3.addChildRecord(escherOptRecord);
        escherContainerRecord.addChildRecord(escherContainerRecord3);
        this.childRecords = new EscherRecord[]{escherContainerRecord};
    }

    public void addTextboxWrapper(EscherTextboxWrapper escherTextboxWrapper) {
        EscherTextboxWrapper[] escherTextboxWrapperArray = new EscherTextboxWrapper[this.textboxWrappers.length + 1];
        System.arraycopy(this.textboxWrappers, 0, escherTextboxWrapperArray, 0, this.textboxWrappers.length);
        escherTextboxWrapperArray[this.textboxWrappers.length] = escherTextboxWrapper;
        this.textboxWrappers = escherTextboxWrapperArray;
    }

    public EscherDgRecord getEscherDgRecord() {
        if (this.dg == null) {
            EscherContainerRecord escherContainerRecord = (EscherContainerRecord)this.childRecords[0];
            Iterator<EscherRecord> iterator = escherContainerRecord.getChildIterator();
            while (iterator.hasNext()) {
                EscherRecord escherRecord = iterator.next();
                if (!(escherRecord instanceof EscherDgRecord)) continue;
                this.dg = (EscherDgRecord)escherRecord;
                break;
            }
        }
        return this.dg;
    }

    protected EscherContainerRecord findFirstEscherContainerRecordOfType(short s, EscherContainerRecord escherContainerRecord) {
        if (null == escherContainerRecord) {
            return null;
        }
        List<EscherContainerRecord> list = escherContainerRecord.getChildContainers();
        for (EscherContainerRecord escherContainerRecord2 : list) {
            if (s != escherContainerRecord2.getRecordId()) continue;
            return escherContainerRecord2;
        }
        return null;
    }

    protected EscherRecord findFirstEscherRecordOfType(short s, EscherContainerRecord escherContainerRecord) {
        if (null == escherContainerRecord) {
            return null;
        }
        List<EscherRecord> list = escherContainerRecord.getChildRecords();
        for (EscherRecord escherRecord : list) {
            if (s != escherRecord.getRecordId()) continue;
            return escherRecord;
        }
        return null;
    }

    protected EscherContainerRecord[] findAllEscherContainerRecordOfType(short s, EscherContainerRecord escherContainerRecord) {
        if (null == escherContainerRecord) {
            return new EscherContainerRecord[0];
        }
        List<EscherContainerRecord> list = escherContainerRecord.getChildContainers();
        LinkedList<EscherContainerRecord> linkedList = new LinkedList<EscherContainerRecord>();
        for (EscherContainerRecord escherContainerRecord2 : list) {
            if (s != escherContainerRecord2.getRecordId()) continue;
            linkedList.add(escherContainerRecord2);
        }
        return linkedList.toArray(new EscherContainerRecord[linkedList.size()]);
    }

    protected Record buildFromUnknownEscherRecord(UnknownEscherRecord unknownEscherRecord) {
        byte[] byArray = unknownEscherRecord.getData();
        byte[] byArray2 = new byte[8 + byArray.length];
        System.arraycopy(byArray, 0, byArray2, 8, byArray.length);
        short s = unknownEscherRecord.getVersion();
        short s2 = unknownEscherRecord.getRecordId();
        int n = unknownEscherRecord.getRecordSize();
        LittleEndian.putShort(byArray2, 0, s);
        LittleEndian.putShort(byArray2, 2, s2);
        LittleEndian.putInt(byArray2, 4, n);
        return Record.createRecordForType(s2, byArray2, 0, byArray2.length);
    }

    public StyleTextProp9Atom[] getNumberedListInfo() {
        EscherContainerRecord[] escherContainerRecordArray;
        LinkedList<StyleTextProp9Atom> linkedList = new LinkedList<StyleTextProp9Atom>();
        EscherContainerRecord escherContainerRecord = (EscherContainerRecord)this.childRecords[0];
        EscherContainerRecord escherContainerRecord2 = this.findFirstEscherContainerRecordOfType((short)-4093, escherContainerRecord);
        for (EscherContainerRecord escherContainerRecord3 : escherContainerRecordArray = this.findAllEscherContainerRecordOfType((short)-4092, escherContainerRecord2)) {
            StyleTextProp9Atom styleTextProp9Atom = this.findInSpContainer(escherContainerRecord3);
            if (styleTextProp9Atom == null) continue;
            linkedList.add(styleTextProp9Atom);
        }
        return linkedList.toArray(new StyleTextProp9Atom[linkedList.size()]);
    }
}

