/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public final class OutlineTextRefAtom
extends RecordAtom {
    private byte[] _header;
    private int _index;

    protected OutlineTextRefAtom(byte[] byArray, int n, int n2) {
        this._header = new byte[8];
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._index = LittleEndian.getInt(byArray, n + 8);
    }

    protected OutlineTextRefAtom() {
        this._index = 0;
        this._header = new byte[8];
        LittleEndian.putUShort(this._header, 0, 0);
        LittleEndian.putUShort(this._header, 2, (int)this.getRecordType());
        LittleEndian.putInt(this._header, 4, 4);
    }

    public long getRecordType() {
        return RecordTypes.OutlineTextRefAtom.typeID;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        outputStream.write(this._header);
        byte[] byArray = new byte[4];
        LittleEndian.putInt(byArray, 0, this._index);
        outputStream.write(byArray);
    }

    public void setTextIndex(int n) {
        this._index = n;
    }

    public int getTextIndex() {
        return this._index;
    }
}

