/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public final class OEPlaceholderAtom
extends RecordAtom {
    public static final int PLACEHOLDER_FULLSIZE = 0;
    public static final int PLACEHOLDER_HALFSIZE = 1;
    public static final int PLACEHOLDER_QUARTSIZE = 2;
    public static final byte None = 0;
    public static final byte MasterTitle = 1;
    public static final byte MasterBody = 2;
    public static final byte MasterCenteredTitle = 3;
    public static final byte MasterSubTitle = 4;
    public static final byte MasterNotesSlideImage = 5;
    public static final byte MasterNotesBody = 6;
    public static final byte MasterDate = 7;
    public static final byte MasterSlideNumber = 8;
    public static final byte MasterFooter = 9;
    public static final byte MasterHeader = 10;
    public static final byte NotesSlideImage = 11;
    public static final byte NotesBody = 12;
    public static final byte Title = 13;
    public static final byte Body = 14;
    public static final byte CenteredTitle = 15;
    public static final byte Subtitle = 16;
    public static final byte VerticalTextTitle = 17;
    public static final byte VerticalTextBody = 18;
    public static final byte Object = 19;
    public static final byte Graph = 20;
    public static final byte Table = 21;
    public static final byte ClipArt = 22;
    public static final byte OrganizationChart = 23;
    public static final byte MediaClip = 24;
    private byte[] _header = new byte[8];
    private int placementId;
    private int placeholderId;
    private int placeholderSize;

    public OEPlaceholderAtom() {
        LittleEndian.putUShort(this._header, 0, 0);
        LittleEndian.putUShort(this._header, 2, (int)this.getRecordType());
        LittleEndian.putInt(this._header, 4, 8);
        this.placementId = 0;
        this.placeholderId = 0;
        this.placeholderSize = 0;
    }

    protected OEPlaceholderAtom(byte[] byArray, int n, int n2) {
        int n3 = n;
        System.arraycopy(byArray, n, this._header, 0, 8);
        this.placementId = LittleEndian.getInt(byArray, n3 += this._header.length);
        this.placeholderId = LittleEndian.getUnsignedByte(byArray, n3 += 4);
        this.placeholderSize = LittleEndian.getUnsignedByte(byArray, ++n3);
        ++n3;
    }

    public long getRecordType() {
        return RecordTypes.OEPlaceholderAtom.typeID;
    }

    public int getPlacementId() {
        return this.placementId;
    }

    public void setPlacementId(int n) {
        this.placementId = n;
    }

    public int getPlaceholderId() {
        return this.placeholderId;
    }

    public void setPlaceholderId(byte by) {
        this.placeholderId = by;
    }

    public int getPlaceholderSize() {
        return this.placeholderSize;
    }

    public void setPlaceholderSize(byte by) {
        this.placeholderSize = by;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        outputStream.write(this._header);
        byte[] byArray = new byte[8];
        LittleEndian.putInt(byArray, 0, this.placementId);
        byArray[4] = (byte)this.placeholderId;
        byArray[5] = (byte)this.placeholderSize;
        outputStream.write(byArray);
    }
}

