/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public final class NotesAtom
extends RecordAtom {
    private byte[] _header;
    private static long _type = 1009L;
    private int slideID;
    private boolean followMasterObjects;
    private boolean followMasterScheme;
    private boolean followMasterBackground;
    private byte[] reserved;

    public int getSlideID() {
        return this.slideID;
    }

    public void setSlideID(int n) {
        this.slideID = n;
    }

    public boolean getFollowMasterObjects() {
        return this.followMasterObjects;
    }

    public boolean getFollowMasterScheme() {
        return this.followMasterScheme;
    }

    public boolean getFollowMasterBackground() {
        return this.followMasterBackground;
    }

    public void setFollowMasterObjects(boolean bl) {
        this.followMasterObjects = bl;
    }

    public void setFollowMasterScheme(boolean bl) {
        this.followMasterScheme = bl;
    }

    public void setFollowMasterBackground(boolean bl) {
        this.followMasterBackground = bl;
    }

    protected NotesAtom(byte[] byArray, int n, int n2) {
        if (n2 < 8) {
            n2 = 8;
        }
        this._header = new byte[8];
        System.arraycopy(byArray, n, this._header, 0, 8);
        this.slideID = LittleEndian.getInt(byArray, n + 8);
        int n3 = LittleEndian.getUShort(byArray, n + 12);
        this.followMasterBackground = (n3 & 4) == 4;
        this.followMasterScheme = (n3 & 2) == 2;
        this.followMasterObjects = (n3 & 1) == 1;
        this.reserved = new byte[n2 - 14];
        System.arraycopy(byArray, n + 14, this.reserved, 0, this.reserved.length);
    }

    public long getRecordType() {
        return _type;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        outputStream.write(this._header);
        NotesAtom.writeLittleEndian(this.slideID, outputStream);
        short s = 0;
        if (this.followMasterObjects) {
            s = (short)(s + 1);
        }
        if (this.followMasterScheme) {
            s = (short)(s + 2);
        }
        if (this.followMasterBackground) {
            s = (short)(s + 4);
        }
        NotesAtom.writeLittleEndian(s, outputStream);
        outputStream.write(this.reserved);
    }
}

