/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.model.textproperties.IndentProp;
import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MasterTextPropAtom
extends RecordAtom {
    private byte[] _header = new byte[8];
    private byte[] _data;
    private List<IndentProp> indents;

    public MasterTextPropAtom() {
        this._data = new byte[0];
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        LittleEndian.putInt(this._header, 4, this._data.length);
        this.indents = new ArrayList<IndentProp>();
    }

    protected MasterTextPropAtom(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._data = new byte[n2 - 8];
        System.arraycopy(byArray, n + 8, this._data, 0, n2 - 8);
        try {
            this.read();
        }
        catch (Exception exception) {
            logger.log(7, new Object[]{"Failed to parse MasterTextPropAtom: " + exception.getMessage()});
            exception.printStackTrace();
        }
    }

    @Override
    public long getRecordType() {
        return RecordTypes.MasterTextPropAtom.typeID;
    }

    @Override
    public void writeOut(OutputStream outputStream) throws IOException {
        this.write();
        outputStream.write(this._header);
        outputStream.write(this._data);
    }

    private void write() {
        int n = 0;
        this._data = new byte[this.indents.size() * 6];
        for (IndentProp indentProp : this.indents) {
            LittleEndian.putInt(this._data, n, indentProp.getCharactersCovered());
            LittleEndian.putShort(this._data, n + 4, (short)indentProp.getIndentLevel());
            n += 6;
        }
    }

    private void read() {
        this.indents = new ArrayList<IndentProp>(this._data.length / 6);
        for (int i = 0; i <= this._data.length - 6; i += 6) {
            int n = LittleEndian.getInt(this._data, i);
            short s = LittleEndian.getShort(this._data, i + 4);
            this.indents.add(new IndentProp(n, s));
        }
    }

    public int getIndentAt(int n) {
        int n2 = 0;
        for (IndentProp indentProp : this.indents) {
            if (n >= (n2 += indentProp.getCharactersCovered())) continue;
            return indentProp.getIndentLevel();
        }
        return -1;
    }

    public List<IndentProp> getIndents() {
        return Collections.unmodifiableList(this.indents);
    }
}

