/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.InteractiveInfoAtom;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordContainer;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public class InteractiveInfo
extends RecordContainer {
    private byte[] _header = new byte[8];
    private static long _type = 4082L;
    private InteractiveInfoAtom infoAtom;

    public InteractiveInfoAtom getInteractiveInfoAtom() {
        return this.infoAtom;
    }

    protected InteractiveInfo(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._children = Record.findChildRecords(byArray, n + 8, n2 - 8);
        this.findInterestingChildren();
    }

    private void findInterestingChildren() {
        if (!(this._children[0] instanceof InteractiveInfoAtom)) {
            throw new IllegalStateException("First child record wasn't a InteractiveInfoAtom, was of type " + this._children[0].getRecordType());
        }
        this.infoAtom = (InteractiveInfoAtom)this._children[0];
    }

    public InteractiveInfo() {
        this._children = new Record[1];
        this._header[0] = 15;
        LittleEndian.putShort(this._header, 2, (short)_type);
        this.infoAtom = new InteractiveInfoAtom();
        this._children[0] = this.infoAtom;
    }

    public long getRecordType() {
        return _type;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        this.writeOut(this._header[0], this._header[1], _type, this._children, outputStream);
    }
}

