/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public final class HeadersFootersAtom
extends RecordAtom {
    public static final int fHasDate = 1;
    public static final int fHasTodayDate = 2;
    public static final int fHasUserDate = 4;
    public static final int fHasSlideNumber = 8;
    public static final int fHasHeader = 16;
    public static final int fHasFooter = 32;
    private byte[] _header;
    private byte[] _recdata;

    protected HeadersFootersAtom(byte[] byArray, int n, int n2) {
        this._header = new byte[8];
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._recdata = new byte[n2 - 8];
        System.arraycopy(byArray, n + 8, this._recdata, 0, n2 - 8);
    }

    public HeadersFootersAtom() {
        this._recdata = new byte[4];
        this._header = new byte[8];
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        LittleEndian.putInt(this._header, 4, this._recdata.length);
    }

    public long getRecordType() {
        return RecordTypes.HeadersFootersAtom.typeID;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        outputStream.write(this._header);
        outputStream.write(this._recdata);
    }

    public int getFormatId() {
        return LittleEndian.getShort(this._recdata, 0);
    }

    public void setFormatId(int n) {
        LittleEndian.putUShort(this._recdata, 0, n);
    }

    public int getMask() {
        return LittleEndian.getShort(this._recdata, 2);
    }

    public void setMask(int n) {
        LittleEndian.putUShort(this._recdata, 2, n);
    }

    public boolean getFlag(int n) {
        return (this.getMask() & n) != 0;
    }

    public void setFlag(int n, boolean bl) {
        int n2 = this.getMask();
        n2 = bl ? (n2 |= n) : (n2 &= ~n);
        this.setMask(n2);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("HeadersFootersAtom\n");
        stringBuffer.append("\tFormatId: " + this.getFormatId() + "\n");
        stringBuffer.append("\tMask    : " + this.getMask() + "\n");
        stringBuffer.append("\t  fHasDate        : " + this.getFlag(1) + "\n");
        stringBuffer.append("\t  fHasTodayDate   : " + this.getFlag(2) + "\n");
        stringBuffer.append("\t  fHasUserDate    : " + this.getFlag(4) + "\n");
        stringBuffer.append("\t  fHasSlideNumber : " + this.getFlag(8) + "\n");
        stringBuffer.append("\t  fHasHeader      : " + this.getFlag(16) + "\n");
        stringBuffer.append("\t  fHasFooter      : " + this.getFlag(32) + "\n");
        return stringBuffer.toString();
    }
}

