/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.ddf.DefaultEscherRecordFactory;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.hslf.record.EscherPlaceholder;
import ai2.org.apache.poi.util.LittleEndian;
import java.lang.reflect.Constructor;
import java.util.Map;

public class HSLFEscherRecordFactory
extends DefaultEscherRecordFactory {
    private static Class<?>[] escherRecordClasses = new Class[]{EscherPlaceholder.class};
    private static Map<Short, Constructor<? extends EscherRecord>> recordsMap = HSLFEscherRecordFactory.recordsToMap(escherRecordClasses);

    public EscherRecord createRecord(byte[] byArray, int n) {
        short s = LittleEndian.getShort(byArray, n);
        short s2 = LittleEndian.getShort(byArray, n + 2);
        Constructor<? extends EscherRecord> constructor = recordsMap.get(s2);
        if (constructor == null) {
            return super.createRecord(byArray, n);
        }
        EscherRecord escherRecord = null;
        try {
            escherRecord = constructor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            return super.createRecord(byArray, n);
        }
        escherRecord.setRecordId(s2);
        escherRecord.setOptions(s);
        return escherRecord;
    }
}

