/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.StringUtil;
import java.io.IOException;
import java.io.OutputStream;

public final class FontEntityAtom
extends RecordAtom {
    private byte[] _header;
    private byte[] _recdata;

    protected FontEntityAtom(byte[] byArray, int n, int n2) {
        this._header = new byte[8];
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._recdata = new byte[n2 - 8];
        System.arraycopy(byArray, n + 8, this._recdata, 0, n2 - 8);
    }

    public FontEntityAtom() {
        this._recdata = new byte[68];
        this._header = new byte[8];
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        LittleEndian.putInt(this._header, 4, this._recdata.length);
    }

    public long getRecordType() {
        return RecordTypes.FontEntityAtom.typeID;
    }

    public String getFontName() {
        int n = Math.min(this._recdata.length, 64);
        for (int i = 0; i < n; i += 2) {
            if (this._recdata[i] != 0 || this._recdata[i + 1] != 0) continue;
            return StringUtil.getFromUnicodeLE(this._recdata, 0, i / 2);
        }
        return null;
    }

    public void setFontName(String string) {
        if (!string.endsWith("\u0000")) {
            string = string + '\u0000';
        }
        if (string.length() > 32) {
            throw new RuntimeException("The length of the font name, including null termination, must not exceed 32 characters");
        }
        byte[] byArray = StringUtil.getToUnicodeLE(string);
        System.arraycopy(byArray, 0, this._recdata, 0, byArray.length);
    }

    public void setFontIndex(int n) {
        LittleEndian.putShort(this._header, 0, (short)n);
    }

    public int getFontIndex() {
        return LittleEndian.getShort(this._header, 0) >> 4;
    }

    public void setCharSet(int n) {
        this._recdata[64] = (byte)n;
    }

    public int getCharSet() {
        return this._recdata[64];
    }

    public void setFontFlags(int n) {
        this._recdata[65] = (byte)n;
    }

    public int getFontFlags() {
        return this._recdata[65];
    }

    public void setFontType(int n) {
        this._recdata[66] = (byte)n;
    }

    public int getFontType() {
        return this._recdata[66];
    }

    public void setPitchAndFamily(int n) {
        this._recdata[67] = (byte)n;
    }

    public int getPitchAndFamily() {
        return this._recdata[67];
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        outputStream.write(this._header);
        outputStream.write(this._recdata);
    }
}

