/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.CString;
import ai2.org.apache.poi.hslf.record.ExMediaAtom;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordContainer;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public final class ExVideoContainer
extends RecordContainer {
    private byte[] _header = new byte[8];
    private ExMediaAtom mediaAtom;
    private CString pathAtom;

    protected ExVideoContainer(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._children = Record.findChildRecords(byArray, n + 8, n2 - 8);
        this.findInterestingChildren();
    }

    private void findInterestingChildren() {
        if (this._children[0] instanceof ExMediaAtom) {
            this.mediaAtom = (ExMediaAtom)this._children[0];
        } else {
            logger.log(7, new Object[]{"First child record wasn't a ExMediaAtom, was of type " + this._children[0].getRecordType()});
        }
        if (this._children[1] instanceof CString) {
            this.pathAtom = (CString)this._children[1];
        } else {
            logger.log(7, new Object[]{"Second child record wasn't a CString, was of type " + this._children[1].getRecordType()});
        }
    }

    public ExVideoContainer() {
        this._header[0] = 15;
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        this._children = new Record[2];
        this.mediaAtom = new ExMediaAtom();
        this._children[0] = this.mediaAtom;
        this.pathAtom = new CString();
        this._children[1] = this.pathAtom;
    }

    public long getRecordType() {
        return RecordTypes.ExVideoContainer.typeID;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        this.writeOut(this._header[0], this._header[1], this.getRecordType(), this._children, outputStream);
    }

    public ExMediaAtom getExMediaAtom() {
        return this.mediaAtom;
    }

    public CString getPathAtom() {
        return this.pathAtom;
    }
}

