/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.PersistRecord;
import ai2.org.apache.poi.hslf.record.PositionDependentRecord;
import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.util.BoundedInputStream;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExOleObjStg
extends RecordAtom
implements PositionDependentRecord,
PersistRecord {
    private int _persistId;
    private byte[] _header = new byte[8];
    private byte[] _data;
    protected int myLastOnDiskOffset;

    public ExOleObjStg() {
        this._data = new byte[0];
        LittleEndian.putShort(this._header, 0, (short)16);
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        LittleEndian.putInt(this._header, 4, this._data.length);
    }

    protected ExOleObjStg(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._data = new byte[n2 - 8];
        System.arraycopy(byArray, n + 8, this._data, 0, n2 - 8);
    }

    public boolean isCompressed() {
        return LittleEndian.getShort(this._header, 0) != 0;
    }

    public int getDataLength() {
        if (this.isCompressed()) {
            return LittleEndian.getInt(this._data, 0);
        }
        return this._data.length;
    }

    public InputStream getData() {
        if (this.isCompressed()) {
            int n = LittleEndian.getInt(this._data);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this._data, 4, this._data.length);
            return new BoundedInputStream(new InflaterInputStream(byteArrayInputStream), n);
        }
        return new ByteArrayInputStream(this._data, 0, this._data.length);
    }

    public byte[] getRawData() {
        return this._data;
    }

    public void setData(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray2 = new byte[4];
        LittleEndian.putInt(byArray2, 0, byArray.length);
        byteArrayOutputStream.write(byArray2);
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
        deflaterOutputStream.write(byArray, 0, byArray.length);
        deflaterOutputStream.finish();
        this._data = byteArrayOutputStream.toByteArray();
        LittleEndian.putInt(this._header, 4, this._data.length);
    }

    @Override
    public long getRecordType() {
        return RecordTypes.ExOleObjStg.typeID;
    }

    @Override
    public void writeOut(OutputStream outputStream) throws IOException {
        outputStream.write(this._header);
        outputStream.write(this._data);
    }

    @Override
    public int getPersistId() {
        return this._persistId;
    }

    @Override
    public void setPersistId(int n) {
        this._persistId = n;
    }

    @Override
    public int getLastOnDiskOffset() {
        return this.myLastOnDiskOffset;
    }

    @Override
    public void setLastOnDiskOffset(int n) {
        this.myLastOnDiskOffset = n;
    }

    @Override
    public void updateOtherRecordReferences(Hashtable<Integer, Integer> hashtable) {
    }
}

