/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public class ExOleObjAtom
extends RecordAtom {
    public static final int DRAW_ASPECT_VISIBLE = 1;
    public static final int DRAW_ASPECT_THUMBNAIL = 2;
    public static final int DRAW_ASPECT_ICON = 4;
    public static final int DRAW_ASPECT_DOCPRINT = 8;
    public static final int TYPE_EMBEDDED = 0;
    public static final int TYPE_LINKED = 1;
    public static final int TYPE_CONTROL = 2;
    public static final int SUBTYPE_DEFAULT = 0;
    public static final int SUBTYPE_CLIPART_GALLERY = 1;
    public static final int SUBTYPE_WORD_TABLE = 2;
    public static final int SUBTYPE_EXCEL = 3;
    public static final int SUBTYPE_GRAPH = 4;
    public static final int SUBTYPE_ORGANIZATION_CHART = 5;
    public static final int SUBTYPE_EQUATION = 6;
    public static final int SUBTYPE_WORDART = 7;
    public static final int SUBTYPE_SOUND = 8;
    public static final int SUBTYPE_IMAGE = 9;
    public static final int SUBTYPE_POWERPOINT_PRESENTATION = 10;
    public static final int SUBTYPE_POWERPOINT_SLIDE = 11;
    public static final int SUBTYPE_PROJECT = 12;
    public static final int SUBTYPE_NOTEIT = 13;
    public static final int SUBTYPE_EXCEL_CHART = 14;
    public static final int SUBTYPE_MEDIA_PLAYER = 15;
    private byte[] _header = new byte[8];
    private byte[] _data;

    public ExOleObjAtom() {
        this._data = new byte[24];
        LittleEndian.putShort(this._header, 0, (short)1);
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        LittleEndian.putInt(this._header, 4, this._data.length);
    }

    protected ExOleObjAtom(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._data = new byte[n2 - 8];
        System.arraycopy(byArray, n + 8, this._data, 0, n2 - 8);
        if (this._data.length < 24) {
            throw new IllegalArgumentException("The length of the data for a ExOleObjAtom must be at least 24 bytes, but was only " + this._data.length);
        }
    }

    public int getDrawAspect() {
        return LittleEndian.getInt(this._data, 0);
    }

    public void setDrawAspect(int n) {
        LittleEndian.putInt(this._data, 0, n);
    }

    public int getType() {
        return LittleEndian.getInt(this._data, 4);
    }

    public void setType(int n) {
        LittleEndian.putInt(this._data, 4, n);
    }

    public int getObjID() {
        return LittleEndian.getInt(this._data, 8);
    }

    public void setObjID(int n) {
        LittleEndian.putInt(this._data, 8, n);
    }

    public int getSubType() {
        return LittleEndian.getInt(this._data, 12);
    }

    public void setSubType(int n) {
        LittleEndian.putInt(this._data, 12, n);
    }

    public int getObjStgDataRef() {
        return LittleEndian.getInt(this._data, 16);
    }

    public void setObjStgDataRef(int n) {
        LittleEndian.putInt(this._data, 16, n);
    }

    public boolean getIsBlank() {
        return LittleEndian.getInt(this._data, 20) != 0;
    }

    public int getOptions() {
        return LittleEndian.getInt(this._data, 20);
    }

    public void setOptions(int n) {
        LittleEndian.putInt(this._data, 20, n);
    }

    public long getRecordType() {
        return RecordTypes.ExOleObjAtom.typeID;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        outputStream.write(this._header);
        outputStream.write(this._data);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ExOleObjAtom\n");
        stringBuffer.append("  drawAspect: " + this.getDrawAspect() + "\n");
        stringBuffer.append("  type: " + this.getType() + "\n");
        stringBuffer.append("  objID: " + this.getObjID() + "\n");
        stringBuffer.append("  subType: " + this.getSubType() + "\n");
        stringBuffer.append("  objStgDataRef: " + this.getObjStgDataRef() + "\n");
        stringBuffer.append("  options: " + this.getOptions() + "\n");
        return stringBuffer.toString();
    }
}

