/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.FontCollection;
import ai2.org.apache.poi.hslf.record.PositionDependentRecordContainer;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.TxMasterStyleAtom;
import java.io.IOException;
import java.io.OutputStream;

public final class Environment
extends PositionDependentRecordContainer {
    private byte[] _header = new byte[8];
    private static long _type = 1010L;
    private FontCollection fontCollection;
    private TxMasterStyleAtom txmaster;

    public FontCollection getFontCollection() {
        return this.fontCollection;
    }

    protected Environment(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._children = Record.findChildRecords(byArray, n + 8, n2 - 8);
        for (int i = 0; i < this._children.length; ++i) {
            if (this._children[i] instanceof FontCollection) {
                this.fontCollection = (FontCollection)this._children[i];
                continue;
            }
            if (!(this._children[i] instanceof TxMasterStyleAtom)) continue;
            this.txmaster = (TxMasterStyleAtom)this._children[i];
        }
        if (this.fontCollection == null) {
            throw new IllegalStateException("Environment didn't contain a FontCollection record!");
        }
    }

    public TxMasterStyleAtom getTxMasterStyleAtom() {
        return this.txmaster;
    }

    public long getRecordType() {
        return _type;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        this.writeOut(this._header[0], this._header[1], _type, this._children, outputStream);
    }
}

