/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.PositionDependentRecordAtom;
import ai2.org.apache.poi.poifs.crypt.CipherAlgorithm;
import ai2.org.apache.poi.poifs.crypt.EncryptionInfo;
import ai2.org.apache.poi.poifs.crypt.EncryptionMode;
import ai2.org.apache.poi.poifs.crypt.HashAlgorithm;
import ai2.org.apache.poi.poifs.crypt.cryptoapi.CryptoAPIEncryptionHeader;
import ai2.org.apache.poi.poifs.crypt.cryptoapi.CryptoAPIEncryptionVerifier;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.LittleEndianByteArrayOutputStream;
import ai2.org.apache.poi.util.LittleEndianInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DocumentEncryptionAtom
extends PositionDependentRecordAtom {
    private static long _type = 12052L;
    private byte[] _header = new byte[8];
    private EncryptionInfo ei;

    protected DocumentEncryptionAtom(byte[] byArray, int n, int n2) throws IOException {
        System.arraycopy(byArray, n, this._header, 0, 8);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n + 8, n2 - 8);
        LittleEndianInputStream littleEndianInputStream = new LittleEndianInputStream(byteArrayInputStream);
        this.ei = new EncryptionInfo(littleEndianInputStream, true);
    }

    public DocumentEncryptionAtom() {
        LittleEndian.putShort(this._header, 0, (short)15);
        LittleEndian.putShort(this._header, 2, (short)_type);
        this.ei = new EncryptionInfo(EncryptionMode.cryptoAPI);
    }

    public void initializeEncryptionInfo(int n) {
        this.ei = new EncryptionInfo(EncryptionMode.cryptoAPI, CipherAlgorithm.rc4, HashAlgorithm.sha1, n, -1, null);
    }

    public int getKeyLength() {
        return this.ei.getHeader().getKeySize();
    }

    public String getEncryptionProviderName() {
        return this.ei.getHeader().getCspName();
    }

    public EncryptionInfo getEncryptionInfo() {
        return this.ei;
    }

    @Override
    public long getRecordType() {
        return _type;
    }

    @Override
    public void writeOut(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[1024];
        LittleEndianByteArrayOutputStream littleEndianByteArrayOutputStream = new LittleEndianByteArrayOutputStream(byArray, 0);
        littleEndianByteArrayOutputStream.writeShort(this.ei.getVersionMajor());
        littleEndianByteArrayOutputStream.writeShort(this.ei.getVersionMinor());
        littleEndianByteArrayOutputStream.writeInt(this.ei.getEncryptionFlags());
        ((CryptoAPIEncryptionHeader)this.ei.getHeader()).write(littleEndianByteArrayOutputStream);
        ((CryptoAPIEncryptionVerifier)this.ei.getVerifier()).write(littleEndianByteArrayOutputStream);
        LittleEndian.putInt(this._header, 4, littleEndianByteArrayOutputStream.getWriteIndex());
        outputStream.write(this._header);
        outputStream.write(byArray, 0, littleEndianByteArrayOutputStream.getWriteIndex());
    }

    @Override
    public void updateOtherRecordReferences(Hashtable<Integer, Integer> hashtable) {
    }
}

