/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.exceptions.CorruptPowerPointFileException;
import ai2.org.apache.poi.hslf.exceptions.OldPowerPointFormatException;
import ai2.org.apache.poi.poifs.filesystem.DirectoryNode;
import ai2.org.apache.poi.poifs.filesystem.DocumentEntry;
import ai2.org.apache.poi.poifs.filesystem.DocumentInputStream;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.poifs.filesystem.POIFSFileSystem;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.POILogFactory;
import ai2.org.apache.poi.util.POILogger;
import ai2.org.apache.poi.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CurrentUserAtom {
    private static POILogger logger = POILogFactory.getLogger(CurrentUserAtom.class);
    public static final byte[] atomHeader = new byte[]{0, 0, -10, 15};
    public static final byte[] headerToken = new byte[]{95, -64, -111, -29};
    public static final byte[] encHeaderToken = new byte[]{-33, -60, -47, -13};
    public static final byte[] ppt97FileVer = new byte[]{8, 0, -13, 3, 3, 0};
    private int docFinalVersion;
    private byte docMajorNo;
    private byte docMinorNo;
    private long currentEditOffset;
    private String lastEditUser;
    private long releaseVersion;
    private byte[] _contents;
    private boolean isEncrypted;

    public int getDocFinalVersion() {
        return this.docFinalVersion;
    }

    public byte getDocMajorNo() {
        return this.docMajorNo;
    }

    public byte getDocMinorNo() {
        return this.docMinorNo;
    }

    public long getReleaseVersion() {
        return this.releaseVersion;
    }

    public void setReleaseVersion(long l) {
        this.releaseVersion = l;
    }

    public long getCurrentEditOffset() {
        return this.currentEditOffset;
    }

    public void setCurrentEditOffset(long l) {
        this.currentEditOffset = l;
    }

    public String getLastEditUsername() {
        return this.lastEditUser;
    }

    public void setLastEditUsername(String string) {
        this.lastEditUser = string;
    }

    public boolean isEncrypted() {
        return this.isEncrypted;
    }

    public void setEncrypted(boolean bl) {
        this.isEncrypted = bl;
    }

    public CurrentUserAtom() {
        this._contents = new byte[0];
        this.docFinalVersion = 1012;
        this.docMajorNo = (byte)3;
        this.docMinorNo = 0;
        this.releaseVersion = 8L;
        this.currentEditOffset = 0L;
        this.lastEditUser = "Apache POI";
        this.isEncrypted = false;
    }

    public CurrentUserAtom(POIFSFileSystem pOIFSFileSystem) throws IOException {
        this(pOIFSFileSystem.getRoot());
    }

    public CurrentUserAtom(DirectoryNode directoryNode) throws IOException {
        DocumentEntry documentEntry = (DocumentEntry)directoryNode.getEntry("Current User");
        if (documentEntry.getSize() > 131072) {
            throw new CorruptPowerPointFileException("The Current User stream is implausably long. It's normally 28-200 bytes long, but was " + documentEntry.getSize() + " bytes");
        }
        this._contents = new byte[documentEntry.getSize()];
        DocumentInputStream documentInputStream = directoryNode.createDocumentInputStream("Current User");
        ((InputStream)documentInputStream).read(this._contents);
        if (this._contents.length < 28) {
            int n;
            if (this._contents.length >= 4 && (n = LittleEndian.getInt(this._contents)) + 4 == this._contents.length) {
                throw new OldPowerPointFormatException("Based on the Current User stream, you seem to have supplied a PowerPoint95 file, which isn't supported");
            }
            throw new CorruptPowerPointFileException("The Current User stream must be at least 28 bytes long, but was only " + this._contents.length);
        }
        this.init();
    }

    public CurrentUserAtom(byte[] byArray) {
        this._contents = byArray;
        this.init();
    }

    private void init() {
        this.isEncrypted = LittleEndian.getInt(encHeaderToken) == LittleEndian.getInt(this._contents, 12);
        this.currentEditOffset = LittleEndian.getUInt(this._contents, 16);
        this.docFinalVersion = LittleEndian.getUShort(this._contents, 22);
        this.docMajorNo = this._contents[24];
        this.docMinorNo = this._contents[25];
        long l = LittleEndian.getUShort(this._contents, 20);
        if (l > 512L) {
            logger.log(5, new Object[]{"Warning - invalid username length " + l + " found, treating as if there was no username set"});
            l = 0L;
        }
        this.releaseVersion = this._contents.length >= 28 + (int)l + 4 ? LittleEndian.getUInt(this._contents, 28 + (int)l) : 0L;
        int n = 28 + (int)l + 4;
        int n2 = 2 * (int)l;
        if (this._contents.length >= n + n2) {
            byte[] byArray = new byte[n2];
            System.arraycopy(this._contents, n, byArray, 0, n2);
            this.lastEditUser = StringUtil.getFromUnicodeLE(byArray);
        } else {
            byte[] byArray = new byte[(int)l];
            System.arraycopy(this._contents, 28, byArray, 0, (int)l);
            this.lastEditUser = StringUtil.getFromCompressedUnicode(byArray, 0, (int)l);
        }
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        int n = 32 + 3 * this.lastEditUser.length();
        this._contents = new byte[n];
        System.arraycopy(atomHeader, 0, this._contents, 0, 4);
        int n2 = 24 + this.lastEditUser.length();
        LittleEndian.putInt(this._contents, 4, n2);
        LittleEndian.putInt(this._contents, 8, 20);
        System.arraycopy(this.isEncrypted ? encHeaderToken : headerToken, 0, this._contents, 12, 4);
        LittleEndian.putInt(this._contents, 16, (int)this.currentEditOffset);
        byte[] byArray = new byte[this.lastEditUser.length()];
        StringUtil.putCompressedUnicode(this.lastEditUser, byArray, 0);
        LittleEndian.putShort(this._contents, 20, (short)byArray.length);
        LittleEndian.putShort(this._contents, 22, (short)this.docFinalVersion);
        this._contents[24] = this.docMajorNo;
        this._contents[25] = this.docMinorNo;
        this._contents[26] = 0;
        this._contents[27] = 0;
        System.arraycopy(byArray, 0, this._contents, 28, byArray.length);
        LittleEndian.putInt(this._contents, 28 + byArray.length, (int)this.releaseVersion);
        byte[] byArray2 = new byte[this.lastEditUser.length() * 2];
        StringUtil.putUnicodeLE(this.lastEditUser, byArray2, 0);
        System.arraycopy(byArray2, 0, this._contents, 28 + byArray.length + 4, byArray2.length);
        outputStream.write(this._contents);
    }

    public void writeToFS(NPOIFSFileSystem nPOIFSFileSystem) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeOut(byteArrayOutputStream);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        nPOIFSFileSystem.createDocument(byteArrayInputStream, "Current User");
    }
}

