/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.hslf.util.SystemTimeUtils;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

public final class Comment2000Atom
extends RecordAtom {
    private byte[] _header = new byte[8];
    private byte[] _data;

    protected Comment2000Atom() {
        this._data = new byte[28];
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        LittleEndian.putInt(this._header, 4, this._data.length);
    }

    protected Comment2000Atom(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._data = new byte[n2 - 8];
        System.arraycopy(byArray, n + 8, this._data, 0, n2 - 8);
    }

    public int getNumber() {
        return LittleEndian.getInt(this._data, 0);
    }

    public void setNumber(int n) {
        LittleEndian.putInt(this._data, 0, n);
    }

    public Date getDate() {
        return SystemTimeUtils.getDate(this._data, 4);
    }

    public void setDate(Date date) {
        SystemTimeUtils.storeDate(date, this._data, 4);
    }

    public int getXOffset() {
        return LittleEndian.getInt(this._data, 20);
    }

    public void setXOffset(int n) {
        LittleEndian.putInt(this._data, 20, n);
    }

    public int getYOffset() {
        return LittleEndian.getInt(this._data, 24);
    }

    public void setYOffset(int n) {
        LittleEndian.putInt(this._data, 24, n);
    }

    public long getRecordType() {
        return RecordTypes.Comment2000Atom.typeID;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        outputStream.write(this._header);
        outputStream.write(this._data);
    }
}

