/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.CString;
import ai2.org.apache.poi.hslf.record.Comment2000Atom;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordContainer;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public final class Comment2000
extends RecordContainer {
    private byte[] _header = new byte[8];
    private static long _type = 12000L;
    private CString authorRecord;
    private CString authorInitialsRecord;
    private CString commentRecord;
    private Comment2000Atom commentAtom;

    public Comment2000Atom getComment2000Atom() {
        return this.commentAtom;
    }

    public String getAuthor() {
        return this.authorRecord == null ? null : this.authorRecord.getText();
    }

    public void setAuthor(String string) {
        this.authorRecord.setText(string);
    }

    public String getAuthorInitials() {
        return this.authorInitialsRecord == null ? null : this.authorInitialsRecord.getText();
    }

    public void setAuthorInitials(String string) {
        this.authorInitialsRecord.setText(string);
    }

    public String getText() {
        return this.commentRecord == null ? null : this.commentRecord.getText();
    }

    public void setText(String string) {
        this.commentRecord.setText(string);
    }

    protected Comment2000(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._children = Record.findChildRecords(byArray, n + 8, n2 - 8);
        this.findInterestingChildren();
    }

    private void findInterestingChildren() {
        for (Record record : this._children) {
            if (record instanceof CString) {
                CString cString = (CString)record;
                int n = cString.getOptions() >> 4;
                switch (n) {
                    case 0: {
                        this.authorRecord = cString;
                        break;
                    }
                    case 1: {
                        this.commentRecord = cString;
                        break;
                    }
                    case 2: {
                        this.authorInitialsRecord = cString;
                    }
                }
                continue;
            }
            if (record instanceof Comment2000Atom) {
                this.commentAtom = (Comment2000Atom)record;
                continue;
            }
            logger.log(5, new Object[]{"Unexpected record with type=" + record.getRecordType() + " in Comment2000: " + record.getClass().getName()});
        }
    }

    public Comment2000() {
        this._children = new Record[4];
        this._header[0] = 15;
        LittleEndian.putShort(this._header, 2, (short)_type);
        CString cString = new CString();
        CString cString2 = new CString();
        CString cString3 = new CString();
        cString.setOptions(0);
        cString2.setOptions(16);
        cString3.setOptions(32);
        this._children[0] = cString;
        this._children[1] = cString2;
        this._children[2] = cString3;
        this._children[3] = new Comment2000Atom();
        this.findInterestingChildren();
    }

    public long getRecordType() {
        return _type;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        this.writeOut(this._header[0], this._header[1], _type, this._children, outputStream);
    }
}

