/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public final class AnimationInfoAtom
extends RecordAtom {
    public static final int Reverse = 1;
    public static final int Automatic = 4;
    public static final int Sound = 16;
    public static final int StopSound = 64;
    public static final int Play = 256;
    public static final int Synchronous = 1024;
    public static final int Hide = 4096;
    public static final int AnimateBg = 16384;
    private byte[] _header;
    private byte[] _recdata;

    protected AnimationInfoAtom() {
        this._recdata = new byte[28];
        this._header = new byte[8];
        LittleEndian.putShort(this._header, 0, (short)1);
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        LittleEndian.putInt(this._header, 4, this._recdata.length);
    }

    protected AnimationInfoAtom(byte[] byArray, int n, int n2) {
        this._header = new byte[8];
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._recdata = new byte[n2 - 8];
        System.arraycopy(byArray, n + 8, this._recdata, 0, n2 - 8);
    }

    public long getRecordType() {
        return RecordTypes.AnimationInfoAtom.typeID;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        outputStream.write(this._header);
        outputStream.write(this._recdata);
    }

    public int getDimColor() {
        return LittleEndian.getInt(this._recdata, 0);
    }

    public void setDimColor(int n) {
        LittleEndian.putInt(this._recdata, 0, n);
    }

    public int getMask() {
        return LittleEndian.getInt(this._recdata, 4);
    }

    public void setMask(int n) {
        LittleEndian.putInt(this._recdata, 4, n);
    }

    public boolean getFlag(int n) {
        return (this.getMask() & n) != 0;
    }

    public void setFlag(int n, boolean bl) {
        int n2 = this.getMask();
        n2 = bl ? (n2 |= n) : (n2 &= ~n);
        this.setMask(n2);
    }

    public int getSoundIdRef() {
        return LittleEndian.getInt(this._recdata, 8);
    }

    public void setSoundIdRef(int n) {
        LittleEndian.putInt(this._recdata, 8, n);
    }

    public int getDelayTime() {
        return LittleEndian.getInt(this._recdata, 12);
    }

    public void setDelayTime(int n) {
        LittleEndian.putInt(this._recdata, 12, n);
    }

    public int getOrderID() {
        return LittleEndian.getInt(this._recdata, 16);
    }

    public void setOrderID(int n) {
        LittleEndian.putInt(this._recdata, 16, n);
    }

    public int getSlideCount() {
        return LittleEndian.getInt(this._recdata, 18);
    }

    public void setSlideCount(int n) {
        LittleEndian.putInt(this._recdata, 18, n);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("AnimationInfoAtom\n");
        stringBuffer.append("\tDimColor: " + this.getDimColor() + "\n");
        int n = this.getMask();
        stringBuffer.append("\tMask: " + n + ", 0x" + Integer.toHexString(n) + "\n");
        stringBuffer.append("\t  Reverse: " + this.getFlag(1) + "\n");
        stringBuffer.append("\t  Automatic: " + this.getFlag(4) + "\n");
        stringBuffer.append("\t  Sound: " + this.getFlag(16) + "\n");
        stringBuffer.append("\t  StopSound: " + this.getFlag(64) + "\n");
        stringBuffer.append("\t  Play: " + this.getFlag(256) + "\n");
        stringBuffer.append("\t  Synchronous: " + this.getFlag(1024) + "\n");
        stringBuffer.append("\t  Hide: " + this.getFlag(4096) + "\n");
        stringBuffer.append("\t  AnimateBg: " + this.getFlag(16384) + "\n");
        stringBuffer.append("\tSoundIdRef: " + this.getSoundIdRef() + "\n");
        stringBuffer.append("\tDelayTime: " + this.getDelayTime() + "\n");
        stringBuffer.append("\tOrderID: " + this.getOrderID() + "\n");
        stringBuffer.append("\tSlideCount: " + this.getSlideCount() + "\n");
        return stringBuffer.toString();
    }
}

