/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.record;

import ai2.org.apache.poi.hslf.record.AnimationInfoAtom;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordContainer;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;

public final class AnimationInfo
extends RecordContainer {
    private byte[] _header = new byte[8];
    private AnimationInfoAtom animationAtom;

    protected AnimationInfo(byte[] byArray, int n, int n2) {
        System.arraycopy(byArray, n, this._header, 0, 8);
        this._children = Record.findChildRecords(byArray, n + 8, n2 - 8);
        this.findInterestingChildren();
    }

    private void findInterestingChildren() {
        if (this._children[0] instanceof AnimationInfoAtom) {
            this.animationAtom = (AnimationInfoAtom)this._children[0];
        } else {
            logger.log(7, new Object[]{"First child record wasn't a AnimationInfoAtom, was of type " + this._children[0].getRecordType()});
        }
    }

    public AnimationInfo() {
        this._header[0] = 15;
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        this._children = new Record[1];
        this.animationAtom = new AnimationInfoAtom();
        this._children[0] = this.animationAtom;
    }

    public long getRecordType() {
        return RecordTypes.AnimationInfo.typeID;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        this.writeOut(this._header[0], this._header[1], this.getRecordType(), this._children, outputStream);
    }

    public AnimationInfoAtom getAnimationInfoAtom() {
        return this.animationAtom;
    }
}

