/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.model.textproperties;

import ai2.org.apache.poi.hslf.model.textproperties.BitMaskTextProp;
import ai2.org.apache.poi.hslf.model.textproperties.CharFlagsTextProp;
import ai2.org.apache.poi.hslf.model.textproperties.FontAlignmentProp;
import ai2.org.apache.poi.hslf.model.textproperties.ParagraphFlagsTextProp;
import ai2.org.apache.poi.hslf.model.textproperties.TabStopPropCollection;
import ai2.org.apache.poi.hslf.model.textproperties.TextAlignmentProp;
import ai2.org.apache.poi.hslf.model.textproperties.TextProp;
import ai2.org.apache.poi.hslf.model.textproperties.WrapFlagsTextProp;
import ai2.org.apache.poi.hslf.record.StyleTextPropAtom;
import ai2.org.apache.poi.util.HexDump;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextPropCollection {
    public static final TextProp[] paragraphTextPropTypes = new TextProp[]{new ParagraphFlagsTextProp(), new TextProp(2, 128, "bullet.char"), new TextProp(2, 16, "bullet.font"), new TextProp(2, 64, "bullet.size"), new TextProp(4, 32, "bullet.color"), new TextAlignmentProp(), new TextProp(2, 4096, "linespacing"), new TextProp(2, 8192, "spacebefore"), new TextProp(2, 16384, "spaceafter"), new TextProp(2, 256, "text.offset"), new TextProp(2, 1024, "bullet.offset"), new TextProp(2, 32768, "defaultTabSize"), new TabStopPropCollection(), new FontAlignmentProp(), new WrapFlagsTextProp(), new TextProp(2, 0x200000, "textDirection"), new TextProp(0, 0x800000, "bullet.blip"), new TextProp(0, 0x1000000, "bullet.scheme"), new TextProp(0, 0x2000000, "hasBulletScheme")};
    public static final TextProp[] characterTextPropTypes = new TextProp[]{new TextProp(0, 0x100000, "pp10ext"), new TextProp(0, 0x1000000, "newAsian.font.index"), new TextProp(0, 0x2000000, "cs.font.index"), new TextProp(0, 0x4000000, "pp11ext"), new CharFlagsTextProp(), new TextProp(2, 65536, "font.index"), new TextProp(2, 0x200000, "asian.font.index"), new TextProp(2, 0x400000, "ansi.font.index"), new TextProp(2, 0x800000, "symbol.font.index"), new TextProp(2, 131072, "font.size"), new TextProp(4, 262144, "font.color"), new TextProp(2, 524288, "superscript")};
    private int charactersCovered;
    private short indentLevel = 0;
    private final List<TextProp> textPropList = new ArrayList<TextProp>();
    private int maskSpecial = 0;
    private final TextPropType textPropType;

    public TextPropCollection(int n, TextPropType textPropType) {
        this.charactersCovered = n;
        this.textPropType = textPropType;
    }

    public int getSpecialMask() {
        return this.maskSpecial;
    }

    public int getCharactersCovered() {
        return this.charactersCovered;
    }

    public List<TextProp> getTextPropList() {
        return this.textPropList;
    }

    public TextProp findByName(String string) {
        for (TextProp textProp : this.textPropList) {
            if (!textProp.getName().equals(string)) continue;
            return textProp;
        }
        return null;
    }

    public TextProp removeByName(String string) {
        Iterator<TextProp> iterator = this.textPropList.iterator();
        TextProp textProp = null;
        while (iterator.hasNext()) {
            textProp = iterator.next();
            if (!textProp.getName().equals(string)) continue;
            iterator.remove();
            break;
        }
        return textProp;
    }

    public TextProp addWithName(String string) {
        TextProp textProp = this.findByName(string);
        if (textProp != null) {
            return textProp;
        }
        TextProp textProp2 = null;
        for (TextProp textProp3 : this.getPotentialProperties()) {
            if (!textProp3.getName().equals(string)) continue;
            textProp2 = textProp3;
            break;
        }
        if (textProp2 == null) {
            throw new IllegalArgumentException("No TextProp with name " + string + " is defined to add from. " + "Character and paragraphs have their own properties/names.");
        }
        TextProp textProp4 = textProp2.clone();
        this.addProp(textProp4);
        return textProp4;
    }

    public TextPropType getTextPropType() {
        return this.textPropType;
    }

    private TextProp[] getPotentialProperties() {
        return this.textPropType == TextPropType.paragraph ? paragraphTextPropTypes : characterTextPropTypes;
    }

    public void addProp(TextProp textProp) {
        assert (textProp != null);
        int n = 0;
        boolean bl = false;
        for (TextProp textProp2 : this.getPotentialProperties()) {
            String string = textProp2.getName();
            if (n == this.textPropList.size() || string.equals(textProp.getName())) {
                if (this.textPropList.size() > n && string.equals(this.textPropList.get(n).getName())) {
                    this.textPropList.set(n, textProp);
                } else {
                    this.textPropList.add(n, textProp);
                }
                bl = true;
                break;
            }
            if (!string.equals(this.textPropList.get(n).getName())) continue;
            ++n;
        }
        if (!bl) {
            String string = "TextProp with name " + textProp.getName() + " doesn't belong to this collection.";
            throw new IllegalArgumentException(string);
        }
    }

    public int buildTextPropList(int n, byte[] byArray, int n2) {
        int n3 = 0;
        for (TextProp textProp : this.getPotentialProperties()) {
            if ((n & textProp.getMask()) == 0) continue;
            if (n2 + n3 >= byArray.length) {
                this.maskSpecial |= textProp.getMask();
                return n3;
            }
            TextProp textProp2 = textProp.clone();
            int n4 = 0;
            if (textProp2 instanceof TabStopPropCollection) {
                ((TabStopPropCollection)textProp2).parseProperty(byArray, n2 + n3);
            } else if (textProp2.getSize() == 2) {
                n4 = LittleEndian.getShort(byArray, n2 + n3);
            } else if (textProp2.getSize() == 4) {
                n4 = LittleEndian.getInt(byArray, n2 + n3);
            } else if (textProp2.getSize() == 0) {
                this.maskSpecial |= textProp.getMask();
                continue;
            }
            if (textProp2 instanceof BitMaskTextProp) {
                ((BitMaskTextProp)textProp2).setValueWithMask(n4, n);
            } else {
                textProp2.setValue(n4);
            }
            n3 += textProp2.getSize();
            this.addProp(textProp2);
        }
        return n3;
    }

    public void copy(TextPropCollection textPropCollection) {
        if (this == textPropCollection) {
            return;
        }
        this.charactersCovered = textPropCollection.charactersCovered;
        this.indentLevel = textPropCollection.indentLevel;
        this.maskSpecial = textPropCollection.maskSpecial;
        this.textPropList.clear();
        for (TextProp textProp : textPropCollection.textPropList) {
            TextProp textProp2 = textProp instanceof BitMaskTextProp ? ((BitMaskTextProp)textProp).cloneAll() : textProp.clone();
            this.addProp(textProp2);
        }
    }

    public void updateTextSize(int n) {
        this.charactersCovered = n;
    }

    public void writeOut(OutputStream outputStream) throws IOException {
        StyleTextPropAtom.writeLittleEndian(this.charactersCovered, outputStream);
        if (this.textPropType == TextPropType.paragraph && this.indentLevel > -1) {
            StyleTextPropAtom.writeLittleEndian(this.indentLevel, outputStream);
        }
        int n = this.maskSpecial;
        for (TextProp textProp : this.textPropList) {
            n |= textProp.getWriteMask();
        }
        StyleTextPropAtom.writeLittleEndian(n, outputStream);
        for (TextProp textProp : this.getPotentialProperties()) {
            for (TextProp textProp2 : this.textPropList) {
                if (!textProp2.getName().equals(textProp.getName())) continue;
                int n2 = textProp2.getValue();
                if (textProp2 instanceof BitMaskTextProp && textProp2.getWriteMask() == 0) continue;
                if (textProp2.getSize() == 2) {
                    StyleTextPropAtom.writeLittleEndian((short)n2, outputStream);
                    continue;
                }
                if (textProp2.getSize() != 4) continue;
                StyleTextPropAtom.writeLittleEndian(n2, outputStream);
            }
        }
    }

    public short getIndentLevel() {
        return this.indentLevel;
    }

    public void setIndentLevel(short s) {
        if (this.textPropType == TextPropType.character) {
            throw new RuntimeException("trying to set an indent on a character collection.");
        }
        this.indentLevel = s;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.charactersCovered;
        n = 31 * n + this.maskSpecial;
        n = 31 * n + this.indentLevel;
        n = 31 * n + (this.textPropList == null ? 0 : this.textPropList.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        TextPropCollection textPropCollection = (TextPropCollection)object;
        if (textPropCollection.maskSpecial != this.maskSpecial || textPropCollection.indentLevel != this.indentLevel) {
            return false;
        }
        if (this.textPropList == null) {
            return textPropCollection.textPropList == null;
        }
        HashMap<String, TextProp> hashMap = new HashMap<String, TextProp>();
        for (TextProp textProp : textPropCollection.textPropList) {
            hashMap.put(textProp.getName(), textProp);
        }
        for (TextProp textProp : this.textPropList) {
            TextProp textProp2;
            if (textProp.equals(textProp2 = (TextProp)hashMap.get(textProp.getName()))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("  chars covered: " + this.getCharactersCovered());
        stringBuilder.append("  special mask flags: 0x" + HexDump.toHex(this.getSpecialMask()) + "\n");
        if (this.textPropType == TextPropType.paragraph) {
            stringBuilder.append("  indent level: " + this.getIndentLevel() + "\n");
        }
        for (TextProp object : this.getTextPropList()) {
            stringBuilder.append("    " + object.getName() + " = " + object.getValue());
            stringBuilder.append(" (0x" + HexDump.toHex(object.getValue()) + ")\n");
            if (!(object instanceof BitMaskTextProp)) continue;
            BitMaskTextProp bitMaskTextProp = (BitMaskTextProp)object;
            int n = 0;
            for (String string : bitMaskTextProp.getSubPropNames()) {
                if (bitMaskTextProp.getSubPropMatches()[n]) {
                    stringBuilder.append("          " + string + " = " + bitMaskTextProp.getSubValue(n) + "\n");
                }
                ++n;
            }
        }
        stringBuilder.append("  bytes that would be written: \n");
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            this.writeOut(byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            stringBuilder.append(HexDump.dump(byArray, 0L, 0));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TextPropType {
        paragraph,
        character;

    }
}

