/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.model.textproperties;

import ai2.org.apache.poi.hslf.model.textproperties.TextProp;
import ai2.org.apache.poi.util.LittleEndian;
import java.util.ArrayList;
import java.util.List;

public class TabStopPropCollection
extends TextProp {
    private List<TabStop> tabStops = new ArrayList<TabStop>();

    public TabStopPropCollection() {
        super(0, 0x100000, "tabStops");
    }

    public void parseProperty(byte[] byArray, int n) {
        int n2 = LittleEndian.getUShort(byArray, n);
        n += 2;
        for (int i = 0; i < n2; ++i) {
            short s = LittleEndian.getShort(byArray, n);
            short s2 = LittleEndian.getShort(byArray, n += 2);
            TabStopType tabStopType = TabStopType.fromRecordVal(s2);
            n += 2;
            this.tabStops.add(new TabStop(s, tabStopType));
        }
    }

    public int getSize() {
        return 2 + this.tabStops.size() * 4;
    }

    public static class TabStop {
        private int position;
        private TabStopType type;

        public TabStop(int n, TabStopType tabStopType) {
            this.position = n;
            this.type = tabStopType;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int n) {
            this.position = n;
        }

        public TabStopType getType() {
            return this.type;
        }

        public void setType(TabStopType tabStopType) {
            this.type = tabStopType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TabStopType {
        LEFT(0),
        CENTER(1),
        RIGHT(2),
        DECIMAL(3);

        private final int val;

        private TabStopType(int n2) {
            this.val = n2;
        }

        public static TabStopType fromRecordVal(int n) {
            for (TabStopType tabStopType : TabStopType.values()) {
                if (tabStopType.val != n) continue;
                return tabStopType;
            }
            return LEFT;
        }
    }
}

