/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.model;

import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherSpRecord;
import ai2.org.apache.poi.ddf.UnknownEscherRecord;
import ai2.org.apache.poi.hslf.record.ExEmbed;
import ai2.org.apache.poi.hslf.record.ExObjList;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.hslf.usermodel.HSLFObjectData;
import ai2.org.apache.poi.hslf.usermodel.HSLFPictureData;
import ai2.org.apache.poi.hslf.usermodel.HSLFPictureShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlideShow;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import ai2.org.apache.poi.sl.usermodel.ShapeContainer;
import ai2.org.apache.poi.util.LittleEndian;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OLEShape
extends HSLFPictureShape {
    protected ExEmbed _exEmbed;

    public OLEShape(HSLFPictureData hSLFPictureData) {
        super(hSLFPictureData);
    }

    public OLEShape(HSLFPictureData hSLFPictureData, ShapeContainer<HSLFShape, HSLFTextParagraph> shapeContainer) {
        super(hSLFPictureData, shapeContainer);
    }

    public OLEShape(EscherContainerRecord escherContainerRecord, ShapeContainer<HSLFShape, HSLFTextParagraph> shapeContainer) {
        super(escherContainerRecord, shapeContainer);
    }

    public int getObjectID() {
        return this.getEscherProperty((short)267);
    }

    public void setObjectID(int n) {
        this.setEscherProperty((short)267, n);
        EscherContainerRecord escherContainerRecord = this.getSpContainer();
        EscherSpRecord escherSpRecord = (EscherSpRecord)escherContainerRecord.getChildById((short)-4086);
        escherSpRecord.setFlags(escherSpRecord.getFlags() | 0x10);
        EscherContainerRecord escherContainerRecord2 = (EscherContainerRecord)escherContainerRecord.getChildById((short)-4079);
        if (escherContainerRecord2 == null) {
            escherContainerRecord2 = new EscherContainerRecord();
            escherContainerRecord.addChildRecord(escherContainerRecord2);
        }
        escherContainerRecord2.setRecordId((short)-4079);
        escherContainerRecord2.setVersion((short)15);
        UnknownEscherRecord unknownEscherRecord = (UnknownEscherRecord)escherContainerRecord2.getChildById((short)RecordTypes.ExObjRefAtom.typeID);
        if (unknownEscherRecord == null) {
            unknownEscherRecord = new UnknownEscherRecord();
            escherContainerRecord2.addChildRecord(unknownEscherRecord);
        }
        byte[] byArray = new byte[12];
        LittleEndian.putShort(byArray, 0, (short)0);
        LittleEndian.putShort(byArray, 2, (short)RecordTypes.ExObjRefAtom.typeID);
        LittleEndian.putInt(byArray, 4, 4);
        LittleEndian.putInt(byArray, 8, n);
        unknownEscherRecord.fillFields(byArray, 0, null);
    }

    public HSLFObjectData getObjectData() {
        HSLFSlideShow hSLFSlideShow = this.getSheet().getSlideShow();
        HSLFObjectData[] hSLFObjectDataArray = hSLFSlideShow.getEmbeddedObjects();
        ExEmbed exEmbed = this.getExEmbed();
        HSLFObjectData hSLFObjectData = null;
        if (exEmbed != null) {
            int n = exEmbed.getExOleObjAtom().getObjStgDataRef();
            for (int i = 0; i < hSLFObjectDataArray.length; ++i) {
                if (hSLFObjectDataArray[i].getExOleObjStg().getPersistId() != n) continue;
                hSLFObjectData = hSLFObjectDataArray[i];
            }
        }
        if (hSLFObjectData == null) {
            this.logger.log(5, new Object[]{"OLE data not found"});
        }
        return hSLFObjectData;
    }

    public ExEmbed getExEmbed() {
        if (this._exEmbed == null) {
            HSLFSlideShow hSLFSlideShow = this.getSheet().getSlideShow();
            ExObjList exObjList = hSLFSlideShow.getDocumentRecord().getExObjList();
            if (exObjList == null) {
                this.logger.log(5, new Object[]{"ExObjList not found"});
                return null;
            }
            int n = this.getObjectID();
            Record[] recordArray = exObjList.getChildRecords();
            for (int i = 0; i < recordArray.length; ++i) {
                ExEmbed exEmbed;
                if (!(recordArray[i] instanceof ExEmbed) || (exEmbed = (ExEmbed)recordArray[i]).getExOleObjAtom().getObjID() != n) continue;
                this._exEmbed = exEmbed;
            }
        }
        return this._exEmbed;
    }

    public String getInstanceName() {
        return this.getExEmbed().getMenuName();
    }

    public String getFullName() {
        return this.getExEmbed().getClipboardName();
    }

    public String getProgID() {
        return this.getExEmbed().getProgId();
    }
}

