/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.model;

import ai2.org.apache.poi.ddf.EscherClientDataRecord;
import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.hslf.exceptions.HSLFException;
import ai2.org.apache.poi.hslf.record.AnimationInfo;
import ai2.org.apache.poi.hslf.record.AnimationInfoAtom;
import ai2.org.apache.poi.hslf.record.ExMCIMovie;
import ai2.org.apache.poi.hslf.record.ExObjList;
import ai2.org.apache.poi.hslf.record.ExVideoContainer;
import ai2.org.apache.poi.hslf.record.InteractiveInfo;
import ai2.org.apache.poi.hslf.record.InteractiveInfoAtom;
import ai2.org.apache.poi.hslf.record.OEShapeAtom;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.hslf.usermodel.HSLFPictureData;
import ai2.org.apache.poi.hslf.usermodel.HSLFPictureShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlideShow;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import ai2.org.apache.poi.sl.usermodel.ShapeContainer;
import java.io.ByteArrayOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MovieShape
extends HSLFPictureShape {
    public static final int DEFAULT_MOVIE_THUMBNAIL = -1;
    public static final int MOVIE_MPEG = 1;
    public static final int MOVIE_AVI = 2;

    public MovieShape(int n, HSLFPictureData hSLFPictureData) {
        super(hSLFPictureData, null);
        this.setMovieIndex(n);
        this.setAutoPlay(true);
    }

    public MovieShape(int n, HSLFPictureData hSLFPictureData, ShapeContainer<HSLFShape, HSLFTextParagraph> shapeContainer) {
        super(hSLFPictureData, shapeContainer);
        this.setMovieIndex(n);
    }

    public MovieShape(EscherContainerRecord escherContainerRecord, ShapeContainer<HSLFShape, HSLFTextParagraph> shapeContainer) {
        super(escherContainerRecord, shapeContainer);
    }

    @Override
    protected EscherContainerRecord createSpContainer(int n, boolean bl) {
        this._escherContainer = super.createSpContainer(n, bl);
        this.setEscherProperty((short)127, 0x1000100);
        this.setEscherProperty((short)447, 65537);
        EscherClientDataRecord escherClientDataRecord = new EscherClientDataRecord();
        escherClientDataRecord.setOptions((short)15);
        this._escherContainer.addChildRecord(escherClientDataRecord);
        OEShapeAtom oEShapeAtom = new OEShapeAtom();
        InteractiveInfo interactiveInfo = new InteractiveInfo();
        InteractiveInfoAtom interactiveInfoAtom = interactiveInfo.getInteractiveInfoAtom();
        interactiveInfoAtom.setAction((byte)6);
        interactiveInfoAtom.setHyperlinkType((byte)-1);
        AnimationInfo animationInfo = new AnimationInfo();
        AnimationInfoAtom animationInfoAtom = animationInfo.getAnimationInfoAtom();
        animationInfoAtom.setFlag(4, true);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            oEShapeAtom.writeOut(byteArrayOutputStream);
            animationInfo.writeOut(byteArrayOutputStream);
            interactiveInfo.writeOut(byteArrayOutputStream);
        }
        catch (Exception exception) {
            throw new HSLFException(exception);
        }
        escherClientDataRecord.setRemainingData(byteArrayOutputStream.toByteArray());
        return this._escherContainer;
    }

    public void setMovieIndex(int n) {
        OEShapeAtom oEShapeAtom = (OEShapeAtom)this.getClientDataRecord(RecordTypes.OEShapeAtom.typeID);
        oEShapeAtom.setOptions(n);
        AnimationInfo animationInfo = (AnimationInfo)this.getClientDataRecord(RecordTypes.AnimationInfo.typeID);
        if (animationInfo != null) {
            AnimationInfoAtom animationInfoAtom = animationInfo.getAnimationInfoAtom();
            animationInfoAtom.setDimColor(0x7000000);
            animationInfoAtom.setFlag(4, true);
            animationInfoAtom.setFlag(256, true);
            animationInfoAtom.setFlag(1024, true);
            animationInfoAtom.setOrderID(n + 1);
        }
    }

    public void setAutoPlay(boolean bl) {
        AnimationInfo animationInfo = (AnimationInfo)this.getClientDataRecord(RecordTypes.AnimationInfo.typeID);
        if (animationInfo != null) {
            animationInfo.getAnimationInfoAtom().setFlag(4, bl);
            this.updateClientData();
        }
    }

    public boolean isAutoPlay() {
        AnimationInfo animationInfo = (AnimationInfo)this.getClientDataRecord(RecordTypes.AnimationInfo.typeID);
        if (animationInfo != null) {
            return animationInfo.getAnimationInfoAtom().getFlag(4);
        }
        return false;
    }

    public String getPath() {
        OEShapeAtom oEShapeAtom = (OEShapeAtom)this.getClientDataRecord(RecordTypes.OEShapeAtom.typeID);
        int n = oEShapeAtom.getOptions();
        HSLFSlideShow hSLFSlideShow = this.getSheet().getSlideShow();
        ExObjList exObjList = (ExObjList)hSLFSlideShow.getDocumentRecord().findFirstOfType(RecordTypes.ExObjList.typeID);
        if (exObjList == null) {
            return null;
        }
        Record[] recordArray = exObjList.getChildRecords();
        for (int i = 0; i < recordArray.length; ++i) {
            ExMCIMovie exMCIMovie;
            ExVideoContainer exVideoContainer;
            int n2;
            if (!(recordArray[i] instanceof ExMCIMovie) || (n2 = (exVideoContainer = (exMCIMovie = (ExMCIMovie)recordArray[i]).getExVideo()).getExMediaAtom().getObjectId()) != n) continue;
            return exVideoContainer.getPathAtom().getText();
        }
        return null;
    }
}

