/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.model;

import ai2.org.apache.poi.hslf.record.CString;
import ai2.org.apache.poi.hslf.record.Document;
import ai2.org.apache.poi.hslf.record.HeadersFootersContainer;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.hslf.usermodel.HSLFSheet;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlideShow;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextShape;

public final class HeadersFooters {
    private HeadersFootersContainer _container;
    private boolean _newRecord;
    private HSLFSlideShow _ppt;
    private HSLFSheet _sheet;
    private boolean _ppt2007;

    public HeadersFooters(HeadersFootersContainer headersFootersContainer, HSLFSlideShow hSLFSlideShow, boolean bl, boolean bl2) {
        this._container = headersFootersContainer;
        this._newRecord = bl;
        this._ppt = hSLFSlideShow;
        this._ppt2007 = bl2;
    }

    public HeadersFooters(HeadersFootersContainer headersFootersContainer, HSLFSheet hSLFSheet, boolean bl, boolean bl2) {
        this._container = headersFootersContainer;
        this._newRecord = bl;
        this._sheet = hSLFSheet;
        this._ppt2007 = bl2;
    }

    public String getHeaderText() {
        CString cString = this._container == null ? null : this._container.getHeaderAtom();
        return this.getPlaceholderText(10, cString);
    }

    public void setHeaderText(String string) {
        if (this._newRecord) {
            this.attach();
        }
        this.setHeaderVisible(true);
        CString cString = this._container.getHeaderAtom();
        if (cString == null) {
            cString = this._container.addHeaderAtom();
        }
        cString.setText(string);
    }

    public String getFooterText() {
        CString cString = this._container == null ? null : this._container.getFooterAtom();
        return this.getPlaceholderText(9, cString);
    }

    public void setFootersText(String string) {
        if (this._newRecord) {
            this.attach();
        }
        this.setFooterVisible(true);
        CString cString = this._container.getFooterAtom();
        if (cString == null) {
            cString = this._container.addFooterAtom();
        }
        cString.setText(string);
    }

    public String getDateTimeText() {
        CString cString = this._container == null ? null : this._container.getUserDateAtom();
        return this.getPlaceholderText(7, cString);
    }

    public void setDateTimeText(String string) {
        if (this._newRecord) {
            this.attach();
        }
        this.setUserDateVisible(true);
        this.setDateTimeVisible(true);
        CString cString = this._container.getUserDateAtom();
        if (cString == null) {
            cString = this._container.addUserDateAtom();
        }
        cString.setText(string);
    }

    public boolean isFooterVisible() {
        return this.isVisible(32, 9);
    }

    public void setFooterVisible(boolean bl) {
        if (this._newRecord) {
            this.attach();
        }
        this._container.getHeadersFootersAtom().setFlag(32, bl);
    }

    public boolean isHeaderVisible() {
        return this.isVisible(16, 10);
    }

    public void setHeaderVisible(boolean bl) {
        if (this._newRecord) {
            this.attach();
        }
        this._container.getHeadersFootersAtom().setFlag(16, bl);
    }

    public boolean isDateTimeVisible() {
        return this.isVisible(1, 7);
    }

    public void setDateTimeVisible(boolean bl) {
        if (this._newRecord) {
            this.attach();
        }
        this._container.getHeadersFootersAtom().setFlag(1, bl);
    }

    public boolean isUserDateVisible() {
        return this.isVisible(4, 7);
    }

    public void setUserDateVisible(boolean bl) {
        if (this._newRecord) {
            this.attach();
        }
        this._container.getHeadersFootersAtom().setFlag(4, bl);
    }

    public boolean isSlideNumberVisible() {
        return this.isVisible(8, 8);
    }

    public void setSlideNumberVisible(boolean bl) {
        if (this._newRecord) {
            this.attach();
        }
        this._container.getHeadersFootersAtom().setFlag(8, bl);
    }

    public int getDateTimeFormat() {
        return this._container.getHeadersFootersAtom().getFormatId();
    }

    public void setDateTimeFormat(int n) {
        if (this._newRecord) {
            this.attach();
        }
        this._container.getHeadersFootersAtom().setFormatId(n);
    }

    private void attach() {
        Document document = this._ppt.getDocumentRecord();
        Record[] recordArray = document.getChildRecords();
        Record record = null;
        for (int i = 0; i < recordArray.length; ++i) {
            if (recordArray[i].getRecordType() != (long)RecordTypes.List.typeID) continue;
            record = recordArray[i];
            break;
        }
        document.addChildAfter(this._container, record);
        this._newRecord = false;
    }

    private boolean isVisible(int n, int n2) {
        boolean bl;
        if (this._ppt2007) {
            HSLFSheet hSLFSheet = this._sheet != null ? this._sheet : (HSLFSheet)this._ppt.getSlideMasters().get(0);
            HSLFTextShape hSLFTextShape = hSLFSheet.getPlaceholder(n2);
            bl = hSLFTextShape != null && hSLFTextShape.getText() != null;
        } else {
            bl = this._container.getHeadersFootersAtom().getFlag(n);
        }
        return bl;
    }

    private String getPlaceholderText(int n, CString cString) {
        String string = null;
        if (this._ppt2007) {
            HSLFSheet hSLFSheet = this._sheet != null ? this._sheet : (HSLFSheet)this._ppt.getSlideMasters().get(0);
            HSLFTextShape hSLFTextShape = hSLFSheet.getPlaceholder(n);
            if (hSLFTextShape != null) {
                string = hSLFTextShape.getText();
            }
            if ("*".equals(string)) {
                string = null;
            }
        } else {
            string = cString == null ? null : cString.getText();
        }
        return string;
    }
}

