/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.model;

import ai2.org.apache.poi.ddf.AbstractEscherOptRecord;
import ai2.org.apache.poi.ddf.EscherClientDataRecord;
import ai2.org.apache.poi.ddf.EscherComplexProperty;
import ai2.org.apache.poi.ddf.EscherContainerRecord;
import ai2.org.apache.poi.ddf.EscherRecord;
import ai2.org.apache.poi.ddf.EscherSpRecord;
import ai2.org.apache.poi.hslf.exceptions.HSLFException;
import ai2.org.apache.poi.hslf.record.Document;
import ai2.org.apache.poi.hslf.record.ExControl;
import ai2.org.apache.poi.hslf.record.ExObjList;
import ai2.org.apache.poi.hslf.record.OEShapeAtom;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.hslf.usermodel.HSLFPictureData;
import ai2.org.apache.poi.hslf.usermodel.HSLFPictureShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFShape;
import ai2.org.apache.poi.hslf.usermodel.HSLFSheet;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import ai2.org.apache.poi.sl.usermodel.ShapeContainer;
import ai2.org.apache.poi.sl.usermodel.ShapeType;
import ai2.org.apache.poi.util.LittleEndian;
import ai2.org.apache.poi.util.StringUtil;
import java.io.ByteArrayOutputStream;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ActiveXShape
extends HSLFPictureShape {
    public static final int DEFAULT_ACTIVEX_THUMBNAIL = -1;

    public ActiveXShape(int n, HSLFPictureData hSLFPictureData) {
        super(hSLFPictureData, null);
        this.setActiveXIndex(n);
    }

    protected ActiveXShape(EscherContainerRecord escherContainerRecord, ShapeContainer<HSLFShape, HSLFTextParagraph> shapeContainer) {
        super(escherContainerRecord, shapeContainer);
    }

    @Override
    protected EscherContainerRecord createSpContainer(int n, boolean bl) {
        this._escherContainer = super.createSpContainer(n, bl);
        EscherSpRecord escherSpRecord = (EscherSpRecord)this._escherContainer.getChildById((short)-4086);
        escherSpRecord.setFlags(2576);
        this.setShapeType(ShapeType.HOST_CONTROL);
        this.setEscherProperty((short)267, n);
        this.setEscherProperty((short)448, 0x8000001);
        this.setEscherProperty((short)511, 524296);
        this.setEscherProperty((short)513, 0x8000002);
        this.setEscherProperty((short)127, -1);
        EscherClientDataRecord escherClientDataRecord = new EscherClientDataRecord();
        escherClientDataRecord.setOptions((short)15);
        this._escherContainer.addChildRecord(escherClientDataRecord);
        OEShapeAtom oEShapeAtom = new OEShapeAtom();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            oEShapeAtom.writeOut(byteArrayOutputStream);
        }
        catch (Exception exception) {
            throw new HSLFException(exception);
        }
        escherClientDataRecord.setRemainingData(byteArrayOutputStream.toByteArray());
        return this._escherContainer;
    }

    public void setActiveXIndex(int n) {
        EscherContainerRecord escherContainerRecord = this.getSpContainer();
        Iterator<EscherRecord> iterator = escherContainerRecord.getChildIterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = iterator.next();
            if (escherRecord.getRecordId() != -4079) continue;
            EscherClientDataRecord escherClientDataRecord = (EscherClientDataRecord)escherRecord;
            byte[] byArray = escherClientDataRecord.getRemainingData();
            LittleEndian.putInt(byArray, 8, n);
        }
    }

    public int getControlIndex() {
        int n = -1;
        OEShapeAtom oEShapeAtom = (OEShapeAtom)this.getClientDataRecord(RecordTypes.OEShapeAtom.typeID);
        if (oEShapeAtom != null) {
            n = oEShapeAtom.getOptions();
        }
        return n;
    }

    public void setProperty(String string, String string2) {
    }

    public ExControl getExControl() {
        int n = this.getControlIndex();
        ExControl exControl = null;
        Document document = this.getSheet().getSlideShow().getDocumentRecord();
        ExObjList exObjList = (ExObjList)document.findFirstOfType(RecordTypes.ExObjList.typeID);
        if (exObjList != null) {
            Record[] recordArray = exObjList.getChildRecords();
            for (int i = 0; i < recordArray.length; ++i) {
                ExControl exControl2;
                if (!(recordArray[i] instanceof ExControl) || (exControl2 = (ExControl)recordArray[i]).getExOleObjAtom().getObjID() != n) continue;
                exControl = exControl2;
                break;
            }
        }
        return exControl;
    }

    @Override
    protected void afterInsert(HSLFSheet hSLFSheet) {
        ExControl exControl = this.getExControl();
        exControl.getExControlAtom().setSlideId(hSLFSheet._getSheetNumber());
        String string = exControl.getProgId() + "-" + this.getControlIndex() + '\u0000';
        byte[] byArray = StringUtil.getToUnicodeLE(string);
        EscherComplexProperty escherComplexProperty = new EscherComplexProperty(896, false, byArray);
        AbstractEscherOptRecord abstractEscherOptRecord = this.getEscherOptRecord();
        abstractEscherOptRecord.addEscherProperty(escherComplexProperty);
    }
}

