/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.extractor;

import ai2.org.apache.poi.hslf.record.CString;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.RecordAtom;
import ai2.org.apache.poi.hslf.record.RecordTypes;
import ai2.org.apache.poi.hslf.record.TextBytesAtom;
import ai2.org.apache.poi.hslf.record.TextCharsAtom;
import ai2.org.apache.poi.hslf.usermodel.HSLFTextParagraph;
import ai2.org.apache.poi.poifs.filesystem.DocumentEntry;
import ai2.org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QuickButCruddyTextExtractor {
    private NPOIFSFileSystem fs;
    private InputStream is;
    private byte[] pptContents;

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length < 1) {
            System.err.println("Useage:");
            System.err.println("\tQuickButCruddyTextExtractor <file>");
            System.exit(1);
        }
        String string = stringArray[0];
        QuickButCruddyTextExtractor quickButCruddyTextExtractor = new QuickButCruddyTextExtractor(string);
        System.out.println(quickButCruddyTextExtractor.getTextAsString());
        quickButCruddyTextExtractor.close();
    }

    public QuickButCruddyTextExtractor(String string) throws IOException {
        this(new NPOIFSFileSystem(new File(string)));
    }

    public QuickButCruddyTextExtractor(InputStream inputStream) throws IOException {
        this(new NPOIFSFileSystem(inputStream));
        this.is = inputStream;
    }

    public QuickButCruddyTextExtractor(NPOIFSFileSystem nPOIFSFileSystem) throws IOException {
        this.fs = nPOIFSFileSystem;
        DocumentEntry documentEntry = (DocumentEntry)this.fs.getRoot().getEntry("PowerPoint Document");
        this.pptContents = new byte[documentEntry.getSize()];
        this.fs.createDocumentInputStream("PowerPoint Document").read(this.pptContents);
    }

    public void close() throws IOException {
        if (this.is != null) {
            this.is.close();
        }
        this.fs = null;
    }

    public String getTextAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        List<String> list = this.getTextAsVector();
        for (String string : list) {
            stringBuffer.append(string);
            if (string.endsWith("\n")) continue;
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public List<String> getTextAsVector() {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n != -1) {
            int n2;
            n = n2 = this.findTextRecords(n, arrayList);
        }
        return arrayList;
    }

    public int findTextRecords(int n, List<String> list) {
        int n2;
        String string;
        RecordAtom recordAtom;
        int n3 = (int)LittleEndian.getUInt(this.pptContents, n + 4);
        byte by = this.pptContents[n];
        int n4 = by & 0xF;
        if (n4 == 15) {
            return n + 8;
        }
        int n5 = LittleEndian.getUShort(this.pptContents, n + 2);
        if (n5 == RecordTypes.TextBytesAtom.typeID) {
            recordAtom = (TextBytesAtom)Record.createRecordForType(n5, this.pptContents, n, n3 + 8);
            string = HSLFTextParagraph.toExternalString(((TextBytesAtom)recordAtom).getText(), -1);
            list.add(string);
        }
        if (n5 == RecordTypes.TextCharsAtom.typeID) {
            recordAtom = (TextCharsAtom)Record.createRecordForType(n5, this.pptContents, n, n3 + 8);
            string = HSLFTextParagraph.toExternalString(((TextCharsAtom)recordAtom).getText(), -1);
            list.add(string);
        }
        if (n5 == RecordTypes.CString.typeID && !(string = ((CString)(recordAtom = (CString)Record.createRecordForType(n5, this.pptContents, n, n3 + 8))).getText()).equals("___PPT10") && !string.equals("Default Design")) {
            list.add(string);
        }
        if ((n2 = n + 8 + n3) > this.pptContents.length - 8) {
            n2 = -1;
        }
        return n2;
    }
}

