/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.dev;

import ai2.org.apache.poi.hslf.record.CurrentUserAtom;
import ai2.org.apache.poi.hslf.record.PersistPtrHolder;
import ai2.org.apache.poi.hslf.record.PositionDependentRecord;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.UserEditAtom;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlideShowImpl;
import ai2.org.apache.poi.util.LittleEndian;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Hashtable;

public final class UserEditAndPersistListing {
    private static byte[] fileContents;

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Record record;
        int n;
        if (stringArray.length < 1) {
            System.err.println("Need to give a filename");
            System.exit(1);
        }
        HSLFSlideShowImpl hSLFSlideShowImpl = new HSLFSlideShowImpl(stringArray[0]);
        fileContents = hSLFSlideShowImpl.getUnderlyingBytes();
        System.out.println("");
        Record[] recordArray = hSLFSlideShowImpl.getRecords();
        int n2 = 0;
        for (n = 0; n < recordArray.length; ++n) {
            record = recordArray[n];
            if (record.getRecordType() == 6001L) {
                System.out.println("Found PersistPtrFullBlock at " + n2 + " (" + Integer.toHexString(n2) + ")");
            }
            if (record.getRecordType() == 6002L) {
                System.out.println("Found PersistPtrIncrementalBlock at " + n2 + " (" + Integer.toHexString(n2) + ")");
                object = (PersistPtrHolder)record;
                int[] nArray = ((PersistPtrHolder)object).getKnownSlideIDs();
                Hashtable<Integer, Integer> hashtable = ((PersistPtrHolder)object).getSlideLocationsLookup();
                for (int i = 0; i < nArray.length; ++i) {
                    Integer n3 = nArray[i];
                    Integer n4 = (Integer)hashtable.get(n3);
                    System.out.println("  Knows about sheet " + n3);
                    System.out.println("    That sheet lives at " + n4);
                    Record record2 = UserEditAndPersistListing.findRecordAtPos(n4);
                    System.out.println("    The record at that pos is of type " + record2.getRecordType());
                    System.out.println("    The record at that pos has class " + record2.getClass().getName());
                    if (record2 instanceof PositionDependentRecord) continue;
                    System.out.println("    ** The record class isn't position aware! **");
                }
            }
            object = new ByteArrayOutputStream();
            record.writeOut((OutputStream)object);
            n2 += ((ByteArrayOutputStream)object).size();
        }
        System.out.println("");
        n2 = 0;
        for (n = 0; n < recordArray.length; ++n) {
            record = recordArray[n];
            if (record instanceof UserEditAtom) {
                object = (UserEditAtom)record;
                System.out.println("Found UserEditAtom at " + n2 + " (" + Integer.toHexString(n2) + ")");
                System.out.println("  lastUserEditAtomOffset = " + ((UserEditAtom)object).getLastUserEditAtomOffset());
                System.out.println("  persistPointersOffset  = " + ((UserEditAtom)object).getPersistPointersOffset());
                System.out.println("  docPersistRef          = " + ((UserEditAtom)object).getDocPersistRef());
                System.out.println("  maxPersistWritten      = " + ((UserEditAtom)object).getMaxPersistWritten());
            }
            object = new ByteArrayOutputStream();
            record.writeOut((OutputStream)object);
            n2 += ((ByteArrayOutputStream)object).size();
        }
        System.out.println("");
        CurrentUserAtom currentUserAtom = hSLFSlideShowImpl.getCurrentUserAtom();
        System.out.println("Checking Current User Atom");
        System.out.println("  Thinks the CurrentEditOffset is " + currentUserAtom.getCurrentEditOffset());
        System.out.println("");
    }

    public static Record findRecordAtPos(int n) {
        long l = LittleEndian.getUShort(fileContents, n + 2);
        long l2 = LittleEndian.getUInt(fileContents, n + 4);
        Record record = Record.createRecordForType(l, fileContents, n, (int)l2 + 8);
        return record;
    }
}

