/*
 * Decompiled with CFR 0.152.
 */
package ai2.org.apache.poi.hslf.dev;

import ai2.org.apache.poi.hslf.model.textproperties.BitMaskTextProp;
import ai2.org.apache.poi.hslf.model.textproperties.TextProp;
import ai2.org.apache.poi.hslf.model.textproperties.TextPropCollection;
import ai2.org.apache.poi.hslf.record.Record;
import ai2.org.apache.poi.hslf.record.SlideListWithText;
import ai2.org.apache.poi.hslf.record.StyleTextPropAtom;
import ai2.org.apache.poi.hslf.record.TextBytesAtom;
import ai2.org.apache.poi.hslf.record.TextCharsAtom;
import ai2.org.apache.poi.hslf.usermodel.HSLFSlideShowImpl;
import java.util.List;

public final class TextStyleListing {
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 1) {
            System.err.println("Need to give a filename");
            System.exit(1);
        }
        HSLFSlideShowImpl hSLFSlideShowImpl = new HSLFSlideShowImpl(stringArray[0]);
        Record[] recordArray = hSLFSlideShowImpl.getRecords();
        for (int i = 0; i < recordArray.length; ++i) {
            if (recordArray[i].getRecordType() != 1000L) continue;
            Record record = recordArray[i];
            Record[] recordArray2 = record.getChildRecords();
            for (int j = 0; j < recordArray2.length; ++j) {
                if (!(recordArray2[j] instanceof SlideListWithText)) continue;
                Record[] recordArray3 = recordArray2[j].getChildRecords();
                int n = -1;
                for (int k = 0; k < recordArray3.length; ++k) {
                    if (recordArray3[k] instanceof TextCharsAtom) {
                        n = ((TextCharsAtom)recordArray3[k]).getText().length();
                    }
                    if (recordArray3[k] instanceof TextBytesAtom) {
                        n = ((TextBytesAtom)recordArray3[k]).getText().length();
                    }
                    if (!(recordArray3[k] instanceof StyleTextPropAtom)) continue;
                    StyleTextPropAtom styleTextPropAtom = (StyleTextPropAtom)recordArray3[k];
                    styleTextPropAtom.setParentTextSize(n);
                    TextStyleListing.showStyleTextPropAtom(styleTextPropAtom);
                }
            }
        }
    }

    public static void showStyleTextPropAtom(StyleTextPropAtom styleTextPropAtom) {
        System.out.println("\nFound a StyleTextPropAtom");
        List<TextPropCollection> list = styleTextPropAtom.getParagraphStyles();
        System.out.println("Contains " + list.size() + " paragraph styles:");
        for (int i = 0; i < list.size(); ++i) {
            TextPropCollection textPropCollection = list.get(i);
            System.out.println(" In paragraph styling " + i + ":");
            System.out.println("  Characters covered is " + textPropCollection.getCharactersCovered());
            TextStyleListing.showTextProps(textPropCollection);
        }
        List<TextPropCollection> list2 = styleTextPropAtom.getCharacterStyles();
        System.out.println("Contains " + list2.size() + " character styles:");
        for (int i = 0; i < list2.size(); ++i) {
            TextPropCollection textPropCollection = list2.get(i);
            System.out.println("  In character styling " + i + ":");
            System.out.println("    Characters covered is " + textPropCollection.getCharactersCovered());
            TextStyleListing.showTextProps(textPropCollection);
        }
    }

    public static void showTextProps(TextPropCollection textPropCollection) {
        List<TextProp> list = textPropCollection.getTextPropList();
        System.out.println("    Contains " + list.size() + " TextProps");
        for (int i = 0; i < list.size(); ++i) {
            TextProp textProp = list.get(i);
            System.out.println("      " + i + " - " + textProp.getName());
            System.out.println("          = " + textProp.getValue());
            System.out.println("          @ " + textProp.getMask());
            if (!(textProp instanceof BitMaskTextProp)) continue;
            BitMaskTextProp bitMaskTextProp = (BitMaskTextProp)textProp;
            String[] stringArray = bitMaskTextProp.getSubPropNames();
            boolean[] blArray = bitMaskTextProp.getSubPropMatches();
            for (int j = 0; j < stringArray.length; ++j) {
                System.out.println("            -> " + j + " - " + stringArray[j]);
                System.out.println("               " + j + " = " + blArray[j]);
            }
        }
    }
}

